//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: Piostream.h,v 0.27 1995/01/20 15:14:52 cncl-adm Exp cncl-adm $
 *
 * Class: CNPiostream --- persistent iostream format
 *
 *****************************************************************************
 * Copyright (C) 1992-1995   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@dfv.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#ifndef __CNPiostream_h
#define __CNPiostream_h

#include <CNCL/Class.h>
#include <CNCL/Param.h>

#include <CNCL/Pstream.h>		// Base class
#include <iostream.h>

extern CNClassDesc CN_PIOSTREAM;	// Class CNPiostream description


/*
 * The class CNPiostream
 */

class CNPiostream : public CNPstream
{
  public:	/***** Constructors ******************************************/
    CNPiostream(iostream& s) {strm=&s;}   	      	// constructor
    CNPiostream(CNParam *param) {}			// CNParam constructor

  public:	/***** Public interface **************************************/
    virtual CNPstream& operator<<(const char*);
    virtual CNPstream& operator<<(char);
    virtual CNPstream& operator<<(long);
    virtual CNPstream& operator<<(double);

    virtual CNPstream& operator>>(char*);
    virtual CNPstream& operator>>(char&);
    virtual CNPstream& operator>>(long&);
    virtual CNPstream& operator>>(double&);

    virtual CNPstream& getline(char*, int);
    
    
  private:	/***** Internal private members ******************************/
    iostream* strm;	// pointer to io stream  

  public:	/***** Member functions required by CNCL *********************/
    virtual CNClassDesc class_desc() const	// CNClass description
    { return CN_PIOSTREAM; }
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    { return desc == CN_PIOSTREAM ? TRUE : CNPstream::is_a(desc); }
        
    static CNPiostream *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNPiostream *)obj;
#   else
	return (CNPiostream *)( !obj || obj->is_a(CN_PIOSTREAM)
	       ? obj : fatal_type(obj->class_desc(), CN_PIOSTREAM) );
#   endif
    }
    
};

#endif /**__CNPiostream_h**/


