//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: RndInt.h,v 0.27 1995/01/20 15:13:51 cncl-adm Exp cncl-adm $
 *
 * CNClass: CNRndInt --- CNRandom Integers
 *
 *****************************************************************************
 * Copyright (C) 1992-1995   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@dfv.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *****************************************************************************
 * original Copyright:
 * -------------------
 * Copyright (C) 1988 Free Software Foundation
 *    written by Dirk Grunwald (grunwald@cs.uiuc.edu)
 * 
 * This file is part of the GNU C++ Library.  This library is free
 * software; you can redistribute it and/or modify it under the terms of
 * the GNU Library General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your
 * option) any later version.  This library is distributed in the hope
 * that it will be useful, but WITHOUT ANY WARRANTY; without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU Library General Public License for more details.
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 **EHEADER********************************************************************/

#ifndef __RndInt_h
#define __RndInt_h


#include <CNCL/Class.h>
#include <CNCL/Param.h>

#include <CNCL/Object.h>		// Base class
#include <CNCL/RNG.h>

extern CNClassDesc CN_RNDINT;	// CNClass CNRndInt description



/*
 * The class CNRndInt
 */

class CNRndInt : public CNObject
{
protected:
    long  pLow;
    long  pHigh;
    CNRNG  *pGenerator;
    
    long _asLong(long, long);

public:
    long low() const;
    long high() const;
    CNRNG* generator() const;

    long low(long x);
    long high(long x);
    CNRNG* generator(CNRNG *gen);

    long as_long();
    long operator()(); // synonym for asLong
    int  as_int();      // (possibly) truncate as int

    long as_long(long high);
    long as_long(long low, long high);
    int  as_int(int high);
    int  as_int(int low, int high);
    
    long operator () (long high);  // synonyms
    long operator () (long low, long high);

    /***** Constructors ******************************************************/
public:
    CNRndInt();				// Default constructor
    CNRndInt(CNParam *param);			// CNParam constructor
    CNRndInt(long low, long high, CNRNG *gen);
    CNRndInt(long high, CNRNG *gen);
    CNRndInt(CNRNG *gen);

    /***** Member functions required by CNCL *********************************/
public:
    virtual CNClassDesc class_desc() const	// CNClass description
    {
	return CN_RNDINT;
    };
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    {
	return desc == CN_RNDINT ? TRUE : CNObject::is_a(desc);
    };
        
    static CNRndInt *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNRndInt *)obj;
#   else
	return (CNRndInt *)( !obj || obj->is_a(CN_RNDINT)
	       ? obj : fatal_type(obj->class_desc(), CN_RNDINT) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new CNRndInt(param) : new CNRndInt; }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};



inline CNRndInt::CNRndInt(long low, long high, CNRNG *gen) 
    : pLow((low < high) ? low : high),
      pHigh((low < high) ? high : low),
      pGenerator(gen)
{}

inline CNRndInt::CNRndInt(long high, CNRNG *gen) 
    : pLow((0 < high) ? 0 : high),
      pHigh((0 < high) ? high : 0),
      pGenerator(gen)
{}
  

inline CNRndInt::CNRndInt(CNRNG *gen)
    : pLow(0),
      pHigh(1),
      pGenerator(gen)

{}

inline CNRndInt::CNRndInt()
    : pLow(0),
      pHigh(0),
      pGenerator(NIL)
{}

inline CNRndInt::CNRndInt(CNParam *param)
    : pLow(0),
      pHigh(0),
      pGenerator(NIL)
{}

inline CNRNG* CNRndInt::generator() const { return pGenerator;}
inline long CNRndInt::low() const       { return pLow; }
inline long CNRndInt::high() const      { return pHigh; }

inline CNRNG* CNRndInt::generator(CNRNG *gen) 
{
    CNRNG *tmp = pGenerator; pGenerator = gen;  return tmp;
}

inline long CNRndInt::low(long x)  
{
    long tmp = pLow;  pLow = x;  return tmp;
}

inline long CNRndInt:: high(long x) 
{
  long tmp = pHigh; pHigh = x; return tmp;
}

inline long CNRndInt:: _asLong(long low, long high)
{	
    return (pGenerator->as_long32() % (high-low+1)) + low;
}


inline long CNRndInt:: as_long() 
{
    return _asLong(pLow, pHigh);
}

inline long CNRndInt:: as_long(long high)
{
    return _asLong(pLow, high);
}

inline long CNRndInt:: as_long(long low, long high)
{
    return _asLong(low, high);
}

inline long CNRndInt:: operator () () 
{
    return _asLong(pLow, pHigh);
}

inline long CNRndInt:: operator () (long high)
{
    return _asLong(pLow, high);
}

inline long CNRndInt:: operator () (long low, long high)
{
    return _asLong(low, high);
}

inline int CNRndInt:: as_int() 
{
    return int(as_long());
}

inline int CNRndInt:: as_int(int high)
{
    return _asLong(pLow, high);
}

inline int CNRndInt:: as_int(int low, int high)
{
    return _asLong(low, high);
}
    
#endif /**__RndInt_h**/
