//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * Class: CNArray2Float  --- float array class
 *
 * Created from
 * $Id: T_array2.hP,v 0.27 1995/01/20 15:14:47 cncl-adm Exp cncl-adm $
 *
 *****************************************************************************
 * Copyright (C) 1992-1995   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@dfv.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#ifndef __Array2Float_h
#define __Array2Float_h


#include <CNCL/Class.h>
#include <CNCL/Param.h>
#include <CNCL/Array2.h>
#include <CNCL/ArrayFloat.h>

extern CNClassDesc CN_ARRAY2FLOAT;	// CNClass CNArray2Float description


/*
 * The class CNArray2Float
 */


class CNArray2Float : public CNArray2
{
  public:	/***** Public interface **************************************/
    virtual void size(int r, int c);

    void put(int r, int c, float value)// Put value into array
    {
#   ifndef NO_RANGE_CHECK
	if(r<0 || arows<=r || c<0 || acols<=c)
	    range_error(r, c);
	else
#   endif
	    array[r][c] = value;
    }

    float get(int r, int c) const	// Get value from array
    {
#   ifndef NO_RANGE_CHECK
	if(r<0 || arows<=r || c<0 || acols<=c)
	{   range_error(r, c); return 0; }
	else
#   endif
	    return array[r][c];
    }

    CNArrayFloat& operator[] (int index)	// Operator []
    {
#   ifndef NO_RANGE_CHECK
	if (index<0 || arows<=index)
	    range_error(index);
#   endif
	return array[index];
    }

  private:	/***** Internal private members ******************************/
    CNArrayFloat *array;		// Array of array of float
    float def_val;			// Default value
    
    void init(int r, int c);		// Initialize array
    void delete_array();                // Delete array

  public:	/***** Constructors ******************************************/
    CNArray2Float()               : CNArray2(0,0), array(NIL), def_val(0) {}
    CNArray2Float(CNParam *param) : CNArray2(0,0), array(NIL), def_val(0) {}
    CNArray2Float(int r, int c, float def=0);
    CNArray2Float(const CNArray2Float &a);		// Copy constructor

    ~CNArray2Float();

    CNArray2Float &operator = (const CNArray2Float &a);
    

  public:	/***** Member functions required by CNCL *********************/
    virtual CNClassDesc class_desc() const	// CNClass description
    { return CN_ARRAY2FLOAT; }
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    { return desc == CN_ARRAY2FLOAT ? TRUE : CNArray2::is_a(desc); }
        
    static CNArray2Float *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNArray2Float *)obj;
#   else
	return (CNArray2Float *)( !obj || obj->is_a(CN_ARRAY2FLOAT)
	       ? obj : fatal_type(obj->class_desc(), CN_ARRAY2FLOAT) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new CNArray2Float(param) : new CNArray2Float; }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};

#endif /**__Array2Float_h**/
