//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_                C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_                          N E T W O R K S
 * |_        |_  |_  |_  |_        |_                                C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_                      L I B R A R Y
 *
 * $Id: DLREF.h,v 0.20 1994/04/19 10:00:00 cncl-adm Exp cncl-adm $
 *
 * Class: CNDLREF --- Discrete LRE (LRE III) for distribution function
 *
 *****************************************************************************
 * Copyright (C) 1992-1995   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@dfv.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#ifndef __DLREF_h
#define __DLREF_h


/****************************************************************************/
/*                                                                          */
/* letzte Aenderung: 19.04.94                   erstellt am 19.04.94        */
/****************************************************************************/

#include <CNCL/CNCL.h>
#include <CNCL/Class.h>
#include <CNCL/Param.h>
#include <CNCL/Statistics.h>
#include <values.h>
#include <math.h>
#include <fstream.h>
#include <iomanip.h>

extern CNClassDesc CN_DLREF;      // CNClass CNDLREF description

/*
 * The class CNDLREF
 */

class CNDLREF : public CNStatistics 
{
protected:
    enum {NO_INDEX=-3, GREATER=-2, LOWER=-1};    // returned by get_index
    const unsigned long MAX_U_LONG = 4294967291; // = 2^32 - 1
    struct result 
    {
        double x;
        long h;
        long c;
    };
    struct result * x;                  // array of results
    double          reler_max;          // max. relative error
    unsigned long   nrv;                // number of trials
    unsigned long   max_nrv;            // maximal number of trials
    double          min_value;          // minimal value of trials
    double          max_value;          // maximal value of trials
    long            wasted_left;        // values lower minimum
    long            wasted_right;       // values greater maximum
    double          rv_sum;             // necess. for mean
    double          rv_square_sum;      // and variance
    long            h;                  // run time control (rtc) counter
    long            n0;                 // trials without rtc
    long            xoffset;            // offset of x-values (step 1)
    double          xmin;               // minimum of x
    double          xmax;               // maximum of x
    long            index_min;          // begin of array; normaly 0
    long            index_max;          // end of array 
    bool            equi_dist;          // 
    double          int_size;           // distance between x values
    char *          name;               // name of output file
    char *          text;               // short text, eg. an explanation
    long            cur_index;          // index of current x-value
    double          pre_rv;             // predecessor
    long            pre_index;          // index of predecessor
    double          base;               // needed for conditional probabilties
    Phase           phase;              // state of DLREF
    bool            end_reached;        // end of evaluation reached ?
    long            cur_level_index;    // index of current x-level
    long            get_index( double );// get index of current x
    Phase           rtc();              // runtime-control
    
    /***** Constructors ******************************************************/
public:
    CNDLREF( double* =NIL, long=10, double =0.05, double =0.0, 
        char* ="Without name", char* ="Without text",
        unsigned long =MAX_U_LONG );
    CNDLREF( double, double, double =1.0, double =0.05, double = 0.0, 
        char* ="Without name", char* ="Without text", 
        unsigned long =MAX_U_LONG ); 
    CNDLREF ( CNParam *param) {}  // CNParam constructor
    ~CNDLREF() {}
public: 
    void                  put( double );
    virtual short         fwrite( char * );
    virtual void          set_base( double b ) 
                          { base = b; }       //set factor for cond. prob.
    virtual void          change_error( double ne ) 
                          { reler_max = ne; } //maybe usefull
    virtual double        cur_x_lev() 
                          { return x[ cur_level_index ].x; }
    virtual double        cur_f_lev();        // returns current x- esp. f-level
    virtual double        f( double xt );     // returns the f-level of xt
    virtual double        p( double xt );     // returns the prob. of xt 
    virtual double        mean()              const;
    virtual double        variance()          const;
    virtual unsigned long trials()            const { return nrv; }
    virtual double        min()               const { return min_value; }
    virtual double        max()               const { return max_value; }
    virtual bool          end()               const { return end_reached; }
    virtual Phase         status()            const { return phase; }
    
    /***** Member functions required by CNCL *********************************/
public:
    virtual CNClassDesc class_desc() const      // CNClass description
    {
        return CN_DLREF;
    };
            
    virtual bool is_a(CNClassDesc desc) const   // Type checking
    {
        return desc == CN_DLREF ? TRUE : CNStatistics::is_a(desc);
    };
        
    static CNDLREF *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
        return (CNDLREF *)obj;
#   else
        return (CNDLREF *)( obj->is_a(CN_DLREF)
               ? obj : fatal_type(obj->class_desc(), CN_DLREF) );
#   endif
    }
    
    // Print/debug output
    virtual void print( ostream &output=cout ) const; 
    virtual void dump( ostream &output=cout ) const {}
    virtual void reset() {}
};

#endif
