//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: EventIterator.h,v 0.27 1995/01/20 15:14:33 cncl-adm Exp cncl-adm $
 *
 * Class: CNEventIterator --- ...
 *
 *****************************************************************************
 * Copyright (C) 1992-1995   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@dfv.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 * 
 * As an exception to this rule you may use this template to generate
 * your own classes. This does not cause these classes to be covered by
 * the GNU Library General Public License. This exception does not
 * however invalidate any other reasons why the resulting program must be
 * covered by the GNU Library General Public License. 
 **EHEADER********************************************************************/

#ifndef __CNEventIterator_h
#define __CNEventIterator_h


#include <CNCL/Object.h>		// Base class

extern CNClassDesc CN_EVENTITERATOR;	// Class CNEventIterator description

class CNEvent;

/*
 * The class CNEventIterator
 */

class CNEventIterator : public CNObject
{
  protected:    /***** Constructors ******************************************/
    CNEventIterator() {}				// Default constructor
    CNEventIterator(CNParam *param) {}			// CNParam constructor

  public:	/***** Public interface **************************************/
    virtual CNEvent *next_event() = 0;           // returns an event
    virtual void delete_current_event() = 0;     // deletes last returned event
    
  private:	/***** Internal private members ******************************/

  protected:
    CNEvent *act_event;		// currently used event 
    bool use_current;           // flag
    
  public:	/***** Member functions required by CNCL *********************/
    virtual CNClassDesc class_desc() const	// CNClass description
    { return CN_EVENTITERATOR; }
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    { return desc == CN_EVENTITERATOR ? TRUE : CNObject::is_a(desc); }
        
    static CNEventIterator *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNEventIterator *)obj;
#   else
	return (CNEventIterator *)( !obj || obj->is_a(CN_EVENTITERATOR)
	       ? obj : fatal_type(obj->class_desc(), CN_EVENTITERATOR) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) {} // Object creation
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};



ostream &operator << (ostream &strm, const CNEventIterator &obj);
ostream &operator << (ostream &strm, const CNEventIterator *obj);

#endif /**__CNEventIterator_h**/
