//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: FormFloat.h,v 0.27 1995/01/20 15:14:22 cncl-adm Exp cncl-adm $
 *
 * Class: FormFloat --- Doubles as CNStrings
 *
 *****************************************************************************
 * Copyright (C) 1992-1995   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@dfv.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 * 
 **EHEADER********************************************************************/

#ifndef __CNFormFloat_h
#define __CNFormFloat_h



#include <CNCL/Class.h>
#include <CNCL/Param.h>
#include <CNCL/String.h>

extern CNClassDesc CN_FORMFLOAT;	// Class FormFloat description


/*
 * The class CNFormFloat
 */

class CNFormFloat : public CNString
{
  public:
    enum { right=1, left=2, scientific=4, showpoint=8, fixed=16 };


    double val;      // value of the double
    char cfill;      // fill character
    int form;    // form of the CNString
    int wide, prec;  // width of the CNString, precision of the double
    
  private:
    void initialize(double x, int l, char fill, int f = right, int p = 6);

    /***** Constructors ******************************************************/
  public:
    CNFormFloat()
    { initialize(0, 3, ' '        ); }
    CNFormFloat(CNParam *param)
    { initialize(0, 3, ' '        ); }
    CNFormFloat(double x, int w)
    { initialize(x, w, ' '        ); }
    CNFormFloat(double x, int w, char fill)   
    { initialize(x, w, fill       ); }
    CNFormFloat(double x, int w, char fill, int f)
    { initialize(x, w, fill, f    ); }
    CNFormFloat(double x, int w, char fill, int f, int pr)
    { initialize(x, w, fill, f, pr); }
    
    double get_value()     { return val; }    // returns the value 
    char get_fill()        { return cfill; }  // returns the filling char
    int get_format()       { return form; }   // returns the format
    int get_width()        { return wide; }   // returns the width
    int get_precision()    { return prec; }   // returns the precision  
    double value()         { return val; }    // returns the value 
    char fill()            { return cfill; }  // returns the filling char
    int format()           { return form; }   // returns the format
    int width()            { return wide; }   // returns the width
    int precision()        { return prec; }   // returns the precision

    void set_value(double x);     // changes String, sets value to x   
    void set_fill(char f);        // changes String, sets filling to f
    void set_format(int f);       // changes String, sets format to f 
    void set_width(int w);        // changes String's width to w
    void set_precision(int pr);   // changes String, sets precision to p
    void value(double x);         // changes String, sets value to x   
    void fill(char f);            // changes String, sets filling to f
    void format(int f);           // changes String, sets format to f 
    void width(int w);            // changes String's width to w
    void precision(int pr);       // changes String, sets precision to p

    /***** Member functions required by CNCL *********************************/
  public:
    virtual CNClassDesc class_desc() const	// CNClass description
    { return CN_FORMFLOAT; }
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    { return desc == CN_FORMFLOAT ? TRUE : CNString::is_a(desc); }
        
    static CNFormFloat *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNFormFloat *)obj;
#   else
	return (CNFormFloat *)( !obj || obj->is_a(CN_FORMFLOAT)
	       ? obj : fatal_type(obj->class_desc(), CN_FORMFLOAT) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new CNFormFloat(param) : new CNFormFloat; }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};

#endif /**__CNFormFloat_h**/
