//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: Uniform.h,v 0.27 1995/01/20 15:13:51 cncl-adm Exp cncl-adm $
 *
 * CNClass: CNUniform --- CNUniform distributed random numbers
 *
 *****************************************************************************
 * Copyright (C) 1992-1995   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@dfv.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *****************************************************************************
 * original Copyright:
 * -------------------
 * Copyright (C) 1988 Free Software Foundation
 *    written by Dirk Grunwald (grunwald@cs.uiuc.edu)
 * 
 * This file is part of the GNU C++ Library.  This library is free
 * software; you can redistribute it and/or modify it under the terms of
 * the GNU Library General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your
 * option) any later version.  This library is distributed in the hope
 * that it will be useful, but WITHOUT ANY WARRANTY; without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU Library General Public License for more details.
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 **EHEADER********************************************************************/


#ifndef __Uniform_h
#define __Uniform_h


#include <CNCL/Class.h>
#include <CNCL/Param.h>
#include <CNCL/Random.h>		// Base class

extern CNClassDesc CN_UNIFORM;	// CNClass CNUniform description



/*
 * The class CNUniform
 */

class CNUniform : public CNRandom
{
public:
    double low();
    double low(double x);
    double high();
    double high(double x);
    virtual double operator()();
    
    // Private members
private:
    double pLow;
    double pHigh;
    double delta;

    /***** Constructors ******************************************************/
public:

    CNUniform();       				// Default constructor
    CNUniform(double low, double high, CNRNG *gen);
    CNUniform(CNParam *param); 

    /***** Member functions required by CNCL *********************************/
public:
    virtual CNClassDesc class_desc() const	// CNClass description
    {
	return CN_UNIFORM;
    };
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    {
	return desc == CN_UNIFORM ? TRUE : CNRandom::is_a(desc);
    };
        
    static CNUniform *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNUniform *)obj;
#   else
	return (CNUniform *)( !obj || obj->is_a(CN_UNIFORM)
	       ? obj : fatal_type(obj->class_desc(), CN_UNIFORM) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new CNUniform(param) : new CNUniform; }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};



inline CNUniform::CNUniform(double low, double high, CNRNG *gen)
    : CNRandom(gen)
{
    pLow = (low < high) ? low : high;
    pHigh = (low < high) ? high : low;
    delta = pHigh - pLow;
}

inline double CNUniform::low() { return pLow; }

inline double CNUniform::low(double x) {
    double tmp = pLow;
    pLow = x;
    delta = pHigh - pLow;
    return tmp;
}

inline double CNUniform::high() { return pHigh; }

inline double CNUniform::high(double x) {
    double tmp = pHigh;
    pHigh = x;
    delta = pHigh - pLow;
    return tmp;
}
inline CNUniform::CNUniform(CNParam *param)
	 : CNRandom((CNRNG*)NIL)
{
     pLow = 0;
     pHigh = 0;
     delta = 0;
}    


inline CNUniform::CNUniform()
	 : CNRandom((CNRNG*)NIL)
{
    pLow = 0;
    pHigh = 0;
    delta = 0;
}    

#endif /**__Uniform_h**/
