// -*- C++ -*-

#include <stdlib.h>

#include "test.h"



void plot(CNFSet *set, double min, double max)
{
    double p, x, dx;
    int i, l;
    const int NX = 75, NY = 10;

    dx = (max - min) / NX;

    for(l=0; l<=NY; l++)
    {
	p = double(NY - l)/NY;
	if((l % 2) == 0)
	{
		cout.width(3);
	    cout << p << "-";
	}
	else
	    cout << "    ";
	for(i=0, x=min; i<=NX; i++, x+=dx)
	{
	    if(i==NX)
		x = max;
	    if(set->get_membership(x) >= p)
		cout << '#';
	    else
		cout << ' ';
	}
	cout << endl;
    }
}





main()
{
    test fr;
    
    cout << "//----- Fuzzy rules -----" << endl << fr.testbase << endl;

    while(TRUE)
    {
	double t;

	cout << "Temperature> ";
	cin  >> t;
	if(cin.eof() || !cin.good())
	    break;

	fr.temp.value(t);

	fr.temp.print_membership();

	fr.testbase.evaluate_all();
	fr.testbase.defuzzy_all();

	fr.testbase.debug_rules();

	plot(fr.heater.fuzzy_value(), 0, 1);
	
	cout << "Heater = " << fr.heater.value() << endl;
    }
    
    exit(0);
}


