//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: EZDQueue.h,v 0.27 1995/01/20 15:15:05 cncl-adm Exp cncl-adm $
 *
 * Class: EZDQueue --- Graphical representation of queue
 *
 *****************************************************************************
 * Copyright (C) 1992-1995   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@dfv.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#ifndef __EZDQueue_h
#define __EZDQueue_h


#include <CNCL/Class.h>
#include <CNCL/Param.h>

#include <CNCL/EZDObject.h>		// Base class

extern CNClassDesc CN_EZDQUEUE;	// Class EZDQueue description


/*
 * The class EZDQueue
 */

class EZDQueue : public EZDObject
{
public:
    // Return layout coordinates
    int left()   const { return x()+x1; }
    int right()  const { return x()+x4; }
    int upper()  const { return y()+y1; }
    int lower()  const { return y()+y2; }

    // Redraw queue
    virtual void redraw();

    // Set/draw bar
    int length()     const { return len; }
    void length(int l);
    int get_length() const { return len; }
    void set_length(int l);

    void color(const CNString &c) { col = c; redraw_bar(); }
    
    // Private members
private:
    // Layout parameters
    enum { WIDTH=100, HEIGHT=20, SEP=3, TAIL=20 };

    /*
     *  x=x1               x2x3    x4
     *  ----------------------       y1
     *            XXXXXXXXXX |       yb
     *            XXXXXXXXXX |-----  y
     *            XXXXXXXXXX |
     *  ----------------------       y2
     */
    int x1, x2, x3, x4;
    int y1, y2, yb;
    int h;
    EZDObject *bar;
    int len;
    CNString col;
    
    void initialize(int width, int height, int tail);
    void redraw_bar();
    
    /***** Constructors ******************************************************/
public:
    EZDQueue()
	: EZDObject("queue", 0, 0) { initialize(WIDTH, HEIGHT, TAIL); }
    EZDQueue(CNParam *param)
	: EZDObject("queue", 0, 0) { initialize(WIDTH, HEIGHT, TAIL); }
    EZDQueue(int x, int y,
	     int width=WIDTH, int height=HEIGHT, int tail=TAIL)
	: EZDObject("queue", x, y) { initialize(width, height, tail); }
    EZDQueue(const CNString &name, int x, int y,
	     int width=WIDTH, int height=HEIGHT, int tail=TAIL)
	: EZDObject(name, x, y)    { initialize(width, height, tail); }

    /***** Member functions required by CNCL *********************************/
public:
    virtual CNClassDesc class_desc() const	// CNClass description
    {
	return CN_EZDQUEUE;
    };
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    {
	return desc == CN_EZDQUEUE ? TRUE : EZDObject::is_a(desc);
    };
        
    static EZDQueue *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (EZDQueue *)obj;
#   else
	return (EZDQueue *)( !obj || obj->is_a(CN_EZDQUEUE)
	       ? obj : fatal_type(obj->class_desc(), CN_EZDQUEUE) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new EZDQueue(param) : new EZDQueue; }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};


#endif /**__EZDQueue_h**/
