//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id$
 *
 * Class: CNFNumTriangle --- Fuzzy number (triangle)
 *
 *****************************************************************************
 * Copyright (C) 1992-1995   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@dfv.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#ifndef __CNFNumTriangle_h
#define __CNFNumTriangle_h


#include <CNCL/Class.h>
#include <CNCL/Param.h>

#include <CNCL/FSetTriangle.h>		// Base class

extern CNClassDesc CN_FNUMTRIANGLE;	// Class CNFNumTriangle description


/*
 * The class CNFNumTriangle
 */

class CNFNumTriangle : public CNFSetTriangle
{
  public:	/***** Constructors ******************************************/
    CNFNumTriangle()                             : CNFSetTriangle(0, 0, 0) {}
    CNFNumTriangle(CNParam *param)               : CNFSetTriangle(0, 0, 0) {}
    CNFNumTriangle(double m, double a, double b) : CNFSetTriangle(m, a, b) {}
    CNFNumTriangle(const CNFNumTriangle &n);
    
  public:	/***** Public interface **************************************/
    virtual double center_of_gravity(double min, double max) const;
    double defuzzy() const;

    CNFNumTriangle operator - ();
    CNFNumTriangle operator + ();

    CNFNumTriangle & operator = (const CNFNumTriangle &n);

    friend CNFNumTriangle operator + (CNFNumTriangle, CNFNumTriangle);
    friend CNFNumTriangle operator - (CNFNumTriangle, CNFNumTriangle);
    friend CNFNumTriangle operator * (double, CNFNumTriangle);
    friend CNFNumTriangle operator * (CNFNumTriangle, double);

    friend CNFNumTriangle sqr(CNFNumTriangle);
    friend CNFNumTriangle abs(CNFNumTriangle);

  public:	/***** Member functions required by CNCL *********************/
    virtual CNClassDesc class_desc() const	// CNClass description
    { return CN_FNUMTRIANGLE; }
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    { return desc == CN_FNUMTRIANGLE ? TRUE : CNFSetTriangle::is_a(desc); }
        
    static CNFNumTriangle *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNFNumTriangle *)obj;
#   else
	return (CNFNumTriangle *)( !obj || obj->is_a(CN_FNUMTRIANGLE)
	       ? obj : fatal_type(obj->class_desc(), CN_FNUMTRIANGLE) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new CNFNumTriangle(param) : new CNFNumTriangle; }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};

#endif /**__CNFNumTriangle_h**/
