//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: LogNormal.h,v 0.27 1995/01/20 15:13:51 cncl-adm Exp cncl-adm $
 *
 * CNClass: CNLogNormal --- Log-normal distributed random numbers
 *
 *****************************************************************************
 * Copyright (C) 1992-1995   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@dfv.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *****************************************************************************
 * original Copyright:
 * -------------------
 * Copyright (C) 1988 Free Software Foundation
 *    written by Dirk Grunwald (grunwald@cs.uiuc.edu)
 * 
 * This file is part of the GNU C++ Library.  This library is free
 * software; you can redistribute it and/or modify it under the terms of
 * the GNU Library General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your
 * option) any later version.  This library is distributed in the hope
 * that it will be useful, but WITHOUT ANY WARRANTY; without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU Library General Public License for more details.
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 **EHEADER********************************************************************/

#ifndef __LogNormal_h
#define __LogNormal_h


#include <CNCL/Class.h>
#include <CNCL/Param.h>

#include <CNCL/Normal.h>		// Base class

extern CNClassDesc CN_LOGNORMAL;	// CNClass CNLogNormal description



/*
 * The class CNLogNormal
 */


class CNLogNormal : public CNNormal
{
protected:
    double logMean;
    double logVariance;
    void setState();

public:
    double mean();
    double mean(double x);
    double variance();
    double variance(double x);
    virtual double operator()();

    /***** Constructors ******************************************************/
public:
    CNLogNormal() {}				// Default constructor
    CNLogNormal(CNParam *param) {}			// CNParam constructor
    CNLogNormal(double mean, double variance, CNRNG *gen);

    /***** Member functions required by CNCL *********************************/
public:
    virtual CNClassDesc class_desc() const	// CNClass description
    {
	return CN_LOGNORMAL;
    };
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    {
	return desc == CN_LOGNORMAL ? TRUE : CNNormal::is_a(desc);
    };
        
    static CNLogNormal *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNLogNormal *)obj;
#   else
	return (CNLogNormal *)( !obj || obj->is_a(CN_LOGNORMAL)
	       ? obj : fatal_type(obj->class_desc(), CN_LOGNORMAL) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new CNLogNormal(param) : new CNLogNormal; }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};



inline void CNLogNormal::setState()
{
    double m2 = logMean * logMean;
    pMean = log(m2 / sqrt(logVariance + m2) );
// from ch@heike.informatik.uni-dortmund.de:
// (was pVariance = log((sqrt(logVariance + m2)/m2 )); )
    pStdDev = sqrt(log((logVariance + m2)/m2 ));
    pVariance = pStdDev*pStdDev;          // this line added
}

inline CNLogNormal::CNLogNormal(double mean, double variance, CNRNG *gen)
    : CNNormal(0, 0, gen)
{
    logMean = mean;
    logVariance = variance;
    setState();
}

inline double CNLogNormal::mean() {
    return logMean;
}

inline double CNLogNormal::mean(double x)
{
    double t=logMean; 
    logMean = x; 
    setState();
    return t;
}

inline double CNLogNormal::variance() {
    return logVariance;
}

inline double CNLogNormal::variance(double x)
{
    double t = logVariance; 
    logVariance = x; 
    setState();
    return t;
}

#endif /**__LogNormal_h**/
