// *BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: PArrayObject.h,v 0.27 1995/01/20 15:14:52 cncl-adm Exp cncl-adm $
 *
 * Class: CNPArrayObject --- persistentes ArrayObject 
 *
 *****************************************************************************
 * Copyright (C) 1992-1995   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@dfv.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#ifndef __CNPArrayObject_h
#define __CNPArrayObject_h


#include <CNCL/Class.h>
#include <CNCL/Param.h>


#include <CNCL/ArrayObject.h>		// Base class
#include <CNCL/PObjectID.h>             // Base class
#include <CNCL/PIO.h>		// Methodes for persistency




extern CNClassDesc CN_PARRAYOBJECT;	// Class CNPArrayObject description


/*
 * The class CNPArrayObject
 */

class CNPArrayObject : public CNArrayObject, CNPObjectID
{
  public:	/***** Constructors ******************************************/ 
    CNPArrayObject() : CNArrayObject(), CNPObjectID(){}
    CNPArrayObject(int s, CNObjPtr def=0): CNArrayObject(s,def),CNPObjectID(){}
    CNPArrayObject(CNPstream&);		
    CNPArrayObject(CNParam *param): CNArrayObject(), CNPObjectID(){}
    CNPArrayObject(const CNArrayObject &a): CNArrayObject(a), CNPObjectID(){}
    
    CNPArrayObject &operator=(const CNArrayObject &a)
    { CNArrayObject::operator=(a);}
    
    
  public:	/***** Public interface for persistent IO ********************/
    virtual int store_on(CNPstream& s) {return CNPIO::store_object(s, *this);}
    int store_on(CNPstream& s, bool no_ptr_check)
              {return CNPIO::store_object(s, *this, no_ptr_check);} 
    virtual int storer(CNPstream&);
    static CNObject* object_read_from(CNPstream& s)                                         {return CNPIO::read_object(s);}
    static CNPArrayObject* read_from(CNPstream& s)                                          {return CNPArrayObject::cast_from_object(CNPIO::read_object(s));}
    static CNPArrayObject* reader(CNPstream& s) {return new CNPArrayObject(s);}

    CNPID object_id() { return CNPObjectID::object_id(); } 

  private:	/***** Internal private members ******************************/

  public:	/***** Member functions required by CNCL *********************/
    virtual CNClassDesc class_desc() const	// CNClass description
    { return CN_PARRAYOBJECT; }
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    { return desc == CN_PARRAYOBJECT ? TRUE : CNArrayObject::is_a(desc); }
        
    static CNPArrayObject *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNPArrayObject *)obj;
#   else
	return (CNPArrayObject *)( !obj || obj->is_a(CN_PARRAYOBJECT)
	       ? obj : fatal_type(obj->class_desc(), CN_PARRAYOBJECT) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new CNPArrayObject(param) : new CNPArrayObject; }
    
};

#endif /**__CNPArrayObject_h**/
