//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id$
 *
 * Class: CNJob --- ...
 *
 *****************************************************************************
 * Copyright (C) 1992-1995   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@dfv.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 * 
 * As an exception to this rule you may use this template to generate
 * your own classes. This does not cause these classes to be covered by
 * the GNU Library General Public License. This exception does not
 * however invalidate any other reasons why the resulting program must be
 * covered by the GNU Library General Public License.
 **EHEADER********************************************************************/

#include "Job.h"






/***** Default I/O member function for CNCL classes **************************/

// Normal output
void CNJob::print(ostream &strm) const
{
    strm << "in=" << in << " start=" << start << " out=" << out << endl;
    strm << "priority=" << priority
    	 << " length=" << length << " orig_length=" << orig_length << endl;
}

// Debug output
void CNJob::dump(ostream &strm) const
{
    strm << "CNJob { $Revision$ ..." << endl;
    strm << "in=" << in << " start=" << start << " out=" << out << endl;
    strm << "priority=" << priority 
    	 << " length=" << length << " orig_length=" << orig_length << endl;
    strm << " }" << endl;
}



/***** CNCL stuff for type information ***************************************/

// Describing object for class CNJob
static CNClass CNJob_desc("CNJob", "$Revision$",
			    CNJob::new_object);

// "Type" for type checking functions
CNClassDesc CN_JOB = &CNJob_desc;
