//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: KeyInt.c,v 0.27 1995/01/20 15:13:35 cncl-adm Exp cncl-adm $
 *
 * CNClass: CNKeyInt --- CNObject management via integer keys
 *
 *****************************************************************************
 * Copyright (C) 1992-1995   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@dfv.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#include "KeyInt.h"


CNKeyInt::CNKeyInt(unsigned long key_int, CNObject *obj) : CNKey(obj)
{
    ki_CNKeyInt = key_int;
}

CNKeyInt::CNKeyInt(CNParam *param) : CNKey((CNObject *)NIL)
{
    fatal("CNKeyInt(CNParam *param) not yet implemented");
}

unsigned long CNKeyInt::hash(unsigned long capacity, int par) const
{
    unsigned long i=0;
    
    if (!par)
	// calc initial position in hash-table
	i = ki_CNKeyInt % capacity;
    else
	fatal("Parameters different from zero not yet implemented!");

    return i;
}

bool CNKeyInt::compare(CNKey *k) const
{
    CNClassDesc me = class_desc();
    CNClassDesc he = k->class_desc();
    CNKeyInt *ki;
    
    // trying to compare keys of different type
    if (me != he) 
 	fatal("Unable to compare keys of different type!\n",
	      "You tried to compare the following keys:\n",
	      me->name(), "\n", he->name(), "\n");

    // this is a save cast
    ki = (CNKeyInt *)k;
    return (ki_CNKeyInt == ki->get_key()) ? TRUE : FALSE;
}


/***** Default I/O member function for CNCL classes **************************/

// CNNormal output
void CNKeyInt::print(ostream &strm) const
{
    strm << "\nkey int = " << ki_CNKeyInt
	 << endl;

}

// Debug output
void CNKeyInt::dump(ostream &strm) const
{
    strm << "\nCNKeyInt { $Revision: 0.27 $"
	 << " key int = " << ki_CNKeyInt
	 << " }" << endl;
}



/***** CNCL stuff for type information and exemplar objects ******************/

// Describing object for class CNKeyInt
static CNClass CNKeyInt_desc("CNKeyInt", "$Revision: 0.27 $",
			  CNKeyInt::new_object);

// "Type" for type checking functions
CNClassDesc CN_KEYINT = &CNKeyInt_desc;






