//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: KeyString.c,v 0.27 1995/01/20 15:13:35 cncl-adm Exp cncl-adm $
 *
 * CNClass: CNKeyString --- CNObject management via string keys
 *
 *****************************************************************************
 * Copyright (C) 1992-1995   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@dfv.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#include "KeyString.h"



CNKeyString::CNKeyString(char *key_string, CNObject *obj) : CNKey(obj)
{
    ks_CNKeyString = key_string;
}

CNKeyString::CNKeyString(CNParam *param) : CNKey((CNObject *)NIL)
{
    fatal("CNKeyString(CNParam *param) not yet implemented");
}

unsigned long CNKeyString::hash(unsigned long capacity, int par) const
{
    unsigned long i=0;
    char k, *key_string = ks_CNKeyString;

    if (!par) {
	// calc initial position in hash-table
	for (i = 0; *key_string; key_string++) {
	    k = *key_string;
	    if (k < 0)
		k = -k;
	
	    i = (64 * i + k) % capacity;
	}
    } else {
	fatal("Parameters different from zero not yet implemented");
    }

    return i;
}

bool CNKeyString::compare(CNKey *k) const
{
    CNClassDesc me = class_desc();
    CNClassDesc he = k->class_desc();
    CNKeyString *ks;
    
    // trying to compare keys of different type
    if (me != he) 
 	fatal("Unable to compare keys of different type!\n",
	      "You tried to compare the following keys:\n",
	      me->name(), "\n", he->name(), "\n");

    // this is a save cast
    ks = (CNKeyString *)k;
    return (!strcmp(ks_CNKeyString, ks->get_key())) ? TRUE : FALSE;
}

/***** Default I/O member function for CNCL classes **************************/

// CNNormal output
void CNKeyString::print(ostream &strm) const
{
    strm << "\nkey string = " << ks_CNKeyString
	 << endl;
}

// Debug output
void CNKeyString::dump(ostream &strm) const
{
    strm << "\nCNKeyString { $Revision: 0.27 $"
	 << "key string = " << ks_CNKeyString
	 << " }" << endl;
}

/***** CNCL stuff for type information and exemplar objects ******************/

// Describing object for class CNKeyString
static CNClass CNKeyString_desc("CNKeyString", "$Revision: 0.27 $",
			  CNKeyString::new_object);

// "Type" for type checking functions
CNClassDesc CN_KEYSTRING = &CNKeyString_desc;






