//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: KeyString.h,v 0.27 1995/01/20 15:13:35 cncl-adm Exp cncl-adm $
 *
 * CNClass: CNKeyString --- CNObject management via string keys
 *
 *****************************************************************************
 * Copyright (C) 1992-1995   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@dfv.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#ifndef __KeyString_h
#define __KeyString_h


#include <CNCL/Class.h>
#include <CNCL/Param.h>

#include <CNCL/Key.h>		        // Base class

extern CNClassDesc CN_KEYSTRING;	// CNClass CNKeyString description

/*
 * The class CNKeyString
 */

class CNKeyString : public CNKey
{
    char *ks_CNKeyString;
    
public:
    char *get_key() const
    {
	return ks_CNKeyString;
    }

    virtual unsigned long hash(unsigned long capacity, int par = 0) const;
    virtual bool compare(CNKey *k) const;
    virtual bool compare(CNKey &k) const
    { return compare(&k); }

    /***** Constructors ******************************************************/
public:
    CNKeyString() : CNKey((CNObject *)NIL), ks_CNKeyString(NIL) {}
    CNKeyString(char *key_string, CNObject *obj = NIL);
    CNKeyString(CNParam *param);
    

    /***** Member functions required by CNCL *********************************/
public:
    virtual CNClassDesc class_desc() const	// CNClass description
    {
	return CN_KEYSTRING;
    };
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    {
	return desc == CN_KEYSTRING ? TRUE : CNKey::is_a(desc);
    };
        
    static CNKeyString *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNKeyString *)obj;
#   else
	return (CNKeyString *)( !obj || obj->is_a(CN_KEYSTRING)
	       ? obj : fatal_type(obj->class_desc(), CN_KEYSTRING) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new CNKeyString(param) : new CNKeyString; }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};


#endif /**__KeyString_h**/
