#include <CNCL/HashStatic.h>
#include <CNCL/HashDynamic.h>
#include <CNCL/KeyString.h>
#include <CNCL/KeyInt.h>
#include <CNCL/Manager.h>


int main(int argc, char **argv)
{
    CNHashStatic tab(200), tabi(2000);
    CNHashDynamic dtab(331);
    CNKeyString ks("Test", NIL);
    CNObject *obj = &ks; 


    cout << "static key string\n";
    
    // key_string
    tab.print();
    tab.store_key(new CNKeyString("Jabba", obj));
    tab.store_key(new CNKeyString("Dabba"));
    tab.store_key(new CNKeyString("Dooo"));
    
    tab.print();

    if (tab.get_object(CNKeyString("Jabba")) != obj)
	cout << "strange behaviour\n";
    else
	cout << "found obj\n";
    
    if (!tab.is_full())
	cout << "is not full\n";
    if (!tab.is_empty())
	cout << "is not empty\n";
    
    cout << "entries " << tab.get_num_entries() << " cap " 
	 << tab.get_capacity() << "\n";


    if (!tab.delete_key_absolutely(CNKeyString("Jabba")))
	cout << "jabba not deleted!\n";
    else
	cout << "jabba deleted\n";
    
    tab.print();
    
    if (!tab.reset_absolutely())
	cout << "error while resetting\n";
    else
	cout << "reset worked fine\n";
    
    tab.print();


    cout << "\ndynamic key_int\n";
    
    // key_int
    dtab.print();
    dtab.store_key(new CNKeyInt(0, obj));
    dtab.store_key(new CNKeyInt(8));
    dtab.store_key(new CNKeyInt(15));
    
    dtab.print();

    if (dtab.get_object(CNKeyInt(0, NIL)) != obj)
	cout << "strange behaviour\n";
    else
	cout << "found obj\n";
    
    if (!dtab.is_full())
	cout << "is not full\n";
    if (!dtab.is_empty())
	cout << "is not empty\n";
    
    cout << "entries " << dtab.get_num_entries() << " cap " 
	 << dtab.get_capacity() << "\n";


    if (!dtab.delete_key_absolutely(CNKeyInt(0, NIL)))
	cout << "0 not deleted!\n";
    else
	cout << "0 deleted\n";
    
    dtab.print();
    
    if (!dtab.reset_absolutely())
	cout << "error while resetting\n";
    else
	cout << "reset worked fine\n";
    
    dtab.print();

    for (unsigned long i = 0; i < 331; i++)
	dtab.store_key(new CNKeyInt(i));

    dtab.print();
    
    if (!dtab.reset_absolutely())
	cout << "error while resetting\n";
    else
	cout << "reset worked fine\n";
    
    dtab.print();


    cout << "\nstatic key_int\n";
    // key_int
    tabi.print();
    tabi.store_key(new CNKeyInt(0, obj));
    tabi.store_key(new CNKeyInt(8));
    tabi.store_key(new CNKeyInt(65));
    
    tabi.print();
    
    if (tabi.get_object(CNKeyInt(0, NIL)) != obj)
	cout << "strange behaviour\n";
    else
	cout << "found obj\n";
    
    if (!tabi.is_full())
	cout << "is not full\n";
    if (!tabi.is_empty())
	cout << "is not empty\n";
    
    cout << "entries " << tabi.get_num_entries() << " cap " 
	 << tabi.get_capacity() << "\n";


    if (!tabi.delete_key_absolutely(CNKeyInt(0, NIL)))
	cout << "0 not deleted!\n";
    else
	cout << "0 deleted\n";
    
    tabi.print();
    
    // generate an error
    /* cout << "storing A\n";
    tabi.store_key(new CNKeyString("A"));
    tabi.print();

    cout << "get A\n";
    tabi.get_key(CNKeyString("A"));
    */

    {
	CNManager root;
	CNManager *mobil, *base, *subbase;
	CNHashDynamic *table, *table2, *table3;

	mobil = (CNManager *)root.new_object("mobil", CN_MANAGER);
	base = (CNManager *)root.new_object("base", CN_MANAGER);
	table = (CNHashDynamic *)root.new_object("mobil/table", 
					     CN_HASHDYNAMIC); 
	table2 = (CNHashDynamic *)mobil->new_object("table2", CN_HASHDYNAMIC);

	subbase = (CNManager *)root.new_object("/base/subbase", CN_MANAGER);
	table3 = (CNHashDynamic *)root.new_object("/base/subbase/table3",
						CN_HASHDYNAMIC);
	
	cout << "\nNames: " << root.get_name() << "\n"
	                    << mobil->get_name() << "\n"
			    << base->get_name() << "\n"
	                    << subbase->get_name() << "\n";

	if (root.get_object("/mobil/table2") != table2)
	    cout << "strange behaviour\n";
	else 
	    cout << "got table2\n";
	
	if (mobil->get_object("table") != table)
	    cout << "strange behavious\n";
	
	else
	    cout << "got table\n";
	
	if (root.get_object("/base/subbase/table3") != table3)
	    cout << "strange behaviour\n";
	else 
	    cout << "got table3\n";
	
	if (!root.delete_object("/mobil/foo/bar/fly"))
	    cout << "failed ... okay\n";
	else
	    cout << "strange behaviour\n";
	
	if (root.delete_object("/mobil/table2"))
	    cout << "table2 deleted\n";
	else
	    cout << "strange behaviour\n";

	if (base->delete_object("subbase/table3"))
	    cout << "table3 deleted\n";
	else
	    cout << "strange behaviour\n";


	root.delete_object("/mobil/table2");
	root.delete_object("/mobil/table");
	// root.delete_object("/base"); --> error
	root.delete_object("/base/subbase");
	root.delete_object("/base");
	root.delete_object("/mobil");
    }
}

    


