//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: EZD.h,v 0.27 1995/01/20 15:15:05 cncl-adm Exp cncl-adm $
 *
 * Class: EZD --- Base class for ezd graphic objects
 *
 *****************************************************************************
 * Copyright (C) 1992-1995   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@dfv.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#ifndef __EZD_h
#define __EZD_h


#include <CNCL/Class.h>
#include <CNCL/Param.h>
#include <CNCL/Named.h>		// Base class
#include <CNCL/Pipe.h>
#include <CNCL/Select.h>

extern CNClassDesc CN_EZD;	// Class EZD description


class EZDWindow;
class EZDDrawing;



/*
 * The class EZD
 */

class EZD : public CNNamed
{
public:
    // Access to ezd's i/ostream
    static ostream & out() { return ezd->out(); }
    static istream & in () { return ezd->in (); }

    // Drawing primitives
    static void draw_point(int x, int y, CNStringR col);
    static void draw_line(int x1, int y1, int x2, int y2,
			  CNStringR col, int width=-1);
    static void draw_dash_line(int x1, int y1, int x2, int y2,
			       CNStringR col, int width=-1);
    static void draw_arc(int x, int y, int w, int h, int a1, int a2,
			 CNStringR col, int width=-1);
    static void draw_fill_arc(int x, int y, int w, int h, int a1, int a2,
			      CNStringR col);
    static void draw_pie_arc(int x, int y, int w, int h, int a1, int a2,
			      CNStringR col);
    static void draw_rectangle(int x, int y, int w, int h,
			       CNStringR col, int width=-1);
    static void draw_fill_rectangle(int x, int y, int w, int h,
				    CNStringR col);
    static void draw_fill_rectangle(int x, int y, int w, int h,
				    CNStringR col, 
				    CNStringR stipple);
    static void draw_text(int x, int y, CNStringR text,
			  CNStringR col, CNStringR font);
    static void draw_text(int x, int y, int w, int h, CNStringR align,
			  CNStringR text, CNStringR col,
			  CNStringR font);
    static void draw_bitmap(int x, int y, int w, int h, 
			    CNStringR filename,
			    CNStringR color1 = "black",
			    CNStringR color2 = "");
    static void draw_bitmap(int x, int y, CNStringR filename,
			    CNStringR color1 = "black",
			    CNStringR color2 = "");
#if CNCL_CC_GCC25
    /*
     * Alternate functions with const char * args, because g++ 2.5.8
     * generates buggy code at least for calls to the 2nd draw_text()
     * with string constants "abc" args. Some of the temporary CNStrings
     * are freed twice.
     *
     * This is fixed starting with GCC 2.6.0, hence the #if.
     */
    static void draw_text(int x, int y, const char *text,
			  const char *col, const char *font);
    static void draw_text(int x, int y, int w, int h, const char *align,
			  const char *text, const char *col,
			  const char *font);
    static void draw_bitmap(int x, int y, int w, int h, 
			    const char *filename,
			    const char *color1 = "black",
			    const char *color2 = "");
    static void draw_bitmap(int x, int y, const char *filename,
			    const char *color1 = "black",
			    const char *color2 = "");
#endif /**__GNUC_MINOR__ < 6**/
    
    static void draw_now();
    static void draw_clear();
    
    // Flush changes and pause
    static void pause(int msec);

    // Read event from pipe from ezd
    static CNString event();
    static bool test_event();

    // Set pixel scaling values
    static void set_scale(const float xscale_x, const float xscale_y,
		      const int xorigin_x, const int xorigin_y);

    static void print_window(CNStringR , CNStringR );

    // Pixel scaling functions
    static int x2pix(const float x) 
    {
        return((int)(x*scale_x+(float)origin_x+0.49));
    }
    
    static int y2pix(const float y)
    {
	return((int)(y*scale_y+(float)origin_y+0.49));
    }

    // Save current drawing
    static void save_drawing();
    static void restore_drawing();
    
    // Private members
  private:
    static bool initialized;		// Initialized flag
    static CNPipe *ezd;			// Pipe to ezd process
    static CNSelect sel;		// select for test_event()
    static float scale_x, scale_y;
    static int origin_x, origin_y;
        
    void initialize()
    {
	if(!initialized)
	{
	    initialized = TRUE;
	    ezd = new CNPipe("ezd");
	    if(ezd)
		sel.add_read( ezd->fd_in() );
	}
    }
    
    /***** Constructors ******************************************************/
public:
    EZD()               : CNNamed("")   { initialize(); }
    EZD(CNParam *param) : CNNamed("")   { initialize(); }
    EZD(CNStringR name) : CNNamed(name) { initialize(); }

    /***** Member functions required by CNCL *********************************/
public:
    virtual CNClassDesc class_desc() const	// CNClass description
    {
	return CN_EZD;
    };
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    {
	return desc == CN_EZD ? TRUE : CNNamed::is_a(desc);
    };
        
    static EZD *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (EZD *)obj;
#   else
	return (EZD *)( !obj || obj->is_a(CN_EZD)
	       ? obj : fatal_type(obj->class_desc(), CN_EZD) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new EZD(param) : new EZD; }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};


#endif /**__EZD_h**/
