/*
 * Missing function usleep() for HPUX
 *
 * Date: Fri, 29 Jul 94 10:16 EDT
 * From: neal@ctd.comsat.com (Neal Becker)
 */
  
#include <CNCL/CNCL.h>

#if CNCL_SYS_HPUX || CNCL_SYS_SVR4 || CNCL_SYS_ULTRIX

#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <time.h>
#include <memory.h>
#include <sys/time.h>
#include <sys/param.h>
#include <sys/types.h>

extern "C" int     usleep( unsigned long int microSeconds )
{
        unsigned int            Seconds, uSec;
        struct  timeval         Timer;
	int nfds;
#ifdef CNCL_SYS_HPUX
        int                     readfds, writefds, exceptfds;

        readfds = writefds = exceptfds = 0;

#else
        fd_set                  readfds, writefds, exceptfds;

	FD_ZERO(&readfds);
	FD_ZERO(&writefds);
	FD_ZERO(&exceptfds);
#endif
	nfds = 0;

        if( (microSeconds == (unsigned long) 0) 
                || microSeconds > (unsigned long) 4000000 )
        {
                errno = ERANGE;         /* value out of range */
                perror( "usleep time out of range ( 0 -> 4000000 ) " );
                return -1;
        }

        Seconds = microSeconds / (unsigned long) 1000000;
        uSec    = microSeconds % (unsigned long) 1000000;

        Timer.tv_sec            = Seconds;
        Timer.tv_usec           = uSec;

        if( select( nfds, &readfds, &writefds, &exceptfds, &Timer ) < 0 )
        {
                perror( "usleep (select) failed" );
                return -1;
        }

        return 0;
}

#endif /**__hpux**/
