//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: FSetTrapez.c,v 0.27 1995/01/20 15:15:21 cncl-adm Exp cncl-adm $
 *
 * Class: CNFSetTrapez --- Fuzzy set with trapezium function
 *
 *****************************************************************************
 * Copyright (C) 1992-1995   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@dfv.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#include "FSetTrapez.h"



/*
 * Contructors
 */
CNFSetTrapez::CNFSetTrapez()
    : CNFSetLR(0, 0, 0, 0, 0, 0, CNFuncLin, CNFuncLin)
{}


CNFSetTrapez::CNFSetTrapez(CNParam *param)
    : CNFSetLR(0, 0, 0, 0, 0, 0, CNFuncLin, CNFuncLin)
{}


CNFSetTrapez::CNFSetTrapez(double min, double max,
			   double xm1, double xm2,
			   double xalpha, double xbeta )
    : CNFSetLR(min, max, xm1, xm2, xalpha, xbeta, CNFuncLin, CNFuncLin)
{}


CNFSetTrapez::CNFSetTrapez(double xm1, double xm2,
			   double xalpha, double xbeta )
    : CNFSetLR(xm1, xm2, xalpha, xbeta, CNFuncLin, CNFuncLin)
{}


CNFSetTrapez::CNFSetTrapez(CNStringR xname, double min, double max,
			   double xm1, double xm2,
			   double xalpha, double xbeta )
    : CNFSetLR(xname, min, max, xm1, xm2, xalpha, xbeta, CNFuncLin, CNFuncLin)
{}


CNFSetTrapez::CNFSetTrapez(CNStringR xname, double xm1, double xm2,
			   double xalpha, double xbeta )
    : CNFSetLR(xname, xm1, xm2, xalpha, xbeta, CNFuncLin, CNFuncLin)
{}



/*
 * Initialize
 */
void CNFSetTrapez::init(CNStringR xname, 
		      double xm1, double xm2, double xalpha, double xbeta,
		      double min, double max                              )
{
    CNFSetLR::init(xname, xm1, xm2, xalpha, xbeta,
		   CNFuncLin, CNFuncLin, min, max);
}



/*
 * Compute membership value for x - optimized version for trapezium
 */
double CNFSetTrapez::get_membership(double x) const
{
    double dy = ymax - ymin;

    if(x>=m1 && x<=m2)
	return ymax;
    if(x<=(m1-alpha) || x>=(m2+beta))
	return ymin;
    if(x < m1)
	return ymin + dy*(x-(m1-alpha))/alpha;
    return ymin + dy*(m2+beta-x)/beta; 
}



/***** Default I/O member function for CNCL classes **************************/

// CNNormal output
void CNFSetTrapez::print(ostream &strm) const
{
    strm << "set trapez " << name()
	 << "(" << m1 << ", " << m2 << ", " << alpha << ", " << beta << ");";
}

// Debug output
void CNFSetTrapez::dump(ostream &strm) const
{
    strm << "CNFSetTrapez { $Revision: 0.27 $" << endl;
    print(strm);
    strm << "}" << endl;
}



/***** CNCL stuff for type information ***************************************/

// Describing object for class CNFSetTrapez
static CNClass CNFSetTrapez_desc("CNFSetTrapez", "$Revision: 0.27 $",
				 CNFSetTrapez::new_object);

// "Type" for type checking functions
CNClassDesc CN_FSETTRAPEZ = &CNFSetTrapez_desc;






