//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: PolyLine.c,v 0.27 1995/01/20 15:15:43 cncl-adm Exp cncl-adm $
 *
 * Class: PolyLine --- replacement for GIST1 PolyLine
 *
 *****************************************************************************
 * Copyright (C) 1992-1995   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@dfv.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 * 
 * As an exception to this rule you may use this template to generate
 * your own classes. This does not cause these classes to be covered by
 * the GNU Library General Public License. This exception does not
 * however invalidate any other reasons why the resulting program must be
 * covered by the GNU Library General Public License.
 **EHEADER********************************************************************/

#include "PolyLine.h"

PolyLine::PolyLine(World& w,
		   const char *objectname,
		   const char *color,
		   float thickness,
		   double time) :
  GISTObject(w.world(), objectname) 
{
    path = new GISTCoordArrayAttribute(this, "Points", 4);
    pic = new GISTPicture(this, "Line");
    pic->set_color(color);
    pic->set_brush(thickness);
    pic->polyline(path);
};

void PolyLine::put_line(double time,
			float x1, float y1,
			float x2, float y2) {
    CNCoord p[4];
    p[0] = CNCoord(x1, y1);
    p[1] = p[2] = p[3] = CNCoord(x2, y2);
    path->put(time, p);
};

void PolyLine::put_line(double time,
			float x1, float y1,
			float x2, float y2,
			float x3, float y3){
    CNCoord p[4];
    p[0] =  CNCoord(x1, y1);
    p[1] =  CNCoord(x2, y2);
    p[2] = p[3] = CNCoord(x3, y3);
    path->put(time, p);
};

void PolyLine::put_line(double time,
			float x1, float y1,
			float x2, float y2,
			float x3, float y3,
			float x4, float y4){
    CNCoord p[4];
    p[0] = CNCoord(x1, y1);
    p[1] = CNCoord(x2, y2);
    p[2] = CNCoord(x3, y3);
    p[3] = CNCoord(x4, y4);
    path->put(time, p);
};


/***** Default I/O member function for CNCL classes **************************/

// Normal output
void PolyLine::print(ostream &strm) const
{
    GISTObject::print(strm);
    path->print(strm);
}

// Debug output
void PolyLine::dump(ostream &strm) const
{
    strm << "PolyLine { $Revision: 0.27 $" << endl;
    GISTObject::dump(strm);
    path->dump(strm);
    strm  << " }" << endl;
}


/***** CNCL stuff for type information ***************************************/

// Describing object for class PolyLine
static CNClass PolyLine_desc("PolyLine", "$Revision: 0.27 $",
			    PolyLine::new_object);

// "Type" for type checking functions
CNClassDesc CN_POLYLINE = &PolyLine_desc;
