// -*- C++ -*-
/*
 * StreamSocket.h
 */

#ifndef _STREAM_SOCKET_H
#define _STREAM_SOCKET_H

#include <stream.h>

#include <CNCL/SocketBuf.h>

/*
 * Class SocketStream --- iostream for INET stream sockets
 */

class SocketStream : virtual public ios, public iostream
{
private:
    enum { none, server, client } type;	// Socket type
    int sock;				// Socket file descriptor
    int asock;				// Socket file descriptor from accept()
    
    // Create and connect socket
    int open_connection(const char *host, unsigned short port);
    int open_listen(unsigned short port);
    
public:
    SocketStream();
    SocketStream(const char *host, unsigned short port);
    SocketStream(const char *host, const char *port);
    SocketStream(unsigned short port);
    SocketStream(const char *port);
    ~SocketStream();

    // Liefert streambuf als filebuf
    SocketBuf *rdbuf()
    {
	return (SocketBuf *)_strbuf;
    }

    // Liefert file descriptor
    int filedesc()
    {
	return rdbuf()->fd();
    }
    
    // Open SocketStream for clients
    void open(const char *host, unsigned short port);
    void open(const char *host, const char *port);
    // Open SocketStream for servers
    void open(unsigned short port);
    void open(const char *port);

    // Close connection
    void close();

    // Accept connection
    void accept();

    // Close accepted connection
    void accept_close();
};

#endif /**_STREAM_SOCKET_H**/
