//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: Coord.c,v 0.27 1995/01/20 15:14:22 cncl-adm Exp cncl-adm $
 *
 * CNClass: CNCoord --- 2-dim coordinates
 *
 *****************************************************************************
 * Copyright (C) 1992-1995   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@dfv.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#include "Coord.h"
#include "ICoord.h"



/*
 * CNCoord -> CNICoord scale factor
 */
double CNCoord::scale = 0.025;



/*
 * Scale manipulation
 */
double CNCoord::set_scale(double new_scale)
{
    double old = scale;
    scale = new_scale;
    return old;
}


double CNCoord::get_scale()
{
    return scale;
}



/*
 * Constructors
 */
CNCoord::CNCoord()
    : x(0), y(0)
{}


CNCoord::CNCoord(CNParam *param)
    : x(0), y(0)
{}


CNCoord::CNCoord(double vx, double vy)
    : x(vx), y(vy)
{}


CNCoord::CNCoord(const CNCoord &v)
{
    x = v.x;
    y = v.y;
}


CNCoord::CNCoord(const CNICoord &v)
{
    x = v.x * scale;
    y = v.y * scale;
}



/*
 * Operators
 */
CNCoord &CNCoord::operator += (const CNCoord &v)
{
    x += v.x;
    y += v.y;
    return *this;
}


CNCoord &CNCoord::operator -= (const CNCoord &v)
{
    x -= v.x;
    y -= v.y;
    return *this;
}


CNCoord operator + (const CNCoord &a, const CNCoord &b)
{
    return CNCoord(a.x + b.x, a.y + b.y);
}


CNCoord operator - (const CNCoord &a, const CNCoord &b)
{
    return CNCoord(a.x - b.x, a.y - b.y);
}






/***** Default I/O member function for CNCL classes **************************/

// CNNormal output
void CNCoord::print(ostream &strm) const
{
    strm << x << " " << y;
}

// Debug output
void CNCoord::dump(ostream &strm) const
{
    strm << "CNCoord { "
	 << "scale=" << scale << "  x=" << x << " y=" << y
	 << " }" << endl;
}



/***** CNCL stuff for type information and exemplar objects ******************/

// Describing object for class CNCoord
static CNClass CNCoord_desc("CNCoord", "$Revision: 0.27 $", CNCoord::new_object);

// "Type" for type checking functions
CNClassDesc CN_COORD = &CNCoord_desc;






