//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: ICoord.c,v 0.27 1995/01/20 15:14:22 cncl-adm Exp cncl-adm $
 *
 * CNClass: CNICoord --- 2-dim integer coordinates
 *
 *****************************************************************************
 * Copyright (C) 1992-1995   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@dfv.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#include <math.h>

#include "Coord.h"
#include "ICoord.h"



/*
 * Scale manipulation
 */
double CNICoord::set_scale(double new_scale)
{
    double old = CNCoord::scale;
    CNCoord::scale = new_scale;
    return old;
}


double CNICoord::get_scale()
{
    return CNCoord::scale;
}



/*
 * Constructors
 */
CNICoord::CNICoord()
    : x(0), y(0)
{}


CNICoord::CNICoord(CNParam *param)
    : x(0), y(0)
{}


CNICoord::CNICoord(int vx, int vy)
    : x(vx), y(vy)
{}


CNICoord::CNICoord(const CNICoord &v)
{
    x = v.x;
    y = v.y;
}


// substituted rint(x) with floor(x+.5) (02.12.93 gp)
// {BORLAND C++ doesn't know rint()}

CNICoord::CNICoord(const CNCoord &v)
{
	 x = (int)floor((v.x / CNCoord::scale)+.5);
	 y = (int)floor((v.y / CNCoord::scale)+.5);
}



/*
 * Operators
 */
CNICoord &CNICoord::operator += (const CNICoord &v)
{
    x += v.x;
    y += v.y;
    return *this;
}


CNICoord &CNICoord::operator -= (const CNICoord &v)
{
    x -= v.x;
    y -= v.y;
    return *this;
}


CNICoord operator + (const CNICoord &a, const CNICoord &b)
{
    return CNICoord(a.x + b.x, a.y + b.y);
}


CNICoord operator - (const CNICoord &a, const CNICoord &b)
{
    return CNICoord(a.x - b.x, a.y - b.y);
}



/***** Default I/O member function for CNCL classes **************************/

// CNNormal output
void CNICoord::print(ostream &strm) const
{
    strm << x << " " << y;
}

// Debug output
void CNICoord::dump(ostream &strm) const
{
    strm << "CNICoord { "
	 << "x=" << x << " y=" << y
	 << " }" << endl;
}



/***** CNCL stuff for type information and exemplar objects ******************/

// Describing object for class CNICoord
static CNClass CNICoord_desc("CNICoord", "$Revision: 0.27 $", CNICoord::new_object);

// "Type" for type checking functions
CNClassDesc CN_ICOORD = &CNICoord_desc;






