//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: Named.h,v 0.27 1995/01/20 15:14:22 cncl-adm Exp cncl-adm $
 *
 * Class: CNNamed --- CNObject with name
 *
 *****************************************************************************
 * Copyright (C) 1992-1995   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@dfv.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER*******************************************************************/

#ifndef __CNNamed_h
#define __CNNamed_h


#include <CNCL/Class.h>
#include <CNCL/Param.h>
#include <CNCL/Object.h>		// Base class
#include <CNCL/String.h>

extern CNClassDesc CN_NAMED;	// Class CNNamed description


/*
 * The class CNNamed
 */

class CNNamed : public CNObject
{
public:
    // Return object's name
    CNStringR name()     const { return oname; }
    CNStringR get_name() const { return oname; }
    // Set object's name
    void name(CNStringR n)          { oname=n; }
    void set_name(CNStringR n)      { oname=n; }

    // Private members
private:
    CNString oname;

    /***** Constructors ******************************************************/
public:
    CNNamed()               : oname("")   {}
    CNNamed(CNParam *param) : oname("")   {}
    CNNamed(CNStringR name) : oname(name) {}

    /***** Member functions required by CNCL *********************************/
public:
    virtual CNClassDesc class_desc() const	// CNClass description
    {
	return CN_NAMED;
    };
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    {
	return desc == CN_NAMED ? TRUE : CNObject::is_a(desc);
    };
        
    static CNNamed *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNNamed *)obj;
#   else
	return (CNNamed *)( !obj || obj->is_a(CN_NAMED)
	       ? obj : fatal_type(obj->class_desc(), CN_NAMED) );
#   endif
    }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const = 0;
    virtual void dump (ostream &strm = cout) const = 0;
};


#endif /**__CNNamed_h**/
