//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: PInt.c,v 0.27 1995/01/20 15:14:52 cncl-adm Exp cncl-adm $
 *
 * Class: CNPInt --- class persistent CNInt
 *
 *****************************************************************************
 * Copyright (C) 1992-1995   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@dfv.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#include "PInt.h"

CNPInt::CNPInt(CNPstream& strm):CNPObjectID(){
    strm >> value;
}

virtual int CNPInt::storer(CNPstream& strm){
   strm << value;
   return 0;
}

/***** CNCL stuff for type information ***************************************/

// Describing object for class CNPInt
static CNClass CNPInt_desc("CNPInt", "$Revision: 0.27 $",
			    CNPInt::new_object);

// "Type" for type checking functions
CNClassDesc CN_PINT = &CNPInt_desc;


// Registering the reader function in the reader table 
static CNReaderTbl CNPInt_reader_entry("CNPInt", (Reader_ptr) CNPInt::reader);






