//:ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: Template.h,v 0.3 1993/01/05 10:17:15 mj Exp mj $
 *
 * CNClass: Test --- Created from CNCL template
 *
 * $Log: Template.h,v $
 * Revision 0.3  1993/01/05  10:17:15  mj
 * Small changes: print() and dump() print template revision.
 *
 * Revision 0.2  1992/12/23  12:48:20  mj
 * Rewrote object creation with static member function for each class.
 * No more exemplar objects.
 *
 * Revision 0.1  1992/12/21  13:51:08  mj
 * First PTEST revision.
 *
 *****************************************************************************
 * Copyright (C) 1992-1995   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@dfv.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *****************************************************************************/

#ifndef __ptest_h
#define __ptest_h

#include <CNCL/PIO.h>		// Methodes for persistency
#include <CNCL/PObjectID.h>

#include <CNCL/Class.h>
#include <CNCL/Param.h>

#include <CNCL/Object.h>		// Base class

extern CNClassDesc CN_PTEST;	// CNClass ptest description


/*
 * The class ptest
 */

class ptest : public CNObject, CNPObjectID
{
public:
    int get_n() { return n; }

    // Private members
private:
    long n;

    /***** Constructors ******************************************************/
public:
    ptest() : n(0), CNPObjectID(){}	       	// Default constructor
    ptest(int new_n) : n(new_n), CNPObjectID(){}
    ptest(CNPstream&);				// read_from constructor 
    ptest(CNParam *param): CNPObjectID(){}     	// CNParam constructor
    ~ptest()
    {
	cout << "Deleting ptest n=" << n << endl;
    }

  public:	/***** Public interface for persistent IO ********************/
    virtual int store_on(CNPstream& s) {return CNPIO::store_object(s, *this);}
    virtual int storer(CNPstream&);
    static CNObject* object_read_from(CNPstream& s)                                              {return CNPIO::read_object(s);}
    static ptest* read_from(CNPstream& s)                                                      {return ptest::cast_from_object(CNPIO::read_object(s));}
    static ptest* reader(CNPstream& s) {return new ptest(s);}
    CNPID object_id() { return CNPObjectID::object_id(); }
    

    /***** Member functions required by CNCL *********************************/
public:
    virtual CNClassDesc class_desc() const	// CNClass description
    {
	return CN_PTEST;
    };
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    {
	return desc == CN_PTEST ? TRUE : CNObject::is_a(desc);
    };
        
    static ptest *cast_from_object(CNObject *obj)// Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (ptest *)obj;
#   else
	return (ptest *)( !obj || obj->is_a(CN_PTEST)
	       ? obj : fatal_type(obj->class_desc(), CN_PTEST) );
#   endif
    }
    
    // CNObject creation
    static CNObject *new_object(CNParam *param = NIL);
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};


#endif /**__ptest_h**/
