//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: FiboG.c,v 0.27 1995/01/20 15:13:51 cncl-adm Exp cncl-adm $
 *
 * CNClass: CNFiboG --- Fibonacci random number generator
 *
 *****************************************************************************
 * Copyright (C) 1992-1995   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@dfv.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#include "FiboG.h"



CNFiboG::CNFiboG(unsigned long init)
{
    // create a 97 element circular queue
    Vknot *Vhilf;
    Vanker = V97 = Vhilf = new Vknot;	
    if (Vhilf == NIL)
	fatal(NIL, "CNFiboG: virtual memory exhausted");

    for( short i=96; i>0; i-- )
    {
	Vhilf->vnext = new Vknot;
	Vhilf = Vhilf->vnext;
	if (Vhilf == NIL)
	    fatal(NIL, "CNFiboG: virtual memory exhausted");
	if (i == 33)
	    V33 = Vhilf;
    }
    Vhilf->vnext = Vanker;
    
    initialSeed = init;
    reset();
}



CNFiboG::~CNFiboG()
{
    // delete circular queue
    Vknot *Vhilf1, *Vhilf2;
    Vhilf1 = Vanker;
    for( short i=97; i>0; i-- )
    {
	Vhilf2 = Vhilf1->vnext;
	delete Vhilf1;
	Vhilf1 = Vhilf2;
    }
}



void CNFiboG::reset()
{
    // initialise FIBOG like RANMAR (or IMAV)
    // (sorry, Code looks a little bit like FORTRAN)	
    Vknot *Vhilf = V97;
    
    long ijkl = 54217137;
    if (initialSeed >0 && initialSeed <= 900000000) ijkl = initialSeed;
    long ij = ijkl / 30082;
    long kl = ijkl - 30082 * ij;
    long i = (ij/177) % 177 + 2;
    long j = ij % 177 + 2;
    long k = (kl/169) % 178 + 1;
    long l = kl % 169;
    long s, t;
    for( int ii=0; ii<97; ii++)
    {
	s = 0; t = 0x80000000;
	for( int jj=0; jj<32; jj++)
	{
	    long m = (((i * j) % 179) * k) % 179;
	    i = j; j = k; k = m;
	    l = (53 * l + 1) % 169;
	    if ((l * m) % 64 >= 32) s = s + t;
	    t /= 2;
	}
	Vhilf->v = s;
	Vhilf = Vhilf->vnext;
    }
    cn = 15362436;
}



unsigned long CNFiboG::as_long32()
{
    Vn = (V97->v - V33->v) & 0xffffffff;	// (x & 2^32) might be faster  
    cn = (cn + 362436069)  & 0xffffffff;	// than (x % 2^32)
    Xn = (Vn - cn)         & 0xffffffff;
	
    V97->v = Vn;
    V97 = V97->vnext;
    V33 = V33->vnext;
    
    return Xn;
}



void CNFiboG::seed( unsigned long *ulp )
{
    // initialize circular queue and cn with array of 98 values
    Vknot *Vhilf = V97;
    for( short i=97; i>0; i--)
    {
	Vhilf->v = *ulp++;
	Vhilf = Vhilf->vnext;
    }
    cn = *ulp;
}



/***** Default I/O member function for CNCL classes **************************/

// CNNormal output
void CNFiboG::print(ostream &strm) const
{
    strm << endl;
}

// Debug output
void CNFiboG::dump(ostream &strm) const
{
    strm << "CNFiboG { "
	 << " }" << endl;
}



/***** CNCL stuff for type information and exemplar objects ******************/

// Describing object for class CNFiboG
static CNClass CNFiboG_desc("CNFiboG", "$Revision: 0.27 $", CNFiboG::new_object);

// "Type" for type checking functions
CNClassDesc CN_FIBOG = &CNFiboG_desc;






