//:ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: SSMP2.c,v 0.27 1995/01/20 15:13:51 cncl-adm Exp cncl-adm $
 *
 * Class: CNSSMP2 --- Semi-Markov-Process
 *
 *****************************************************************************
 * Copyright (C) 1992-1995   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@dfv.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *****************************************************************************/

#include "SSMP2.h"


CNSSMP2 :: CNSSMP2(double cp01,double cp10, CNRandom *cgenerator_distribution_state_0, 
                 CNRandom *cgenerator_distribution_state_1, CNRNG *gen) : CNRandom(gen)
{
     p01=cp01;
     p10=cp10;
     generator_uniform = new CNUniform(0.0,1.0,gen);
     generator_distribution_state_0=cgenerator_distribution_state_0;
     generator_distribution_state_1=cgenerator_distribution_state_1;


     if ( (p10>=0 && p10<=1) || (p10>=0 && p10<=1))
     {
	  p=p01/(p01+p10);	// calculate stat. state probability p = P1
     }
     else
     {
	 fatal(NIL, "CNSSMP2:",
	       "wrong transition probability p10 or p01");
     }

     //*********************************// set first state
     if (p>0.5)			        // first state "1"
     {
        // Probability for next state "1"
   	kappa=1.0-p10;		        
        // generate time with distribution function for state 1
   	time=(*generator_distribution_state_1)();
     }
     else				 // first state "0"
     {
         // Probability for next state "1"
         kappa=p01;
         // generate time with distribution function for state 0
         time=(*generator_distribution_state_0)();
    }
}


double CNSSMP2::operator()()
{
     double time_return=time;
     // generate a uniform distributed number
     randi=(*generator_uniform)();
     if(randi<=kappa)			
     {  // case act. state  "1"
        // Probability for next state "1"
	kappa=1.0-p10;
        // generate time with distribution function for state 1
     	time=(*generator_distribution_state_1)();	        
     }
     else
     {	// case act. state  "0"
        // Probability for next state "1"
        kappa=p01;
        // generate time with distribution function for state 0
     	time=(*generator_distribution_state_0)();		
     }
     return time_return;
}

double CNSSMP2 :: get_correlation()
{
     rho = (1-p10-p01);			// calculate correlation
     return rho; 
}

CNArrayDouble CNSSMP2 :: get_stat_prob()
{
     CNArrayDouble statProb(2);
     statProb[0] = 1-p;			// stat. state Probability P0
     statProb[1] = p;			// stat. state Probability P1
     return statProb;
}

/***** Default I/O member function for CNCL classes **************************/

// Normal output
void CNSSMP2::print(ostream &strm) const
{
     strm << "p01=" << p01 << endl << "p10=" << p10 << endl
          << "distribution_state_0:" << endl;
	  generator_distribution_state_0->dump();
     strm << "distribution_state_1:" << endl;
	  generator_distribution_state_1->dump();

}

// Debug output
void CNSSMP2::dump(ostream &strm) const
{
    strm << "CNSSMP2 { " << endl
         << "p01=" << p01 << endl << "p10=" << p10 << endl
         << "distribution_state_0:" << endl;
	 generator_distribution_state_0->dump();
    strm << "distribution_state_1:" << endl;
         generator_distribution_state_1->dump();
    strm << " }" << endl;
}



/***** CNCL stuff for type information ***************************************/

// Describing object for class CNSSMP2
static CNClass CNSSMP2_desc("CNSSMP2", "$Revision: 0.27 $",
			  CNSSMP2::new_object);

// "Type" for type checking functions
CNClassDesc CN_SSMP2 = &CNSSMP2_desc;
