// -*- C++ -*-

/*
 * Test program for random number generators
 */

#include <string.h>

#include <CNCL/Moments.h>

#include <CNCL/RNG.h>
#include <CNCL/FiboG.h>

#include <CNCL/Random.h>
#include <CNCL/Beta.h>
#include <CNCL/Binomial.h>
#include <CNCL/Determ.h>
#include <CNCL/DiscUniform.h>
#include <CNCL/Erlang.h>
#include <CNCL/Geometric.h>
#include <CNCL/HyperExp.h>
#include <CNCL/HyperGeom.h>
#include <CNCL/LogNormal.h>
#include <CNCL/MDeterm.h>
#include <CNCL/NegExp.h>
#include <CNCL/Normal.h>
#include <CNCL/Poisson.h>
#include <CNCL/Rayleigh.h>
#include <CNCL/Rice.h>
#include <CNCL/Uniform.h>
#include <CNCL/Weibull.h>


enum { NRANDOM = 20, NVAL = 100000 };


char buffer[128];



main()
{
    CNRNG *gen;
    CNRandom *rng[NRANDOM];
    int i, j;
    int n = 0;
    
    gen = new CNFiboG;
    
    rng[n++] = new CNBeta(2, 3, gen);
    rng[n++] = new CNBinomial(10, 0.5, gen);
    rng[n++] = new CNDeterm(5.0, gen);
    rng[n++] = new CNDiscUniform(1, 11, gen);
    rng[n++] = new CNErlang(4.0, 2.0, gen);
    rng[n++] = new CNGeometric(0.5, gen);
    rng[n++] = new CNHyperExp(0.5, 2.0, 4.0, gen);
    rng[n++] = new CNHyperGeom(1.0, 2.0, gen);
    rng[n++] = new CNLogNormal(4.0, 2.0, gen);
    rng[n++] = new CNMDeterm(0.5, 0.0, 10.0, gen);
    rng[n++] = new CNNegExp(4.0, gen);
    rng[n++] = new CNNormal(4.0, 2.0, gen);
    rng[n++] = new CNPoisson(4.0, gen);
    rng[n++] = new CNRayleigh(2.0, gen);
    rng[n++] = new CNRice(4.0, 2.0, gen);
    rng[n++] = new CNUniform(0.0, 12.0, gen);
    rng[n++] = new CNWeibull(2, 3, gen);
    rng[n++] = NIL;
    
    for(i=0; rng[i]; i++)
    {
	rng[i]->dump();
	
	strcpy(buffer, rng[i]->class_desc()->name());
	strcat(buffer, " ");
	strcat(buffer, rng[i]->class_desc()->version());
	
	CNMoments stat(buffer);
	    
	for(j=0; j<NVAL; j++)
	    stat.put(rng[i]->operator()());
	    
	cout << stat << endl;
    }
}
