#include <CNCL/FiboG.h>
#include <CNCL/Geometric.h>
#include <CNCL/ArrayLong.h>
#include <CNCL/Moments.h>
#include <CNCL/LREG.h>
#include <CNCL/SSMP2.h>

main()
{
    CNLREG  *lre = new CNLREG(0.001 ,0.90 ,0.05 ,100, CNLRE::LOG);
  

    double temp,sumtemp;
    temp = sumtemp =0;

    long TRIALS=25000000;
    int MAX=100;
    long over_range_interarrival_times;
    CNArrayLong table_interarrival_times;
    CNMoments interarrival_times("Interarrival Times");

    double q0, q1, p01, p10;
    q0=0.580;
    q1 = 0.804;
    p01 = 0.28;
    p10 = 0.12;
    int interarrival_time;

    cout << "TRIALS\t" << TRIALS
	 << "\nMAX\t" << MAX
	 << "\nq0\t" << q0
	 << "\nq1\t" << q1
	 << "\np01\t" << p01
	 << "\np10\t" << p10 << endl;




    CNRNG  *rng = new CNFiboG;                      // basic generator

							   CNGeometric *g_f0 = new CNGeometric(q0, rng);	// generator state "0"
														       CNGeometric *g_f1 = new CNGeometric(q1, rng);	// generator state "1"

																					       CNSSMP2 smp(p01,p10, g_f0, g_f1, rng);
    for(int k=1;k<=TRIALS;k++)
    {
	interarrival_time = int(smp());

	lre->put(interarrival_time);
	if(lre->status()==CNLRE::END)
	    break;
	

	interarrival_times.put(interarrival_time);
        // Einsortieren der Zwischenabgangszeiten in Tabelle

	       if(interarrival_time > MAX)
	       {over_range_interarrival_times++;}
	       else if(table_interarrival_times.get_size() <= interarrival_time)
	       {
		   table_interarrival_times.set_size(interarrival_time+1);
		   table_interarrival_times[interarrival_time]++;
	       }
	       else 
		   table_interarrival_times[interarrival_time]++;
    }

    // results:
	interarrival_times.print();
	
    cout <<"\ninterarrival time\t\tfrequency ratio\n";
    for(int i=0; i<table_interarrival_times.get_size(); i++)
    {
	temp = 1.0*table_interarrival_times[i]/TRIALS;
	sumtemp += temp;
	cout.width(4);
	cout.setf(ios::left,ios::adjustfield);
	cout.setf(ios::scientific,ios::floatfield);
	cout << i <<"           \t\t\t";
	cout.width(16); 
	cout << temp
	     << "\t" << sumtemp <<"\n";
    }
    sumtemp += 1.0 * over_range_interarrival_times / TRIALS;
    cout << ">";
    cout.width(3);
    cout << i <<"           \t\t\t"; 
    cout.width(16);
    cout << 1.0*over_range_interarrival_times/ TRIALS 
	 << "\t" << sumtemp <<"\n";
    cout << "\n";

    cout << *lre;

    //system ("ps -ux");

}
