#include "matrix.h"

matrix matrix::backsub(matrix& B, matrix& X, const matrix& P,
	const unsigned long xcol) const
{

	#ifdef __RUN_TIME_CHECKING__
	if(this->collen() != this->rowlen()){
		cerr << "invalid matrix size: backsub on non-square matrix\n";
		exit(1);
	}
	if(B.rowlen()!=this->rowlen() || B.collen()!=1){
		cerr << "invalid matrix size for B in backsub, ";
		cerr << "B should be n x 1 matrix.\n";
		exit(1);
	}
	if(P.rowlen()!=this->rowlen() || P.collen()!=1){
		cerr << "invalid matrix size for P in backsub, ";
		cerr << "P should be n x 1 matrix.\n";
		exit(1);
	}
	#endif

	unsigned long i,j,k, n = this->collen();
	double sum;

	for(k=0; k<n; k++)
		for(i=k+1; i<n; i++)
			B.poke((unsigned long)P.peek(i,0),0,
				B.peek((unsigned long)P.peek(i,0),0) -
				( this->peek((unsigned long)P.peek(i,0),k) *
				B.peek((unsigned long)P.peek(k,0),0)) );

	X.poke(n-1,xcol,
		B.peek((unsigned long)P.peek(n-1,0),0) /
			this->peek((unsigned long)P.peek(n-1,0),n-1));

	for(k=n-1; k>0;)
	{
		k--;
		sum=0.0;
		for(j=k+1; j<n; j++)
			sum += this->peek((unsigned long)P.peek(k,0),j) * X.peek(j,xcol);
		X.poke(k,xcol,
			(B.peek((unsigned long)P.peek(k,0),0) - sum) /
			this->peek((unsigned long)P.peek(k,0),k));
	}

	return X;
}
