#include "matrix.h"

double matrix::det() const
{
	#ifdef __RUN_TIME_CHECKING__ 
	if(this->rowlen() != this->collen()){
		cerr << "invalid matrix size: determinant on non-square matrix\n";
		exit(1);
	}
	#endif

	long i;
	unsigned long j;
	double result;
	unsigned long n = this->rowlen();
	matrix P;
	matrix A = this->lu(i, P);

	switch (i)
    {
    	// singular
		case -1:
			result = 0.0;
			break;

		// normal case: |A| = |L||U||P|
		// |L| = 1,
		// |U| = multiplication of the diagonal
		// |P| = +-1
		default:
			result = 1.0;
			for (j = 0; j < n ; j++)
				result *= A.peek((unsigned long)P.peek(j,0),j);
			result *= (i % 2 ? -1 : 1);
			break;
    }
	return (result);
}
