#include "matrix.h"

ostream& operator << (ostream& s, const matrix& m)
{
	unsigned long i, k, mrowlen=m.rowlen(), mcollen=m.collen();

	for(i=0;i<mrowlen;i++) 
	{
		for(k=0;k<mcollen;k++) s << m.peek(i,k) << " ";
		s << "\n";
	}
	return s;
}

void operator >> (const char* filename, matrix& m)
{
	ifstream in(filename);

	if(!in){
		cerr << "cannot open input file\n";
		exit(1);
	}

	unsigned long i, k, mi=m.rowlen(), mk=m.collen();
	double val;

	for(i=0;i<mi;i++)
		for(k=0;k<mk;k++)
		{
			in >> val;
			m.poke(i,k, val);
		}
}

istream& operator >> (istream& s, matrix& m)
{
	unsigned long i, k, mi=m.rowlen(), mk=m.collen();
	double val;

	for(i=0;i<mi;i++)
		for(k=0;k<mk;k++)
		{
			s >> val;
			m.poke(i,k, val);
		}
	return s;
}
