#ifndef _matrix_h
#define _matrix_h

#include <iostream.h>  
#include <fstream.h>  

enum mat_type { identity };

#ifdef __RUN_TIME_CHECKING__
#include <stdlib.h>
#endif

class matrix {
	unsigned long row;                                  // row size
	unsigned long col;                                  // column size
	double *mat;                                        // matrix data 
	int error;
	matrix lu(long& i, matrix& p) const;                // lu decomposition
	matrix backsub(matrix& B, matrix& X, 
		const matrix& P,
		const unsigned long xcol) const;			 	// back-substitution

public:
	matrix(unsigned long x, unsigned long y);           // regular constructor
	matrix(unsigned long x, unsigned long y, 
	                    enum mat_type type );           // unity constructor
	matrix(unsigned long x, unsigned long y, 
	                            double init);           // init constructor
	matrix(unsigned long x, unsigned long y, 
						  	  const char* s);			// file constractor
	matrix(void);                                       // null constructor
	matrix(const matrix& m);                            // copy constractor
	~matrix(void);                                      // destructor
	double *matval() const       { return this->mat; }  // read mat priv. part
	unsigned long rowlen() const { return this->row; }  // read row priv. part
	unsigned long collen() const { return this->col; }  // read col priv. part
	void poke(unsigned long x, unsigned long y, 
	                                      double a);    // poke an element
	double peek(unsigned long x,
	                         unsigned long y) const;    // peek an element
	double det() const;                                 // determinant
	double minor(unsigned long x, unsigned long y);     // minor
	double cofactor(unsigned long x, unsigned long y);  // cofactor

	matrix& operator = (const matrix& m);               // assign
	matrix& operator += (const matrix& m);              // add & assign
	matrix& operator -= (const matrix& m);              // subtract & assign
	matrix& operator *= (const double a);               // mul. scalar & assign
	matrix& operator *= (const matrix& m);              // multiply & assign
	matrix operator ~ () const;							// inverse
	matrix operator % (const matrix& m) const;			// linear eq. solver

	int err() const { return this->error; }				// read error priv. part
};

ostream& operator << (ostream& s, const matrix& m);		// output
void operator >> (const char* name, matrix& m);			// input file
istream& operator >> (istream& s, matrix& m);			// input stream
matrix operator + (const matrix& m, const matrix& n);   // add
matrix operator * (const matrix& m, const matrix& n);   // multiply
matrix operator * (const double a, const matrix& n);	// multiply by a const
matrix operator * (const matrix& n, const double a);	// multiply by a const
matrix operator - (const matrix& m, const matrix& n);   // subtract
matrix operator - (const matrix& m);                    // unary minus
matrix operator ! (const matrix& m);                    // transpose

#endif /* matrix.h */
