#include "matrix.h"

double matrix::minor(unsigned long i, unsigned long j)
{
	unsigned long thisrow=this->rowlen(), thiscol=this->collen();

	#ifdef __RUN_TIME_CHECKING__
	if(i >= thisrow || j >= thiscol){
		cerr << "minor(): out of bounds element\n";
		exit(1);
	}
	if(thisrow != thiscol){
		cerr << "invalid matrix size: minor on non-square matrix\n";
		exit(1);
	}             
	#endif

	unsigned long m, m1, p, p1;
	matrix S(thisrow-1, thiscol-1);

	for (m = m1 = 0; m < thisrow; m++)
	{
		if (m == i) continue;
		for (p = p1 = 0; p < thiscol; p++)
		{
			if (p == j) continue;  
			S.poke(m1,p1, this->peek(m,p));
			p1++;
		}
		m1++;
	}

	// now S has the submatrix
	return S.det();
}
