#include "matrix.h"

matrix& matrix::operator *= (const double a)
{
	return *this = *this * a;
}

matrix& matrix::operator *= (const matrix& m)
{
	unsigned long i,j,k;
	double t;

	#ifdef __RUN_TIME_CHECKING__
	if(this->col != m.row){
		cerr << "operator*=: operants have unequal column&row size;";
		cerr << " lvalue column (=" << this->col << ")";
		cerr << " expr row (=" << m.row << ")\n";
		exit(1);
	}
        #endif

	matrix tmp(this->row, m.col);

	for(i=0;i< this->row ;i++)
		for(j=0;j<m.col;j++)
	 	{
	 		t=0.0;
	 		for(k=0;k < (this->col) ; k++)
                                t+= this->peek(i,k) * m.peek(k,j);
			tmp.poke(i,j,t);
		}

	#ifdef __DEBUG__
	cerr << "tmp --" << tmp;
	#endif

	return *this = tmp;
}

matrix operator * (const matrix& m, const matrix& n)
{
	matrix p = m;
	p *= n;
	return p;
}


matrix operator * (const matrix& n, const double a)
{
	return a*n;
}

matrix operator * (const double a, const matrix& n)
{
	unsigned long i,j,k,l;
	k=n.rowlen();
	l=n.collen();
        matrix p(k,l);
	
	for(i=0;i<k;i++)
		for(j=0;j<l;j++)
			p.poke(i,j, a * n.peek(i,j) );
	return p;
}


