#include "matrix.h"

matrix& matrix::operator -= (const matrix& m)
{
	unsigned long i,k; 

	#ifdef __RUN_TIME_CHECKING__
	if(this->row != m.row){
		cerr << "operator-=: operants have unequal row size;";
		cerr << " lvalue (=" << this->row << ")";
		cerr << " expr (=" << m.row << ")\n";
		exit(1);
	}

	if(this->col != m.col){
		cerr << "operator-=: operants have unequal column size;";
		cerr << " lvalue (=" << this->col << ")";
		cerr << " expr (=" << m.col << ")\n";
		exit(1);
	}
        #endif

	k = m.row*m.col;
	for(i=0;i<k;i++) this->mat[i]-=m.mat[i];
	return *this;
}

matrix operator - (const matrix& m, const matrix& n)
{
	matrix p = m;
	p -= n;
	return p;
}

matrix operator - (const matrix& m) // unary minus (or [0]-[m])
{
	unsigned long i,j,k,l;
	k=m.rowlen();
	l=m.collen();
        matrix p(k,l);

	for(i=0;i<k;i++)
		for(j=0;j<l;j++)
			p.poke(i,j, - m.peek(i,j) );
	return p;
}
