// $Id: qmag.cpp,v 1.1 1995/06/28 14:45:54 agulbra Exp $

#include <qcursor.h>
#include <qapp.h>
#include <qpainter.h>
#include <q2matrix.h>
#include "qmag.h"

static const char * zoomfactors[] = { "100%", "200%", "300%", "400%", "500%", "600%", "700%", "800%", "1600%", NULL };

static const char * refreshrates[] = { "No autorefresh", "4 per second", "3 per second", "2 per second", "Every second", "Every two seconds", "Every three seconds", "Every five seconds", "Every ten seconds", NULL };
static const int timer[] = { 0, 250, 333, 500, 1000, 2000, 3000, 5000, 10000 };

MagWidget::MagWidget( QWidget *parent, const char *name )
    : QWidget( parent, name)
{
    int x, w, n;

    initMetaObject();

    zoom = new QComboBox( this );
    CHECK_PTR(zoom);
    zoom->setStrList( zoomfactors, 9 );
    w = 0;
    for( n=0; n<9; n++)
	w = QMAX(zoom->fontMetrics().width( zoomfactors[n] ), w);
    zoom->setGeometry( 2, 2, w+30, 20 );
    zoom->show();
    x = w+34;
    connect( zoom, SIGNAL(activated(int)), SLOT(setZoom(int)) );

    refresh = new QComboBox( this );
    CHECK_PTR(refresh);
    refresh->setStrList( refreshrates, 9 );
    w = 0;
    for( n=0; n<9; n++)
	w = QMAX(refresh->fontMetrics().width( refreshrates[n] ), w);
    refresh->setGeometry( x, 2, w+30, 20 );
    refresh->show();
    connect( refresh, SIGNAL(activated(int)), SLOT(setRefresh(int)) );

    z = 1;
    grabx = graby = -1;
    grabbing = FALSE;
}


void MagWidget::setZoom( int index ) {
    if (index == 8)
	z = 16;
    else
	z = index+1;
    grab();
}


void MagWidget::setRefresh( int index ) {
    r = index;
    killTimers();
    if (index && !grabbing)
	startTimer( timer[r] );
}


void MagWidget::grab( void ) {
    if (grabx < 0 || graby < 0)
	return;

    int x,y, w,h;

    w = (width()+z-1)/z;
    h = (height()+z-1)/z;
    x = grabx-w/2;
    y = graby-h/2;

    if ( x + w > QApplication::desktop()->width() )
	x = QApplication::desktop()->width()-w;
    else if ( x < 0 )
	x = 0;
    if ( y + h > QApplication::desktop()->height() ) 
	y = QApplication::desktop()->height()-h;
    else if ( y < 0 )
	y = 0;

    pm = QPixmap::grabWindow( QApplication::desktop()->id(), 
			      x, y, w, h );

    Q2DMatrix m;
    m.scale( (double)z, (double)z );
    pm = pm.xForm( m );
    repaint(FALSE);
}


void MagWidget::paintEvent( QPaintEvent * e ) {
    QPainter paint;
    paint.begin( this );
    if ( !pm.isNull() ) {
	paint.drawPixmap( 0, 0, pm );
    }
    paint.end();
}


void MagWidget::mousePressEvent( QMouseEvent * e ) {
    grabbing = !grabbing;
    if (grabbing) {
	killTimers();
	grabMouse();
	QApplication::setCursor( crossCursor );
    } else {
	releaseMouse();
	QApplication::restoreCursor();
	QApplication::syncX();
	grabx = mapToGlobal(e->pos()).x();
	graby = mapToGlobal(e->pos()).y();
	grab();
	if (r)
	    startTimer( timer[r] );
    }
}


void MagWidget::timerEvent( QTimerEvent * ) {
    grab();
}


void MagWidget::resizeEvent( QResizeEvent * ) {
    grab();
}


int main( int argc, char **argv ) {
    QApplication a( argc, argv );
    MagWidget *m;

    m = new MagWidget();
    m->show();
    exit( a.exec( m ) );
}
