/* Declarations for Checker.
   Copyright 1994 Tristan Gingold.
		  Written March 1994 by Tristan Gingold.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License as
published by the Free Software Foundation; either version 2 of the
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License 
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 The author may be reached (Email) at the address gingold@amoco.saclay.cea.fr,
 or (US/French mail) as   Tristan Gingold 
   			  8 rue Parmentier
   			  F-91120 PALAISEAU
   			  FRANCE
*/

#ifndef _CHECKER_H
#define _CHECKER_H	1

/* configuration file */
#include <features.h>
#include "machine.h"
#include "config.h"
#include "chkrlib.h"

#ifndef PTR
#define PTR void *
#endif

/* Sizes of the red zones, in byte. They must be a multiple of 4 or 8.
 * These red zones are used BEfore and AFter the blocks allocated by malloc 
 * and co. */
extern unsigned int be_red_zone;
extern unsigned int af_red_zone;

/* These structures contains info for each binary file (the executable and
 * the shared libs */
struct object
  {
    char *name;		/* path */
    uint text_org;	/* The first address of the text seg */
    uint text_beg;	/* The first page of the text seg */
    uint text_end;
    uint data_beg;
    uint data_end;
    uint bss_end;
    struct object *next;
  };
  
extern struct object *objects;

#ifdef CHKR_SAVESTACK
/* Defined in config/PROCESSOR/OS/xxx.c */
void chkr_save_stack(PTR *ptr, int forget, int num);
void chkr_initialize(void);
/* Defined in find_exec.c */
char *chkr_find_executable(char *file);
/* Defined in symtab.c */
void chkr_unload_symtab(void);
void chkr_load_symtab(void);
void chkr_show_addr(PTR *ptr);
void chkr_remove_symtabfile(void);
void chkr_show_frames(void);
extern PTR *chkr_frames_ip;
extern PTR *chkr_frames_pointer;
extern PTR known_stack_limit;
extern int chkr_frames_to_forget;
#endif /* CHKR_SAVESTACK */

#ifndef MDCHECKER
#define CHKR_UN	0	/* Can't neither read nor write */
#define CHKR_RO	1	/* Read only */
#define CHKR_WO	2	/* Write only */
#define CHKR_RW 3	/* Read and write */
#define CHKR_TW 6	/* Test for write, but no evolution */
#define CHKR_MASK 3	/* mask bits */
#define CHKR_EXEC 4	/* exec right */
extern int is_text_writable;	/* True if the text segment is writable */
extern unsigned int null_pointer_zone;
void chkr_set_right(const PTR ptr, int len, int right);
void chkr_check_addr(const PTR ptr, int len, int right);
void chkr_check_str(const PTR ptr, int right);
#endif /* !MDCHECKER */

#ifdef CHKR_PROFILE
void display_profile(void);
#endif

/* Fonction called in case of error */
void chkr_abort(void);
int chkr_report(int i);
int chkr_perror(int e);
void chkr_do_end(void);		/* function called just before _exit() */
char *copy_of_exec_file(register char *s);
int atod(const char *c);
void check_output_spec(void);
extern char *chkr_prog_path;
extern int chkr_errno;

/* These two addresses delimit the heap(s). */
extern PTR low_addr_heap;
extern PTR high_addr_heap;

/* Malloc functions, to be used internally */
void *sys_malloc(size_t real_size);
void sys_free(void * ptr);
void *sys_realloc (void * ptr, size_t size);
void *sys_dupalloc(void * ptr);

/* Stuff about pid. Defined in parse-args.c */
extern pid_t my_pid;
extern char my_pid_c[6];

/* How many fd are used by Checker. */
#define CHKR_OPEN 2
/* The first fd used by Checker. For example, if OPEN_MAX (defined by the
 *   system) is 256 and CHKR_OPEN is 2, Checker can use fd 254 and 255. */
#define CHKR_FIRST_FD	(OPEN_MAX - 1 - CHKR_OPEN)
/* The fd used by the output. */
#define CHKR_OUT_FD CHKR_FIRST_FD

#endif /* checker.h  */
