#define _MALLOC_INTERNAL
#define NEED_MM
#include "malloc.h"
#include "chkrlib.h"
#include <unistd.h>	/* For lseek */
#include <fcntl.h>

/* defined in maccess.c */
extern void remove_heap(int slot);

/* Terminate access to a mmalloc managed region by unmapping all memory pages
   associated with the region, and closing the file descriptor if it is one
   that we opened.

   Returns NULL on success.

   Returns the malloc descriptor on failure, which can subsequently be used
   for further action, such as obtaining more information about the nature of
   the failure by examining the preserved errno value.

   Note that the malloc descriptor that we are using is currently located in
   region we are about to unmap, so we first make a local copy of it on the
   stack and use the copy. */

PTR
mmalloc_detach (PTR md)
{
  struct mdesc mtemp;
  struct mdesc *mdp = (struct mdesc*)md;
  unsigned int pos;
  unsigned int mapinfo;
  struct bitmapinfo *bitmap;

  if (md != NULL)
    {

      mtemp = *(struct mdesc *) md;
      
      /* Unlink this mdesc */
      if (_firstmdesc == mdp)
        _firstmdesc = mdp->info.inmem.next_mdesc;
      else
        mdp->info.inmem.prev_mdesc->info.inmem.next_mdesc = mdp->info.inmem.next_mdesc;
      if (_lastmdesc == mdp)
        _lastmdesc = mdp->info.inmem.prev_mdesc;
      else
        mdp->info.inmem.next_mdesc->info.inmem.prev_mdesc = mdp->info.inmem.prev_mdesc;
          
      mapinfo = mdp->info.inmem.mapinfo;
      bitmap = mdp->info.inmem.bitmap;
      
      if (mtemp.fd >= 0 && !(mtemp.flags & MMALLOC_DEVZERO))
        {
          /* Save the bitmap at the end of the file. */
          ftruncate(mtemp.fd, mtemp.top - mtemp.base);
#ifndef MDCHECKER
          pos = lseek(mtemp.fd, 0, SEEK_END);
          write(mtemp.fd, bitmap->base, bitmap->size);
          mdp->info.ondisk.off_bitmap = pos;
          mdp->info.ondisk.len_bitmap = bitmap->size;

#ifdef linux
	  /* Save the data. */
          lseek(mtemp.fd, 0, SEEK_SET);
          write(mtemp.fd, mtemp.base, mtemp.top - mtemp.base);
#endif
#endif /* !MDCHECKER */
        }
      /* Now unmap all the pages associated with this region by asking for a
	 negative increment equal to the current size of the region. */
      
      if ((mtemp.morecore (&mtemp, mtemp.base - mtemp.breakval)) == NULL)
	{
	  /* Update the original malloc descriptor with any changes */
	  *(struct mdesc *) md = mtemp;
	}
      else
	{
	  if (mtemp.flags & MMALLOC_DEVZERO)
            close (mtemp.fd);
          /* Remove the history */
          if (mtemp.info.inmem.history)
            sys_free(mtemp.info.inmem.history);
#ifndef MDCHECKER
	  /* Remove the bitmap */
          munmap(bitmap->base, bitmap->pages * PAGESIZE);
          sys_free(bitmap);
          /* Remove the mapinfo */
          remove_heap(mapinfo);
#endif /* !MDCHECKER */
	  md = NULL;
	}
    }

  return (md);
}
