/* Written by T Gingold
 * This is a stub for 'open': the third argument is checked only if it is
 *  used.  Thus, bad warnings are avoided.
 */
#include "checker.h"
#include <fcntl.h>
#include <stdarg.h>

#undef open

int
open(const char *file, int oflag, ...)
{
  int res;
  
  chkr_check_addr(&file, sizeof(char*), CHKR_RO);
  chkr_check_addr(&oflag, sizeof(int*), CHKR_RO);
  chkr_check_str(file, CHKR_RO);
  
  if (oflag & O_CREAT)
    {
      int *mode = &oflag + 1;		/* not really portable */
      chkr_check_addr(mode, sizeof(int), CHKR_RO);
      res = chkr_open(file, oflag, *mode);
      errno = chkr_errno;
      return res;
    }

  res = chkr_open(file, oflag);
  errno = chkr_errno;
  return res;
}

#undef fcntl

int check_fcntl (int fd, int cmd, int arg);

/* This is a stub for fcntl. */
int
fcntl(int filedes, int cmd, ...)
{
  int res;
  int *arg = &cmd + 1;
  
  chkr_check_addr(&filedes, sizeof(int), CHKR_RO);
  chkr_check_addr(&cmd, sizeof(int), CHKR_RO);
  
  switch(cmd)
    {
      case F_GETFD:
      case F_GETFL:
      case F_GETOWN:
        /* The argument is not used. */
        break;
      default:
        /* By default, the argument is used. */
        chkr_check_addr(arg, sizeof(int), CHKR_RO);
    }
  check_fcntl(filedes, cmd, *arg);
  res = chkr_fcntl(filedes, cmd, *arg);
  errno = chkr_errno;
  return res;
}
