/* $Id: cinfolib.h,v 1.5 1995/08/09 10:03:32 sandro Exp $ */

/* This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */


#ifndef __CINFOLIB_H
#define __CINFOLIB_H

struct symbol_entry {
    char *name;
    struct symbol_entry *next;
};

struct header_entry {
    char *name;
    struct symbol_entry *head;
    struct header_entry *next;
};

struct library_entry {
    char *name;
    struct header_entry *head;
    struct library_entry *next;
};

extern char *cinfo_compact_info (char *o, char *i1, char *i2, char *i3, char *i4);
extern void cinfo_decompact_info (char *o, char *i1, char *i2, char *i3, char *i4);
extern char *cinfo_decompact_info_first (char *o, char *i1);

extern struct header_entry *cinfo_add_header_to_list (struct header_entry *list, struct header_entry *entry);
extern struct header_entry *cinfo_build_header_entry (char *name);
extern struct header_entry *cinfo_duplicate_header_list (struct header_entry *list);
extern struct header_entry *cinfo_query_header_list_about_header (struct header_entry *list, char *name);
extern struct header_entry *cinfo_query_header_list_about_symbol (struct header_entry *list, char *name);
extern struct header_entry *cinfo_search_header (struct header_entry *list, char *name);
extern struct library_entry *cinfo_add_library_to_list (struct library_entry *list, struct library_entry *entry);
extern struct library_entry *cinfo_build_library_entry (char *name);
extern struct library_entry *cinfo_duplicate_library_list (struct library_entry *list);
extern struct library_entry *cinfo_query_library_list_about_header (struct library_entry *list, char *name);
extern struct library_entry *cinfo_query_library_list_about_library (struct library_entry *list, char *name);
extern struct library_entry *cinfo_query_library_list_about_symbol (struct library_entry *list, char *name);
extern struct library_entry *cinfo_search_library (struct library_entry *list, char *name);
extern struct symbol_entry *cinfo_add_symbol_to_list (struct symbol_entry *list, struct symbol_entry *entry);
extern struct symbol_entry *cinfo_build_symbol_entry (char *name);
extern struct symbol_entry *cinfo_duplicate_symbol_list (struct symbol_entry *list);
extern struct symbol_entry *cinfo_query_symbol_list_about_symbol (struct symbol_entry *list, char *name);
extern struct symbol_entry *cinfo_search_symbol (struct symbol_entry *list, char *name);
extern void cinfo_explore_header_list (struct header_entry *list);
extern void cinfo_explore_library_list (struct library_entry *list);
extern void cinfo_explore_symbol_list (struct symbol_entry *list);
extern void cinfo_free_header_entry (struct header_entry *entry);
extern void cinfo_free_library_entry (struct library_entry *entry);
extern void cinfo_free_symbol_entry (struct symbol_entry *entry);
extern void cinfo_recursive_free_header_list (struct header_entry *list);
extern void cinfo_recursive_free_library_list (struct library_entry *list);
extern void cinfo_recursive_free_symbol_list (struct symbol_entry *list);

#endif /* __CINFOLIB_H */

/*
 * Local Variables:
 * truncate-lines: t
 * End:
 */
