/* $Id: hash.h,v 1.2 1995/08/06 18:23:23 sandro Exp $ */

#ifndef __HASH_H
#define __HASH_H

#define HASH_TABLE_SIZE		127

#define HASH_OK			0
#define HASH_INVALID_PARAMETER	-1
#define HASH_NOT_FOUND		-2
#define HASH_ALREADY_EXIST	-3

struct bucket {
    char *key;
    void *data;
    struct bucket *next;
};

struct hash_table {
    struct bucket *table[HASH_TABLE_SIZE];
};

extern struct hash_table *hash_table_build (void);
extern int hash_table_free (struct hash_table *);
extern int hash_table_add (struct hash_table *, char *);
extern int hash_table_lookup (struct hash_table *, char *);
extern int hash_table_remove (struct hash_table *, char *);
extern int hash_table_set_data (struct hash_table *, char *, void *);
extern void *hash_table_retrive_data (struct hash_table *, char *);

#endif /* __HASH_H */

/* hash.h ends here */
