%{

/* hsort.l -- sort #include directives.  -*- C -*-
   Copyright (C) 1995 Sandro Sigala - <sansig@freenet.hut.fi> */

/* $Id: hsort.l,v 1.15 1995/08/08 11:52:19 sandro Exp $ */

/* This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */


#include "version.h"

#if REPLACE_YYWRAP == 1
#undef yywrap
#define yywrap() 1
#endif

#define MAX_HEADERS	48
#define MAX_SIZE	36

#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

int headers_s_idx = 0;
int headers_l_idx = 0;

char headers_s[MAX_HEADERS][MAX_SIZE];
char headers_l[MAX_HEADERS][MAX_SIZE];

void add_header_s (char *);
void add_header_l (char *);
void flush_headers_s (void);
void flush_headers_l (void);
%}

hvalid_char				[^">]

%%

"#include <"{hvalid_char}+">\n"		{
					    char buf[128];

					    flush_headers_l ();
					    strcpy (buf, yytext + 10);
					    buf[strlen (buf) - 2] = 0;
					    add_header_s (buf);
					}

"#include "["]{hvalid_char}+["]"\n"	{
					    char buf[128];

					    flush_headers_s ();
					    strcpy (buf, yytext + 10);
					    buf[strlen (buf) - 2] = 0;
					    add_header_l (buf);
					}

.*\n					{
					    flush_headers_s ();
					    flush_headers_l ();
					    ECHO;
					}

%%

int
sort_function (const void *a, const void *b)
{
    return (strcmp ((char *) a, (char *) b));
}

void
add_header_s (char *s)
{
    strcpy (headers_s[headers_s_idx++], s);
}

void
add_header_l (char *s)
{
    strcpy (headers_l[headers_l_idx++], s);
}

void
flush_headers_s (void)
{
    int i = 0;

    qsort ((void *) headers_s, headers_s_idx,
	   sizeof (headers_s[0]), sort_function);

    while (i < headers_s_idx)
	fprintf (yyout, "#include <%s>\n", headers_s[i++]);

    headers_s_idx = 0;
}

void
flush_headers_l (void)
{
    int i = 0;

    qsort ((void *) headers_l, headers_l_idx,
	   sizeof (headers_l[0]), sort_function);

    while (i < headers_l_idx)
	fprintf (yyout, "#include \"%s\"\n", headers_l[i++]);

    headers_l_idx = 0;
}

void
helppage (char *progname)
{
    fprintf (stderr, "\
%s %s - c-tools %s - Copyright (C) 1995 Sandro Sigala.\n\
usage: %s [-h] [input [output]]\n\
       -h        display this help and exit\n\
", progname, VERSION_HSORT, VERSION_CTOOLS, progname);
    exit (0);
}

int
main (int argc, char *argv[])
{
    yyin = stdin;
    yyout = stdout;

    if (argc > 3)
	helppage (argv[0]);

    if (argc > 1)
    {
	if (strcmp (argv[1], "-h") == 0)
	    helppage (argv[0]);

	if (strcmp (argv[1], "-") != 0)
	    yyin = fopen (argv[1], "r");

	if (argc > 2)
	    if (strcmp (argv[2], "-") != 0)
		yyout = fopen (argv[2], "w");
    }

    if (yyin == NULL)
    {
	fprintf (stderr, "%s: cannot open input file\n", argv[0]);
	exit (1);
    }

    if (yyout == NULL)
    {
	fprintf (stderr, "%s: cannot open output file\n", argv[0]);
	exit (1);
    }

    while (yylex ())
	;

    flush_headers_s ();
    flush_headers_l ();

    return 0;
}

/* hsort.l ends here */
