/* ok.c */

/*
 * This software is in the public domain and may be freely copied and
 * distributed.
 *
 * THIS SOFTWARE IS BEING PROVIDED "AS IS", WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTY. IN PARTICULAR, THE AUTHORS DO NOT MAKE ANY REPRESENTATION OR
 * WARRANTY OF ANY KIND CONCERNING THE MERCHANTABILITY OF THIS SOFTWARE OR
 * ITS FITNESS FOR ANY PARTICULAR PURPOSE.
 */

/*
 * Test correct usage of EXC. If you modify any piece of EXC in any way, it is
 * recommended that you recompile and rerun this program to ensure that your
 * modifications don't break EXC, unless you deliberately modify EXC semantics.
 *
 * This file is *not* meant to be used as a tutorial on how to use EXC - it
 * is necessarily opaque in most places.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>

#undef EXC_NOPOLLUTE
#include "exc.h"

exc_decl (e);

#ifdef __GNUC__

int
t29a (int *i)
{
    try
	++*i;
	eraise (e);
	abort ();
    except (e)
	++*i;
        try ++*i; ereturn2 (*i); abort (); end
	abort ();
    end
    abort ();
}

void
t29 ()
{
    int i=0;
    assert (t29a (&i) == 3);
    assert (i == 3);
}

int
t28a (int *i)
{
    try
	++*i;
    finally
	++*i;
	ereturn2 (*i);
	abort ();
    end
    abort ();
}

void
t28 ()
{
    int i=0;
    assert (t28a (&i) == 2);
    assert (i == 2);
}

#endif /* __GNUC__ */

void
t27a (int *i)
{
    try
	++*i;
    finally
	++*i;
	ereturn;
	abort ();
    end
    abort ();
}

void
t27 ()
{
    int i=0;
    t27a (&i);
    assert (i == 2);
}

void
t26a (int *i)
{
    try
	++*i;
        try
	    ++*i;
	    eraise2 (e, ("string1"));
	    abort ();
        finally
	    ++*i;
	    try
		++*i;
	        eraise2 (e, ("string2"));
		abort ();
	    except (e)
		++*i;
	        assert (!strcmp ("string2", exc_info));
	    end
	    ++*i;
        end
	abort ();
    except (e)
	++*i;
	assert (!strcmp ("string1", exc_info));
    end
    ++*i;
}

void t26 ()
{
    int i=0;
    t26a (&i);
    assert (i == 8);
}

void
t25a (int *i)
{
    try
	++*i;
	goto label;
	/* NOTREACHED */
	abort ();
label :
	++*i;
    end
    ++*i;
}

void
t25 ()
{
    int i=0;
    t25a (&i);
    assert (i == 3); 
}

void
t24a (int *i)
{
    ++*i;
    goto label;
    /* NOTREACHED */
    abort ();
label :
    ++*i;
}

void
t24 ()
{
    int i=0;
    t24a (&i);
    assert (i == 2);
}

void
t23a (int *i)
{
    try
	++*i;
        switch (++*i) default: { ++*i; break; }
	++*i;
    end
    ++*i;
}

void
t23 ()
{
    int i=0;
    t23a (&i);
    assert (i == 5);
}

void
t22a (int *i)
{
    volatile int j = 0;

    try
	++*i;
	while (1) { ++*i; if (!j++) continue; else break; }
	++*i;
	for (j=0;;) { ++*i; if (!j++) continue; else break; }
	++*i;
    end
    ++*i;
}

void
t22 ()
{
    int i=0;
    t22a (&i);
    assert (i == 8);
}

void
t21a (int *i)
{
    try
	++*i;
	while (1) break;
	++*i;
	for (;;) break;
	++*i;
    end
    ++*i;
}

void
t21 ()
{
    int i=0;
    t21a (&i);
    assert (i == 4);
}

void
t20 ()
{
    /*
     * If you remove the volatile qualifier below and compile with maximum
     * optimization, you are likely to get an assertion failure since the
     * compiler might optimize away some assignments to variable "count" or
     * assign it to a register, unaware of a possible longjmp that will render
     * those optimizations invalid from the user's point of view, but valid
     * from the compiler's point of view. Note that this behavior is consistent
     * with ANSI C - we *must* use volatile.
     */

    volatile int count;

    count = -1;
    try
	count = 0;
	while (1) {
	    count++;
	    eraise (e);
	}
    except (e)
	assert (count == 1);
    end
}

void
t19a (int *i)
{
    exc_decl (e1);
    exc_decl (e2);

    try
	++*i;
	try
	    ++*i;
	    eraise (e1);
	    abort ();
	finally
	    try
		++*i;
		eraise (e2);
		abort ();
	    except (e2)
		++*i;
	    end
	    ++*i;
	end
	abort ();
    except (e1)
	++*i;
    end
    ++*i;
}

void
t19 ()
{
    /* hint: "if (cb == _exc_handler) _exc_handler = 0;" :^) */
    int i=0;
    t19a (&i);
    assert (i == 7);
}

int
t18a ()
{
    return 1729;
    abort ();
}

void
t18 ()
{
    assert (t18a () == 1729);
}

void
t17 ()
{
    return;
    abort ();
}

void
t16a (int *i)
{
    try
	++*i;
	try
	    ++*i;
	    eraise (e);
	except (e)
	    ++*i;
	    ereraise;
	    abort ();
	end
	abort ();
    except (e)
	++*i;
    end
    ++*i;
}

void
t16 ()
{
    int i=0;
    t16a (&i);
    assert (i == 5);
}

#ifdef __GNUC__

int
t15b ()
{
    eraise (e);
    abort ();
}

int
t15a (int *i)
{
    try
	++*i;
	ereturn2 (t15b ());
	abort ();
    except (e)
	++*i;
    end
    ++*i;

    return *i;
}

void
t15 ()
{
    int i=0;
    assert (t15a (&i) == 3);
    assert (i == 3);
}

#endif /* __GNUC__ */

void
t14c (int *i)
{
    try
	++*i;
	eraise (e);
	abort ();
    finally
	++*i;
    end
    abort ();
}

void
t14b (int *i)
{
    try
	++*i;
	eraise (e);
	abort ();
    end
    abort ();
}

void
t14a ()
{
    eraise (e);
    abort ();
}

void
t14 ()
{
    volatile int i;

    i=0;
    try
	++i;
	t14a ();
	abort ();
    except (e)
	++i;
    end
    assert (i == 2); 

    i=0;
    try
	++i;
	t14b ((int *) &i);
	abort ();
    except (e)
	++i;
    end
    assert (i == 3);

    i=0;
    try
	++i;
	t14c ((int *) &i);
	abort ();
    except (e)
	++i;
    end
    assert (i == 4);
}

void
t13a (int *i)
{
    exc_decl (e1);
    exc_decl (e2);
    exc_parent (e1, e2);

    try
	++*i;
	eraise (e1);
	abort ();
    except (e2)
	assert (exc_name == e1.name);
	++*i;
    except (any)
	abort ();
    end
    ++*i;
}

void
t13 ()
{
    int i=0;
    t13a (&i);
    assert (i == 3);
}

void
t12a (int *i)
{
    try
	++*i;
	eraise2 (e, ("0123456789"));
	abort ();
    except (e)
	++*i;
	try
	    ++*i;
	    assert (exc_name == e.name);
	    assert (exc_line == __LINE__-7);
	    assert (!strcmp (exc_file, __FILE__));
	    assert (!strcmp (exc_info, "0123456789"));
	    ++*i;
	end
	++*i;
    end
    ++*i;
}

void
t12 ()
{
    int i=0;
    t12a (&i);
    assert (i == 6);
}

void
t11a (int *i)
{
    try
	++*i;
	try
	    ++*i;
	    eraise (e);
	    abort ();
	finally
	    ++*i;
	    eraise (e);
	    abort ();
	end
	abort ();
    except (e)
	++*i;
    end
    ++*i;
}

void
t11 ()
{
    int i=0;
    t11a (&i);
    assert (i == 5);
}

void
t10a (int *i)
{
    try
	++*i;
	try
	    ++*i;
	    eraise (e);
	    abort ();
	finally
	    ++*i;
	end
	abort ();
    except (e)
	++*i;
    end
    ++*i;
}

void
t10 ()
{
    int i=0;
    t10a (&i);
    assert (i == 5);
}

void
t9a (int *i)
{
    exc_decl (e1);
    exc_decl (e2);
    exc_parent (e1, e2);

    try
	++*i;
	eraise (e1);
	abort ();
    except (e1)
	++*i;
    except (e2)
	abort ();
    except (any)
	abort ();
    end
    ++*i;
}

void
t9 ()
{
    int i=0;
    t9a (&i);
    assert (i == 3);
}

void
t8a (int *i)
{
    try
	++*i;
	eraise (e);
	abort ();
    except (any)
	assert (exc_name == e.name);
	++*i;
    end
    ++*i;
}

void
t8 ()
{
    int i=0;
    t8a (&i);
    assert (i == 3);
}

void
t7a (int *i)
{
    try
	++*i;
	eraise (e);
	abort ();
    except (e)
	++*i;
    end
    ++*i;
}

void
t7 ()
{
    int i=0;
    t7a (&i);
    assert (i == 3);
}

void
t6a (int *i)
{
    try
	++*i;
    finally
	++*i;
    end
    ++*i;
}

void
t6 ()
{
    int i=0;
    t6a (&i);
    assert (i == 3);
}

#ifdef __GNUC__

int
t5a (int *i)
{
    try
	++*i;
	ereturn2 (1729);
	abort ();
    end
    abort ();
}

void
t5 ()
{
    int i=0;
    assert (t5a (&i) == 1729);
    assert (i == 1);
}

#endif /* __GNUC__ */

void
t4a (int *i)
{
    try
	++*i;
	ereturn;
	abort ();
    end
    abort ();
}

void
t4 ()
{
    int i=0;
    t4a (&i);
    assert (i == 1);
}

#ifdef __GNUC__

int
t3a ()
{
    ereturn2 (1729);
    abort ();
}

void
t3 ()
{
    assert (t3a () == 1729);
}

#endif /* __GNUC__ */

void
t2 ()
{
    ereturn;
    abort ();
}

void
t1a (int *i)
{
    try ++*i; end
    ++*i;
}

void
t1 ()
{
    int i=0;
    t1a (&i);
    assert (i == 2);
}

int
main ()
{
    exc_debug = 1;
    exc_no_goto_in_try = 0; /* for t25 */

    assert (!_exc_stack);

#ifdef __GNUC__
    t3 (); t5 (); t15 (); t28 (); t29 ();
#endif
    t1 (); t2 (); t4 (); t6 (); t7 (); t8 (); t9 (); t10 (); t11 (); t12 ();
    t13 (); t14 (); t16 (); t17 (); t18 (); t19 (); t20 (); t21 (); t22 ();
    t23 (); t24 (); t25 (); t26 (); t27 ();

    assert (!_exc_stack);

    return 0;
}
