/* icntoeps.c: convert RIP .ICN file (EGA) to Encapsulated PostScript(R)
 *
 * Eric P. Scott, San Francisco State University, February 1994
 * Copyright 1994 by Eric P. Scott.  All rights reserved.
 *
 * This software is "freeware" but is not in the public domain.
 *
 * The author grants you a nonexclusive royalty-free license to copy,
 * redistribute, and use this software for any purpose provided that
 * source distributions retain this entire copyright and license.
 * You may not sublicense or distribute modified versions to anyone else
 * except as part of another product or program, and modified versions
 * must be so labeled.
 *
 * You are encouraged to give proper credit to the author in binary
 * distributions and associated documentation.
 *
 * This software is provided "as is" with no warranties of any kind,
 * including the warranties of merchantability and fitness for a
 * particular purpose.
 *
 * PostScript is a registered trademark of Adobe Systems Incorporated.
 *
 * RIPscrip is a trademark of TeleGrafix Communications, Inc.
 *
 * This software is not supported or endorsed by TeleGrafix.
 *
 */

/*
 * This program processes the Icon File format described in _RIPscrip
 * Graphics Protocol Specification_, Revision 1.54, by TeleGrafix
 * Communications, Inc.
 */

/* Revision History
 *
 * 1.0  2/24/94  EPS  Initial Release
 * 1.1  4/ 9/94  EPS  Explicitly unsigned LHS of >> for Solaris
 *
 */

#ifndef lint
static char sccsid[]="@(#)icntoeps.c	1.1 (SFSU) 4/9/94";
#endif

#ifdef NX_COMPILER_RELEASE_3_0
#include <ansi/stdio.h>
#include <ansi/stdlib.h>
#include <ansi/math.h>
#include <ansi/string.h>
#include <ansi/time.h>
#include <bsd/sys/types.h>
#include <bsd/sys/stat.h>
#else
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>
#include <time.h>
#include <sys/types.h>
#include <sys/stat.h>
#endif

main(int argc, char *argv[])
{
	register unsigned char *p;
	register int c;
	register unsigned int l, r;
	unsigned int width, height;
	unsigned char *ibuf, *lbuf;
	unsigned int bpr, cheap;
	register char *q;
	short colors;
	struct stat st;

	if (argc!=2) {
		(void)fprintf(stderr, "Usage: %s file\n", *argv);
		exit(1);
	}
	if (!freopen(argv[1], "rb", stdin)) {
		perror(argv[1]);
		exit(1);
	}
	if ((c=getchar())==EOF) {
	runt:
		(void)fprintf(stderr, "%s: short file?\n", argv[1]);
		exit(1);
	}
	width=c&0xff;
	if ((c=getchar())==EOF) goto runt;
	width+=(c&0xff)<<8;
	if ((c=getchar())==EOF) goto runt;
	height=c&0xff;
	if ((c=getchar())==EOF) goto runt;
	height+=(c&0xff)<<8;
	if (height>=12696||width>=3300) {
		(void)fprintf(stderr, "%s: absurd image dimensions %u x %u?\n",
		*argv, width+1, height+1);
		exit(1);
	}
	width++;
	height++;
	if (!(ibuf=(unsigned char *)malloc((size_t)((width+1)/2)*height+4))) {
		(void)fprintf(stderr, "%s: malloc failed for %u x %u?\n",
			*argv, width, height);
		exit(1);
	}
	/* convert planar to meshed and note colors actually used */
	colors=0;
	lbuf=ibuf;
	r=height; do {
		p=lbuf;
		for (l=0;l<width;l+=8) {
			if ((c=getchar())==EOF) goto runt;
			*p=0;
			if (c&128) *p=0x80;
			if (c&64) *p|=8;
			*++p=0;
			if (c&32) *p=0x80;
			if (c&16) *p|=8;
			*++p=0;
			if (c&8) *p=0x80;
			if (c&4) *p|=8;
			*++p=0;
			if (c&2) *p=0x80;
			if (c&1) *p|=8;
			p++;
		}
		p=lbuf;
		for (l=0;l<width;l+=8) {
			if ((c=getchar())==EOF) goto runt;
			if (c&128) *p|=0x40;
			if (c&64) *p|=4;
			p++;
			if (c&32) *p|=0x40;
			if (c&16) *p|=4;
			p++;
			if (c&8) *p|=0x40;
			if (c&4) *p|=4;
			p++;
			if (c&2) *p|=0x40;
			if (c&1) *p|=4;
			p++;
		}
		p=lbuf;
		for (l=0;l<width;l+=8) {
			if ((c=getchar())==EOF) goto runt;
			if (c&128) *p|=0x20;
			if (c&64) *p|=2;
			p++;
			if (c&32) *p|=0x20;
			if (c&16) *p|=2;
			p++;
			if (c&8) *p|=0x20;
			if (c&4) *p|=2;
			p++;
			if (c&2) *p|=0x20;
			if (c&1) *p|=2;
			p++;
		}
		p=lbuf;
		for (l=8;l<width;l+=8) {
			if ((c=getchar())==EOF) goto runt;
			if (c&128) *p|=0x10;
			colors|=1<<((*p>>4)&0xf);
			if (c&64) *p|=1;
			colors|=1<<(*p++&0xf);
			if (c&32) *p|=0x10;
			colors|=1<<((*p>>4)&0xf);
			if (c&16) *p|=1;
			colors|=1<<(*p++&0xf);
			if (c&8) *p|=0x10;
			colors|=1<<((*p>>4)&0xf);
			if (c&4) *p|=1;
			colors|=1<<(*p++&0xf);
			if (c&2) *p|=0x10;
			colors|=1<<((*p>>4)&0xf);
			if (c&1) *p|=1;
			colors|=1<<(*p++&0xf);
		}
		l-=8;
		if (l<width) {
			if ((c=getchar())==EOF) goto runt;
			if (c&128) *p|=0x10;
			colors|=1<<((*p>>4)&0xf);
			if (c&64) *p|=1;
			if (++l<width) colors|=1<<(*p++&0xf);
			if (c&32) *p|=0x10;
			if (++l<width) colors|=1<<((*p>>4)&0xf);
			if (c&16) *p|=1;
			if (++l<width) colors|=1<<(*p++&0xf);
			if (c&8) *p|=0x10;
			if (++l<width) colors|=1<<((*p>>4)&0xf);
			if (c&4) *p|=1;
			if (++l<width) colors|=1<<(*p++&0xf);
			if (c&2) *p|=0x10;
			if (++l<width) colors|=1<<((*p>>4)&0xf);
			if (c&1) *p|=1;
			if (++l<width) colors|=1<<(*p++&0xf);
		}
		lbuf+=(width+1)/2;
	} while (--r>0);
#ifdef DEBUG
	while ((c=getchar())!=EOF)
		(void)fprintf(stderr, "garbage byte: %02x\n", c&0xff);
	(void)fputs("colors used:", stderr);
	if (colors==0) (void)fputs(" (none)\n", stderr);
	else {
		if (colors&1) (void)fputs(" black", stderr);
		if (colors&2) (void)fputs(" blue", stderr);
		if (colors&4) (void)fputs(" green", stderr);
		if (colors&8) (void)fputs(" cyan", stderr);
		if (colors&0x10) (void)fputs(" red", stderr);
		if (colors&0x20) (void)fputs(" magenta", stderr);
		if (colors&0x40) (void)fputs(" brown", stderr);
		if (colors&0x80) (void)fputs(" lightgray", stderr);
		if (colors&0x100) (void)fputs(" darkgray", stderr);
		if (colors&0x200) (void)fputs(" lightblue", stderr);
		if (colors&0x400) (void)fputs(" lightgreen", stderr);
		if (colors&0x800) (void)fputs(" lightcyan", stderr);
		if (colors&0x1000) (void)fputs(" lightred", stderr);
		if (colors&0x2000) (void)fputs(" lightmagenta", stderr);
		if (colors&0x4000) (void)fputs(" yellow", stderr);
		if (colors&0x8000) (void)fputs(" white", stderr);
		(void)fputc('\n', stderr);
	}
#endif
	(void)fputs("%!PS-Adobe-3.0 EPSF-3.0\n%%Title: ", stdout);
	q=strrchr(argv[1], '/');
	(void)fputs(q ? q+1 : argv[1], stdout);
	(void)fputs("\n%%Creator: icntoeps\n%%CreationDate: ", stdout);
	(void)fstat(fileno(stdin), &st);
	(void)fputs(ctime(&st.st_mtime), stdout);
	(void)fputs("%%Pages: 0\n%%BoundingBox: 0 0 ", stdout);
	(void)printf("%u %u", width,
		(unsigned int)ceil(((double)height*40.0)/31.0));
	(void)fputs("\n%%DocumentData: Clean7Bit\n", stdout);
	if (colors&0x7e7e) (void)fputs("%%Extensions: CMYK\n", stdout);
	(void)fputs("%%EndComments\n%%BeginProlog\n%%EndProlog\n", stdout);
	cheap=0;
	lbuf=ibuf;
	if (colors&0x7e7e) {	/* color image */
		static const char cmap[]="000\00000a\0000a0\0000aa\000\
a00\000a0a\000a50\000aaa\000555\00055f\0005f5\0005ff\000f55\000f5f\000\
ff5\000fff";

		bpr=(width*3+1)/2;
		if ((unsigned long)bpr*height<=65535L) cheap=1;
		else (void)printf("1 dict begin\n/picstr %u string def\n",
			bpr);
		(void)printf("matrix currentmatrix\n\
%u %u 40 mul 31 div scale\n", width, height);
		(void)printf("%u %u 4\n[%u 0 0 -%u 0 %u]\n",
			width, height, width, height, height);
		if (!cheap) (void)fputs(
			"{currentfile picstr readhexstring pop} false 3\n",
			stdout);
		(void)printf("%%%%BeginData: %lu Hex Lines\n",
			(unsigned long)height*((width+23)/24)+1+cheap);
		(void)fputs(cheap ? "{<" : "colorimage", stdout);
		r=height; do {
			p=lbuf;
			for (l=0;l<width;l++) {
				if ((l%24)==0) putchar('\n');
				(void)fputs(&cmap[((*p>>4)&0xf)*4], stdout);
				if (++l>=width) {
					putchar('0');
					break;
				}
				(void)fputs(&cmap[(*p++&0xf)*4], stdout);
			}
			lbuf+=(width+1)/2;
		} while (--r>0);
		if (cheap) (void)fputs("\n>}", stdout);
		(void)fputs("\n%%EndData\n", stdout);
		if (cheap) (void)fputs("false 3 colorimage\n", stdout);
	}
	else if (colors&0x180) { /* gray scale */
		static const char gmap[]={ '0', '2', '1', '3', '8', 'a',
			 '9', 'b', '4', '6', '5', '7', 'c', 'e', 'd', 'f' };

		bpr=(width+3)/4;
		if ((unsigned long)bpr*height<=65535L) cheap=1;
		else (void)printf("1 dict begin\n/picstr %u string def\n",
			bpr);
		(void)printf("matrix currentmatrix\n\
%u %u 40 mul 31 div scale\n", width, height);
		(void)printf("%u %u 2\n[%u 0 0 -%u 0 %u]\n",
			width, height, width, height, height);
		if (!cheap) (void)fputs(
			"{currentfile picstr readhexstring pop}\n", stdout);
		(void)printf("%%%%BeginData: %lu Hex Lines\n",
			(unsigned long)height*((width+143)/144)+1+cheap);
		(void)fputs(cheap ? "{<" : "image", stdout);
		r=height; do {
			p=lbuf;
			for (l=0;l<width;l++) {
				if ((l%144)==0) putchar('\n');
				c=(*p>>4)&0xc;
				if (++l<width) c|=(*p++>>2)&3;
				putchar(gmap[c]);
				c=0;
				if (++l<width) c=(*p>>4)&0xc;
				if (++l<width) c|=(*p++>>2)&3;
				putchar(gmap[c]);
			}
			lbuf+=(width+1)/2;
		} while (--r>0);
		if (cheap) (void)fputs("\n>}", stdout);
		(void)fputs("\n%%EndData\n", stdout);
		if (cheap) (void)fputs("image\n", stdout);
	}
	else {	/* bilevel */
		bpr=(width+7)/8;
		if ((unsigned long)bpr*height<=65535L) cheap=1;
		else (void)printf("1 dict begin\n/picstr %u string def\n",
			bpr);
		(void)printf("matrix currentmatrix\n\
%u %u 40 mul 31 div scale\n", width, height);
		(void)printf("%u %u 1\n[%u 0 0 -%u 0 %u]\n",
			width, height, width, height, height);
		if (!cheap) (void)fputs(
			"{currentfile picstr readhexstring pop}\n", stdout);
		(void)printf("%%%%BeginData: %lu Hex Lines\n",
			(unsigned long)height*((width+287)/288)+1+cheap);
		(void)fputs(cheap ? "{<" : "image", stdout);
		r=height; do {
			p=lbuf;
			for (l=0;l<width;l++) {
				if ((l%288)==0) putchar('\n');
				c= *p&0x80;
				if (++l<width) c|=(*p++&8)<<3;
				if (++l<width) c|=(*p>>2)&0x20;
				if (++l<width) c|=(*p++&8)<<1;
				if (++l<width) c|=(*p>>4)&8;
				if (++l<width) c|=(*p++&8u)>>1;
				if (++l<width) c|=(*p>>6)&2;
				if (++l<width) c|=(*p++&8u)>>3;
				(void)printf("%02x", c);
			}
			lbuf+=(width+1)/2;
		} while (--r>0);
		if (cheap) (void)fputs("\n>}", stdout);
		(void)fputs("\n%%EndData\n", stdout);
		if (cheap) (void)fputs("image\n", stdout);
	}
	(void)fputs("setmatrix\n", stdout);
	if (!cheap) (void)fputs("end\n", stdout);
	(void)fputs("%%EOF\n", stdout);
	/* free(ibuf) */
	exit(0);
}
