/************************************************/
/*                                              */
/*    Visual X windows Programming Interface    */
/*    ======================================    */
/*                                              */
/*      Copyright (C) 1994  by  Yong Chen       */
/*                                              */
/************************************************/

/* application C source code */

/* include part */

/* X11 and Motif includes part */
#include <stdio.h>
#include <Xm/Xm.h>
#include <Xm/Label.h>
#include <Xm/Separator.h>
#include <Xm/Text.h>
#include <Xm/PushB.h>
#include <Xm/BulletinB.h>
#include <X11/Shell.h>
#include <Xm/FileSB.h>

/* application's include part */



















/* global definition part */

/* Defines object's Global Access Array */
typedef struct {
	Widget editor;
	Widget BulletinBoard1;
	Widget Text1;
	Widget Separator1;
	Widget save;
	Widget filebox;
	Widget PushButton2;
	Widget Label1;
} _GAArray;
static _GAArray vxpOBJ;

/* application's global definitions */



















/*
 *main()
*/
void
main(int argc, char **argv)
{
	/* variable & prototype declaration */
	XtAppContext app_context;
	void vxpInitial();
	Widget editor;
	void editor_destroy_cb();
	void editor_popup_cb();
	void editor_popdown_cb();
	Widget BulletinBoard1;
	Widget Text1;
	void Text1_motionVerify_cb();
	void Text1_modifyVerify_cb();
	void Text1_losingFocus_cb();
	void Text1_focus_cb();
	void Text1_activate_cb();
	void Text1_valueChanged_cb();
	Widget Separator1;
	Widget save;
	void save_destroy_cb();
	void save_disarm_cb();
	void save_arm_cb();
	void save_activate_cb();
	Widget filebox;
	void filebox_ok_cb();
	void filebox_cancel_cb();
	void filebox_apply_cb();
	void filebox_noMatch_cb();
	Widget PushButton2;
	void PushButton2_activate_cb();
	Widget Label1;

	/* create topLevel widget, initialize application */
	editor = XtVaAppInitialize(&app_context, "Editor",
		NULL, 0, &argc, argv, NULL, NULL);
	vxpOBJ.editor = editor;

	/* widgets creation */

	BulletinBoard1 = XtVaCreateWidget("BulletinBoard1",
		xmBulletinBoardWidgetClass,
		editor, NULL);
	XtVaSetValues(BulletinBoard1, XmNx, 0, XmNy, 0,
		XmNwidth, 517, XmNheight, 380,
		NULL );
	vxpOBJ.BulletinBoard1 = BulletinBoard1;

	Text1 = XtVaCreateWidget("Text1",
		xmTextWidgetClass,
		BulletinBoard1, NULL);
	XtVaSetValues(Text1, XmNx, 21, XmNy, 14,
		XmNwidth, 479, XmNheight, 256,
		XtVaTypedArg, XmNeditable, XmRString,
		"True", 5,
		XtVaTypedArg, XmNeditMode, XmRString,
		"XmMULTI_LINE_EDIT", 18,
		NULL );
	XtAddCallback(Text1, XmNmotionVerifyCallback,
		Text1_motionVerify_cb, (XtPointer) NULL);
	XtAddCallback(Text1, XmNmodifyVerifyCallback,
		Text1_modifyVerify_cb, (XtPointer) NULL);
	XtAddCallback(Text1, XmNlosingFocusCallback,
		Text1_losingFocus_cb, (XtPointer) NULL);
	XtAddCallback(Text1, XmNfocusCallback,
		Text1_focus_cb, (XtPointer) NULL);
	XtAddCallback(Text1, XmNactivateCallback,
		Text1_activate_cb, (XtPointer) NULL);
	XtAddCallback(Text1, XmNvalueChangedCallback,
		Text1_valueChanged_cb, (XtPointer) NULL);
	XtManageChild(Text1);
	vxpOBJ.Text1 = Text1;

	Separator1 = XtVaCreateWidget("Separator1",
		xmSeparatorWidgetClass,
		BulletinBoard1, NULL);
	XtVaSetValues(Separator1, XmNx, 10, XmNy, 279,
		XmNwidth, 495, XmNheight, 17,
		NULL );
	XtManageChild(Separator1);
	vxpOBJ.Separator1 = Separator1;

	save = XtVaCreateWidget("save",
		xmPushButtonWidgetClass,
		BulletinBoard1, NULL);
	XtVaSetValues(save, XmNx, 33, XmNy, 311,
		XmNwidth, 108, XmNheight, 36,
		XtVaTypedArg, XmNrecomputeSize, XmRString,
		"False", 6,
		XtVaTypedArg, XmNlabelString, XmRString,
		"Save", 5,
		XtVaTypedArg, XmNfontList, XmRString,
		"9x15bold", 9,
		XtVaTypedArg, XmNforeground, XmRString,
		"white", 6,
		NULL );
	XtAddCallback(save, XmNdestroyCallback,
		save_destroy_cb, (XtPointer) NULL);
	XtAddCallback(save, XmNdisarmCallback,
		save_disarm_cb, (XtPointer) NULL);
	XtAddCallback(save, XmNarmCallback,
		save_arm_cb, (XtPointer) NULL);
	XtAddCallback(save, XmNactivateCallback,
		save_activate_cb, (XtPointer) NULL);
	XtManageChild(save);
	vxpOBJ.save = save;

	filebox = XmCreateFileSelectionDialog(save, "filebox", NULL, 0 );
	XtVaSetValues(filebox, XmNx, 178, XmNy, 385,
		XmNwidth, 286, XmNheight, 374,
		XtVaTypedArg, XmNautoUnmanage, XmRString,
		"True", 5,
		NULL );
	XtAddCallback(filebox, XmNokCallback,
		filebox_ok_cb, (XtPointer) NULL);
	XtAddCallback(filebox, XmNcancelCallback,
		filebox_cancel_cb, (XtPointer) NULL);
	XtAddCallback(filebox, XmNapplyCallback,
		filebox_apply_cb, (XtPointer) NULL);
	XtAddCallback(filebox, XmNnoMatchCallback,
		filebox_noMatch_cb, (XtPointer) NULL);
	vxpOBJ.filebox = filebox;

	PushButton2 = XtVaCreateWidget("PushButton2",
		xmPushButtonWidgetClass,
		BulletinBoard1, NULL);
	XtVaSetValues(PushButton2, XmNx, 402, XmNy, 309,
		XmNwidth, 99, XmNheight, 36,
		XtVaTypedArg, XmNforeground, XmRString,
		"white", 6,
		XtVaTypedArg, XmNrecomputeSize, XmRString,
		"False", 6,
		XtVaTypedArg, XmNlabelString, XmRString,
		"QUIT", 5,
		XtVaTypedArg, XmNfontList, XmRString,
		"9x15bold", 9,
		NULL );
	XtAddCallback(PushButton2, XmNactivateCallback,
		PushButton2_activate_cb, (XtPointer) NULL);
	XtManageChild(PushButton2);
	vxpOBJ.PushButton2 = PushButton2;

	Label1 = XtVaCreateWidget("Label1",
		xmLabelWidgetClass,
		BulletinBoard1, NULL);
	XtVaSetValues(Label1, XmNx, 171, XmNy, 308,
		XmNwidth, 209, XmNheight, 38,
		XtVaTypedArg, XmNlabelString, XmRString,
		"Eddie's Editor (C) 1994", 24,
		XtVaTypedArg, XmNforeground, XmRString,
		"white", 6,
		NULL );
	XtManageChild(Label1);
	vxpOBJ.Label1 = Label1;

	XtManageChild(BulletinBoard1);

	/* Create windows for widgets and map them. */
	XtRealizeWidget(editor);
	vxpInitial();
	/* Loop for events. */
	XtAppMainLoop(app_context);
}


void editor_destroy_cb
(Widget w, XtPointer client_data, XmAnyCallbackStruct *cbs)
{

}






void editor_popup_cb
(Widget w, XtPointer client_data, XmAnyCallbackStruct *cbs)
{

}






void editor_popdown_cb
(Widget w, XtPointer client_data, XmAnyCallbackStruct *cbs)
{

}






void Text1_motionVerify_cb
(Widget w, XtPointer client_data, XmTextVerifyCallbackStruct *cbs)
{

}






void Text1_modifyVerify_cb
(Widget w, XtPointer client_data, XmTextVerifyCallbackStruct *cbs)
{

}






void Text1_losingFocus_cb
(Widget w, XtPointer client_data, XmTextVerifyCallbackStruct *cbs)
{

}






void Text1_focus_cb
(Widget w, XtPointer client_data, XmAnyCallbackStruct *cbs)
{

}






void Text1_activate_cb
(Widget w, XtPointer client_data, XmAnyCallbackStruct *cbs)
{

}






void Text1_valueChanged_cb
(Widget w, XtPointer client_data, XmAnyCallbackStruct *cbs)
{

}






void save_destroy_cb
(Widget w, XtPointer client_data, XmAnyCallbackStruct *cbs)
{

}






void save_disarm_cb
(Widget w, XtPointer client_data, XmPushButtonCallbackStruct *cbs)
{

}






void save_arm_cb
(Widget w, XtPointer client_data, XmPushButtonCallbackStruct *cbs)
{

}






void save_activate_cb
(Widget w, XtPointer client_data, XmPushButtonCallbackStruct *cbs)
{
    /* pop up file selection box */
     XtManageChild(vxpOBJ.filebox);
    
}



















void filebox_ok_cb
(Widget w, XtPointer client_data, XmFileSelectionBoxCallbackStruct *cbs)
{
     String filename;
     FILE *out;
     char *text;

     if (!XmStringGetLtoR(cbs->value, XmSTRING_DEFAULT_CHARSET, &filename))
		return; 	/* must be an internal error */
     printf("filename is %s\n", filename);
     text = XmTextGetString(vxpOBJ.Text1);
     printf("text is %s\n", text);
     out = fopen(filename, "w");
     fputs(text, out);
     fclose(out);	 
}














void filebox_cancel_cb
(Widget w, XtPointer client_data, XmFileSelectionBoxCallbackStruct *cbs)
{

}





void filebox_apply_cb
(Widget w, XtPointer client_data, XmFileSelectionBoxCallbackStruct *cbs)
{

}





void filebox_noMatch_cb
(Widget w, XtPointer client_data, XmFileSelectionBoxCallbackStruct *cbs)
{

}





void PushButton2_activate_cb
(Widget w, XtPointer client_data, XmPushButtonCallbackStruct *cbs)
{
    void exit();
	
	printf("exit!\n");
	exit(0);
    
}



















/* application's initial routine */
void vxpInitial()
{

}



















/* application's functions */

















