 
/*{{{  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * **/
     /*                                                                           */
     /*                                  ---                    -                 */
     /*   Modul X1.C  alias  XbWS alias "XbWindows hardwarenahe Subroutinen"      */
     /*                                  ---                    -                 */
     /*                                                                           */
     /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/*}}}  */
/*{{{  Header--------------------------------------------------------------------*/
#include "xbw.h"
#include <unistd.h>
#include <X11/Xmu/Drawing.h>
#include <string.h>

/*}}}  */

/*  ---------------------Compiler-Modelle-----------------------------*/
                      /* ---............Nicht moeglich */
                      /* ///............Nicht NOETIG   */
                      /* !!!............Noch zu machen */
                      /* ???............unklar         */
                      /* TC3............Turbo-C Version*/
                      /*     GNU........32-Bit Version */
                      /*         X11....X-Windows      */

void XbWFSy_bf_printf(char *a, char *b){
  char sstr[200];
  int ii;
  sprintf(sstr,a,b);
  for (ii=0;ii<strlen(sstr);ii++){
    printf("%c%c%c",sstr[ii],0x08,sstr[ii]);
    };
  };

 
/*{{{  XbWSSy_ObjLoadIcon(         X11*/
int  XbWSSy_ObjLoadIcon(void  *(*p)[], int (*t)[]){
  /* Lade eine Datei als Bitmap und setze einen pn-Pointer auf
     den allozierten Speicherbereich */
  XbWDDb_DbINPtr  *TTRG;
  XbWDDb_DbIVar  *TV;
  char objname[50], filename[200], bitmaptype[50];
 
  /* Erwartete Parameter: "Objekt","File", "XY"|"Z" */
  if ( (int)(*p)[0] < 3){ return(1); };
  switch( (int)(*t)[1] ) {
    case XbWDMf_StrPar:
      strcpy(objname,(char*)(XbWFTb_PckTxt((char*)(*p)[1])));
      break;
    case XbWDMf_VLPar:
      {
        XbWDDb_DbIVar  *QQ;
        char *fsp;
        QQ = (XbWDDb_DbIVar  *)(*p)[1];
        if (QQ == NULL) { return(1); };
        fsp = (char*)XbWFDb_VarInh(QQ,XbWDDb_Str,NULL,1);
        if (fsp != NULL) {
          strcpy(objname,(char*)XbWFTb_PckTxt(fsp));
          };
        };
      break;
    };
 
  switch( (int)(*t)[2] ) {
    case XbWDMf_StrPar:
      strcpy(filename,(char*)(XbWFTb_PckTxt((char*)(*p)[2])));
      break;
    case XbWDMf_VLPar:
      {
        XbWDDb_DbIVar  *QQ;
        char *fsp;
        QQ = (XbWDDb_DbIVar  *)(*p)[2];
        if (QQ == NULL) { return(1); };
        fsp = (char*)XbWFDb_VarInh(QQ,XbWDDb_Str,NULL,1);
        if (fsp != NULL) {
          strcpy(filename,(char*)XbWFTb_PckTxt(fsp));
          };
        };
      break;
    };
 
  switch( (int)(*t)[3] ) {
    case XbWDMf_StrPar:
      strcpy(bitmaptype,(char*)(XbWFTb_PckTxt((char*)(*p)[3])));
      break;
    case XbWDMf_VLPar:
      {
        XbWDDb_DbIVar  *QQ;
        char *fsp;
        QQ = (XbWDDb_DbIVar  *)(*p)[3];
        if (QQ == NULL) { return(1); };
        fsp = (char*)XbWFDb_VarInh(QQ,XbWDDb_Str,NULL,1);
        if (fsp != NULL) {
          strcpy(bitmaptype,(char*)XbWFTb_PckTxt(fsp));
          };
        };
      break;
    };
 
 
  if ((TV = XbWFDb_FindGrp("OBJ",objname) ) == NULL) {
    return(1);
    };
  if ((TTRG = (XbWDDb_DbINPtr *)XbWFDb_VarInh(TV,0,"Image",0)) == NULL) {
    return(1);
    };
  if ((TTRG->tp & XbWDDb_Typ) == XbWDDb_NPtr) {
    unsigned char *pmap_data;
    XImage *image;
    int w,h,xh,yh;
    if (XmuReadBitmapDataFromFile(
        filename,
        &w, &h,
        &pmap_data,
        &xh, &yh
        ) == BitmapSuccess){
      switch(bitmaptype[0]){
        case 'x':
        case 'X':
          image = XCreateImage(
            XbWVSy_ConTxt.dpy,
            XDefaultVisualOfScreen(XbWVSy_ConTxt.screen),
            1,
            XYBitmap,
            0,
            pmap_data,
            w,
            h,
            8,
            0);
          break;
        case 'z':
        case 'Z':
          image = XCreateImage(
            XbWVSy_ConTxt.dpy,
            XDefaultVisualOfScreen(XbWVSy_ConTxt.screen),
            8,
            ZPixmap,
            0,
            pmap_data,
            w,
            h,
            8,
            0);
          break;
        default:return(1);
        };
      TTRG->inh = (long)image;
 
      XbWFDb_PutNum(TV,"width",1,w);
      XbWFDb_PutNum(TV,"height",1,h);
      XbWFDb_PutNum(TV,"xhot",1,xh);
      XbWFDb_PutNum(TV,"yhot",1,yh);
      return(0);
      };
    };
  return(1);
  };
/*}}}  */
/*{{{  XbWSSy_ObjDispIcon(         X11    Icon (X11-Bitmap) darstellen*/
void  XbWSSy_ObjDispIcon(XbWDDb_DbIObj  *TO){
  XImage *theimage;
  int x,y,xp,yp;
  char *txtstr;
  XbWDDb_DbINPtr  *TTRG;
 
  txtstr = (char*)XbWFDb_VarInh(TO->chn,XbWDDb_Str,"V",1);
 
  if ((TTRG = (XbWDDb_DbINPtr *)XbWFDb_VarInh(TO->chn,0,"Image",0)) == NULL) {
    return;
    };
  if ((TTRG->tp & XbWDDb_Typ) != XbWDDb_NPtr) {
    return;
    };
  theimage = (XImage *)TTRG->inh;
  x      = XbWFDb_GetNum(TO->chn,"width",1);
  y      = XbWFDb_GetNum(XbWVDb_ActGrp1,"height",1);
 
  if (theimage->width  != x){ return; };
  if (theimage->height != y){ return; };
 
  xp = (XbWVOb_X+XbWVOb_x)/2 - x/2;
  yp = (XbWVOb_Y+XbWVOb_y)/2 - y/2;
 
  XSetForeground(XbWVSy_ConTxt.dpy,XbWVSy_ConTxt.gc,
    XbWVGr_ColorValues[*TO->bfc] );
  XSetBackground(XbWVSy_ConTxt.dpy,XbWVSy_ConTxt.gc,
    XbWVGr_ColorValues[*TO->dfc] );
  XPutImage(
    XbWVSy_ConTxt.dpy,
    XbWVSy_ConTxt.window,
    XbWVSy_ConTxt.gc,
    theimage,
    0,0,
    xp+XbWVSy_ConTxt.XA,yp+XbWVSy_ConTxt.YA,
    x,y);
  if (txtstr != NULL){
    XbWSGr_BCBox(XbWVOb_X,XbWVOb_Y,XbWVOb_x-XbWVOb_X,XbWVOb_y-XbWVOb_Y,txtstr,*TO->bkc,*TO->txc,*TO->bkc);
    };
  };
/*}}}  */
/*{{{  XbWSSy_ConvertFileName(     X11    DOS to UNIX Konversion*/
char XbWVSy_ConvertFileNameStr[200]="";
char *XbWSSy_ConvertFileName(char *fname){
  int ii;
  char sstr[200];
  strcpy(sstr,fname);
  if ( (strstr(sstr,"@(dir)") != NULL) ||
      (strstr(sstr,"@(DIR)") != NULL) ){
    char pstr[200];
    char thepath[200];
    getcwd(thepath,199);
    strcpy(pstr,"\\");
    strcat(pstr,thepath);
    strcat(pstr,"\\");
    strcat(pstr,strstr(sstr,"@(dir)")+6);
    strcpy(sstr,pstr);
    };
  if (sstr[0] == '@'){
    char tstr[200];
    sprintf(tstr,"%s%s",XbWVSy_AppPath,(char*)&(sstr[1]));
    strcpy(sstr,tstr);
    };
  for (ii=0;ii<strlen(sstr);ii++){
    if (sstr[ii] == '\\'){
      sstr[ii] = '/';
      }
    else {
      if ((sstr[ii] >= 'A') & (sstr[ii] <= 'Z')){
        sstr[ii] = tolower(sstr[ii]);
        };
      };
    };
  if (XbWVMf_prd){
    printf("FILENAME converted: >>>%s<<< to >>>%s<<<\n",fname,sstr);
    };
  strcpy(XbWVSy_ConvertFileNameStr,sstr);
  return(XbWVSy_ConvertFileNameStr);
  };
/*}}}  */
/*{{{  XbWSSy_fopen(       TC3,GNU,X11    allgemeines open*/
FILE  *XbWSSy_fopen(char *name, char *type){
  int ii;
  char sstr[200];
  strcpy(sstr,name);
  if ( (strstr(sstr,"@(dir)") != NULL) ||
      (strstr(sstr,"@(DIR)") != NULL) ){
    char pstr[200];
    char thepath[200];
    getcwd(thepath,199);
    strcpy(pstr,"\\");
    strcat(pstr,thepath);
    strcat(pstr,"\\");
    strcat(pstr,strstr(sstr,"@(dir)")+6);
    strcpy(sstr,pstr);
    };
  if (sstr[0] == '@'){
    char tstr[200];
    sprintf(tstr,"%s%s",XbWVSy_AppPath,(char*)&(sstr[1]));
    strcpy(sstr,tstr);
    };
  for (ii=0;ii<strlen(sstr);ii++){
    if (sstr[ii] == '\\'){
      sstr[ii] = '/';
      }
    else {
      if ((sstr[ii] >= 'A') & (sstr[ii] <= 'Z')){
        sstr[ii] = tolower(sstr[ii]);
        };
      };
    };
  if (XbWVMf_prd){
    FILE *fp;
    char *sres=">>>FAILED<<<";
    fp = fopen(sstr,type);
    if (fp != NULL){
      sres="      OK";
      };
    printf("%s to open %s (with %s)\n",sres,sstr,type);
    return(fp);
    }
  else {
    return(fopen(sstr,type));
    };
  };

/*}}}  */
/*{{{  XbWFTb_Unlink(      ***            Datei loeschen*/
int  XbWFTb_Unlink(void  *(*p)[]){
  char sstr[200];
  int ii;
 
  if ((int)(*p)[0] != 2){ return(1); };
  sprintf(sstr,"%s%s",(char*)(*p)[1],(char*)(*p)[2]);
  if ( (strstr(sstr,"@(dir)") != NULL) ||
      (strstr(sstr,"@(DIR)") != NULL) ){
    char pstr[200];
    char thepath[200];
    getcwd(thepath,199);
    strcpy(pstr,"\\");
    strcat(pstr,thepath);
    strcat(pstr,"\\");
    strcat(pstr,strstr(sstr,"@(dir)")+6);
    strcpy(sstr,pstr);
    };
  if (sstr[0] == '@'){
    char tstr[200];
    sprintf(tstr,"%s%s",XbWVSy_AppPath,(char*)&(sstr[1]));
    strcpy(sstr,tstr);
    };
  for (ii=0;ii<strlen(sstr);ii++){
    if (sstr[ii] == '\\'){
      sstr[ii] = '/';
      }
    else {
      if ((sstr[ii] >= 'A') & (sstr[ii] <= 'Z')){
        sstr[ii] = tolower(sstr[ii]);
        };
      };
    };
  if (XbWVMf_prd){
    printf("\nCAUTION: DELETE >>>%s<<<?\n",sstr);
    puts("Please press 'Y<CR>' to accept; anything else will skip delete");
    if (tolower(getchar())=='y'){
      printf("DELETING >>>%s<<<?\n",sstr);
      getchar();
      }
    else {
      return(0);
      };
    };
  unlink(sstr);
  return(0);
  };
/*}}}  */
/*{{{  XbWSSy_chdirsub(    TC3,GNU,X11    allgemeines chdir*/
int  XbWSSy_chdirsub(char *name){
  int ii;
  char sstr[200];
  strcpy(sstr,name);
#ifdef XbW_SYSDEF_X11_VERSION
  for (ii=0;ii<strlen(sstr);ii++){
    if (sstr[ii] == '\\'){
      sstr[ii] = '/';
      }
    else {
      sstr[ii] = tolower(sstr[ii]);
      };
    };
#endif
  if (strstr(sstr,"@(prj)") != NULL){
    char tstr[200];
    char pstr[200];
    sprintf(pstr,"/xw/x/app/%s@(prj)",XbWVSy_PrjName);
    strcpy(tstr,sstr);
    strcpy(strstr(tstr,"@(prj)"),pstr);
    strcpy(strstr(tstr,"@(prj)"),strstr(sstr,"@(prj)"));
    strcpy(sstr,tstr);
    };
  if (strstr(sstr,"@(dir)") != NULL){
    char tstr[200];
    char pstr[200];
    char thepath[200];
    getcwd(thepath,199);
    sprintf(pstr,"%s@(dir)",thepath);
    strcpy(tstr,sstr);
    strcpy(strstr(tstr,"@(dir)"),pstr);
    strcpy(strstr(tstr,"@(dir)"),strstr(sstr,"@(dir)"));
    strcpy(sstr,tstr);
    };
  if (sstr[0] == '@'){
    char tstr[200];
    sprintf(tstr,"%s%s",XbWVSy_AppPath,(char*)&(sstr[1]));
    strcpy(sstr,tstr);
    };
  return(chdir(sstr));
  };

/*}}}  */
/*{{{  XbWFSy_ChDir(               X11    Wechsle Verzeichnis*/
int  XbWFSy_ChDir(void  *(*p)[],int (*t)[]){
  char dirname[60];
 
  strcpy(dirname,"");
  if ((int)(*p)[0] < 1 ) {return(XbWDMf_NoPara);};
  switch( (int)(*t)[1] ) {
    case XbWDMf_StrPar:
      strcpy(dirname,(char*)(XbWFTb_PckTxt((char*)(*p)[1])));
      break;
    case XbWDMf_VLPar:
      {
        XbWDDb_DbIVar  *QQ;
        char *fsp;
        QQ = (XbWDDb_DbIVar  *)(*p)[1];
        if (QQ == NULL) { return(1); };
        fsp = (char*)XbWFDb_VarInh(QQ,XbWDDb_Str,NULL,1);
        if (fsp != NULL) {
          strcpy(dirname,(char*)XbWFTb_PckTxt(fsp));
          };
        };
      break;
    };
 
  XbWSSy_chdirsub(dirname);
  return(0);
  };
/*}}}  */
/*{{{  XbWSMs_SetXXXCursor(t--,GNU,X11    Maustreiber Cursor waehlen*/
/*{{{  XbWSMs_SetStopCursor(   GNU,X11    Maustreiber Handcursor*/
void  *XbWSMs_SetStopCursor(void){
#ifdef XbW_SYSDEF_GNU_VERSION
  extern GrCursor *XbWVMs_PtrPtrStop;
  int cols[3];
  GrCursor *oldcursor;

  oldcursor = XbWVMs_PtrActualPtr;
  cols[0] = 2;
  cols[1] = 15;
  cols[2] = 12;
  if(XbWVMs_PtrPtrStop == NULL) {
    XbWVMs_PtrPtrStop = GrBuildCursor(XbWVMs_PtrStop,12,16,1,1,cols);
    };
  if (XbWVMs_PtrActualPtr != XbWVMs_PtrPtrStop){
    MouseSetCursor(XbWVMs_PtrPtrStop);
    };
  XbWVMs_PtrActualPtr = XbWVMs_PtrPtrStop;
  return(oldcursor);
#endif
#ifdef XbW_SYSDEF_X11_VERSION
  extern Cursor XbWVMs_PtrPtrStop;
  Cursor oldcursor;

  oldcursor = XbWVMs_PtrActualPtr;
  if(XbWVMs_PtrPtrStop == 0) {
    XbWVMs_PtrPtrStop = XCreateFontCursor(XbWVSy_ConTxt.dpy,XC_pirate);
    };
  if (XbWVMs_PtrActualPtr != XbWVMs_PtrPtrStop){
    XDefineCursor(XbWVSy_ConTxt.dpy,XbWVSy_ConTxt.window,XbWVMs_PtrPtrStop);
    };
  XbWVMs_PtrActualPtr = XbWVMs_PtrPtrStop;
  return((void  *)oldcursor);
#endif
  return(NULL);
  };
/*}}}  */
/*{{{  XbWSMs_SetHandCursor(   GNU,X11    Maustreiber Handcursor*/
void  *XbWSMs_SetHandCursor(void){
#ifdef XbW_SYSDEF_GNU_VERSION
  extern GrCursor *XbWVMs_PtrPtrHand;
  int cols[3];
  GrCursor *oldcursor;

  oldcursor = XbWVMs_PtrActualPtr;
  cols[0] = 2;
  cols[1] = 0;
  cols[2] = 15;
  if(XbWVMs_PtrPtrHand == NULL) {
    XbWVMs_PtrPtrHand = GrBuildCursor(XbWVMs_PtrHand,12,16,1,1,cols);
    };
  if (XbWVMs_PtrActualPtr != XbWVMs_PtrPtrHand){
    MouseSetCursor(XbWVMs_PtrPtrHand);
    };
  XbWVMs_PtrActualPtr = XbWVMs_PtrPtrHand;
  return(oldcursor);
#endif
#ifdef XbW_SYSDEF_X11_VERSION
  extern Cursor XbWVMs_PtrPtrHand;
  Cursor oldcursor;

  oldcursor = XbWVMs_PtrActualPtr;
  if(XbWVMs_PtrPtrHand == 0) {
    XbWVMs_PtrPtrHand = XCreateFontCursor(XbWVSy_ConTxt.dpy,XC_fleur);
    };
  if (XbWVMs_PtrActualPtr != XbWVMs_PtrPtrHand){
    XDefineCursor(XbWVSy_ConTxt.dpy,XbWVSy_ConTxt.window,XbWVMs_PtrPtrHand);
    };
  XbWVMs_PtrActualPtr = XbWVMs_PtrPtrHand;
  return((void  *)oldcursor);
#endif
  return(NULL);
  };
/*}}}  */
/*{{{  XbWSMs_SetClockCursor(  GNU,X11    Maustreiber Handcursor*/
void  *XbWSMs_SetClockCursor(void){
#ifdef XbW_SYSDEF_GNU_VERSION
  extern GrCursor *XbWVMs_PtrPtrClock;
  int cols[3];
  GrCursor *oldcursor;
  oldcursor = XbWVMs_PtrActualPtr;

  cols[0] = 2;
  cols[1] = 0;
  cols[2] = 15;
  if(XbWVMs_PtrPtrClock == NULL) {
    XbWVMs_PtrPtrClock = GrBuildCursor(XbWVMs_PtrClock,12,16,1,1,cols);
    };
  if (XbWVMs_PtrActualPtr != XbWVMs_PtrPtrClock){
    MouseSetCursor(XbWVMs_PtrPtrClock);
    };
  XbWVMs_PtrActualPtr = XbWVMs_PtrPtrClock;
  return(oldcursor);
#endif
#ifdef XbW_SYSDEF_X11_VERSION
  extern Cursor XbWVMs_PtrPtrClock;
  Cursor oldcursor;
  oldcursor = XbWVMs_PtrActualPtr;
  if(XbWVMs_PtrPtrClock == 0) {
    XbWVMs_PtrPtrClock = XCreateFontCursor(XbWVSy_ConTxt.dpy,XC_watch);
    };
  if (XbWVMs_PtrActualPtr != XbWVMs_PtrPtrClock){
    XDefineCursor(XbWVSy_ConTxt.dpy,XbWVSy_ConTxt.window,XbWVMs_PtrPtrClock);
    };
  XbWVMs_PtrActualPtr = XbWVMs_PtrPtrClock;
  return((void  *)oldcursor);
#endif
  return(NULL);
  };
/*}}}  */
/*{{{  XbWSMs_SetArrowCursor(  GNU,X11    Maustreiber Pfeilcursor*/
void  *XbWSMs_SetArrowCursor(void){
#ifdef XbW_SYSDEF_GNU_VERSION
  extern GrCursor *XbWVMs_PtrPtrArrow;
  int cols[3];
  GrCursor *oldcursor;
  oldcursor = XbWVMs_PtrActualPtr;

  cols[0] = 2;
  cols[1] = 0;
  cols[2] = 15;
  if(XbWVMs_PtrPtrArrow == NULL) {
    XbWVMs_PtrPtrArrow = GrBuildCursor(XbWVMs_PtrArrow,12,16,1,1,cols);
    };
  if (XbWVMs_PtrActualPtr != XbWVMs_PtrPtrArrow){
    MouseSetCursor(XbWVMs_PtrPtrArrow);
    };
  XbWVMs_PtrActualPtr = XbWVMs_PtrPtrArrow;
  return(oldcursor);
#endif
#ifdef XbW_SYSDEF_X11_VERSION
  extern Cursor XbWVMs_PtrPtrArrow;
  Cursor oldcursor;
  oldcursor = XbWVMs_PtrActualPtr;
  if(XbWVMs_PtrPtrArrow == 0) {
    XbWVMs_PtrPtrArrow = XCreateFontCursor(XbWVSy_ConTxt.dpy,XC_left_ptr);
    };
  if (XbWVMs_PtrActualPtr != XbWVMs_PtrPtrArrow){
    XDefineCursor(XbWVSy_ConTxt.dpy,XbWVSy_ConTxt.window,XbWVMs_PtrPtrArrow);
    };
  XbWVMs_PtrActualPtr = XbWVMs_PtrPtrArrow;
  return((void  *)oldcursor);
#endif
  return(NULL);
  };
/*}}}  */
/*{{{  XbWSMs_SetLastCursor(   GNU X11    Maustreiber Pfeilcursor*/
void  *XbWSMs_SetLastCursor(void  *p){
#ifdef XbW_SYSDEF_GNU_VERSION
  extern GrCursor *XbWVMs_PtrPtrArrow;
  int cols[3];

  cols[0] = 2;
  cols[1] = 0;
  cols[2] = 15;
  if (XbWVMs_PtrActualPtr != (GrCursor *)p){
    MouseSetCursor((GrCursor *)p);
    XbWVMs_PtrActualPtr = (GrCursor *)p;
    };
  return(XbWVMs_PtrActualPtr);
#endif
#ifdef XbW_SYSDEF_X11_VERSION
  if (XbWVMs_PtrActualPtr != (Cursor)p){
    XDefineCursor(XbWVSy_ConTxt.dpy,XbWVSy_ConTxt.window,(Cursor)p);
    XbWVMs_PtrActualPtr = (Cursor)p;
    };
  return((void  *)XbWVMs_PtrActualPtr);
#endif
  return(NULL);
  };
/*}}}  */
/*}}}  */
/*{{{  XbWSMs_XXXXXXXXXXXX(TC3,GNU,x//    Maustreiber Funktionen*/
/*{{{  XbWSMs_DrInit(      TC3,GNU        Maustreiber init*/
void  XbWSMs_DrInit(void){
  XbWVMs_CFrm = pfeil;
  XbWVMs_CX = 1; XbWVMs_CY = 1;
  XbWVMs_XPos = 1;       XbWVMs_YPos = 1;   XbWVMs_CSet = 0;
  if (XbWSMs_Init()==0)   {
#ifdef USE_PC_SOUND
    sound(2000);
#endif
    puts("Please connect your GENIUS Mouse !!");
#ifdef USE_PC_SOUND
    nosound();
#endif
    exit(1);
    };
#ifdef XbW_SYSDEF_TC3_VERSION
#ifdef XbWDMs_SoftMs
  XbWVMs_bits = farcalloc(1,imagesize(0,0,10,10));
  if (XbWVMs_bits == NULL) {
#ifdef USE_PC_SOUND
    sound(2000);
#endif
    puts("No heap memory available!!");
#ifdef USE_PC_SOUND
    nosound();
#endif
    exit(1);
    };
#endif
#endif

#ifdef XbW_SYSDEF_GNU_VERSION
  if (MouseDetect()){
    MouseEventMode(1);
    MouseInit();
    MouseDisplayCursor();
    };
#endif
  XbWVMs_CSet = 0;
  XbWVMs_XPos = XbWVMs_YPos = 10;
  XbWVMs_CX = XbWVMs_CY = 10;
  XbWVMs_CSet = 0;
  XbWSMs_ON();
  XbWSMs_OFF();
  };
/*}}}  */
/*{{{  XbWSMs_DrReset(     TC3,GNU        Maustreiber rcksetzen*/
void  XbWSMs_DrReset(void){
#ifdef XbW_SYSDEF_TC3_VERSION
  XbWVMs_CSet = 1;
  XbWSMs_Hd();
  while (XbWSMs_Init()==0) {
    XbWSPu_Alarm("Please connect your GENIUS Mouse !!");
    };
  XbWSMs_ResPos();
  XbWSMs_Sh();
#endif
#ifdef XbW_SYSDEF_GNU_VERSION
  if (MouseDetect()){
    MouseEventMode(1);
    MouseInit();
    MouseDisplayCursor();
    };
#endif
  };
/*}}}  */
/*{{{  XbWSMs_Init(        TC3,GNU        Maus initialisieren*/
boolean  XbWSMs_Init(void){
#ifdef XbW_SYSDEF_TC3_VERSION
  boolean okay;  okay = 1;
  XbWFGr_MaxPort();
  XbWVMs_regs.x.ax = 0;    /*Maus init */
  int86(0x33,&XbWVMs_regs,&XbWVMs_regs);
  if (XbWVMs_regs.x.ax == 0)   {okay = 0;}
  else {okay = 1;}

  XbWVMs_CSet = 0;
  if (okay == 1)   {
    XbWVMs_regs.x.ax = 14;
    int86(0x33,&XbWVMs_regs,&XbWVMs_regs);
    XbWVMs_XSense = 10;
    XbWVMs_YSense = 10;
    XbWVMs_Speed = 20;
    XbWVMs_regs.x.ax = 7;
    XbWVMs_regs.x.cx = 2;
#ifdef ALTER_MAUSTREIBER
    XbWVMs_regs.x.dx = 640;
#else
    XbWVMs_regs.x.dx = XbWSGr_GtPhysX();
#endif
    int86(0x33,&XbWVMs_regs,&XbWVMs_regs);
    XbWVMs_regs.x.ax = 8;
    XbWVMs_regs.x.cx = 2;
#ifdef ALTER_MAUSTREIBER
    XbWVMs_regs.x.dx = 480;
#else
    XbWVMs_regs.x.dx = XbWSGr_GtPhysY();
#endif
    int86(0x33,&XbWVMs_regs,&XbWVMs_regs);

    XbWSMs_SetSens();
    XbWSMs_SetSped();

  #ifdef HARDWARE_MAUS
    XbWVMs_regs.x.ax = 1;
    /* Cursor EIN */
    int86(0x33,&XbWVMs_regs,&XbWVMs_regs);
  #else
    XbWVMs_regs.x.ax = 2;
    /* Cursor AUS */
    int86(0x33,&XbWVMs_regs,&XbWVMs_regs);
  #endif
    }
  return okay;
#endif
#ifdef XbW_SYSDEF_GNU_VERSION
  if (MouseDetect()){
    MouseEventMode(1);
    MouseInit();
    MouseDisplayCursor();

    };
#endif
#ifdef XbW_SYSDEF_X11_VERSION
  return(1);
#endif
  }
/*}}}  */
/*{{{  XbWSMs_Stop(        TC3,GNU        Ende; Interrupts freigeben*/
void  XbWSMs_Stop(void){
  XbWSMs_Hd();
#ifdef XbW_SYSDEF_TC3_VERSION
  XbWVMs_regs.x.ax = 0;    /*Maus init */
  int86(0x33,&XbWVMs_regs,&XbWVMs_regs);
#endif
#ifdef XbW_SYSDEF_GNU_VERSION
  MouseUnInit();
#endif
  };
/*}}}  */
/*{{{  XbWSMs_SetSens(     TC3,GNU        Empfindlichkeit der Maus*/
void  XbWSMs_SetSens(void){
#ifdef XbW_SYSDEF_TC3_VERSION
    XbWVMs_regs.x.ax = 15;
    XbWVMs_regs.x.cx = XbWVMs_XSense;
    XbWVMs_regs.x.dx = XbWVMs_YSense;
    int86(0x33,&XbWVMs_regs,&XbWVMs_regs);
#endif
#ifdef XbW_SYSDEF_GNU_VERSION
#endif
    };
/*}}}  */
/*{{{  XbWSMs_SetSped(     TC3,GNU        Geschwindigkeit der Maus*/
void  XbWSMs_SetSped(void){
#ifdef XbW_SYSDEF_TC3_VERSION
    XbWVMs_regs.x.ax = 19;
    XbWVMs_regs.x.dx = XbWVMs_Speed;
    int86(0x33,&XbWVMs_regs,&XbWVMs_regs);
#endif
#ifdef XbW_SYSDEF_GNU_VERSION
#endif
    };
/*}}}  */
/*{{{  XbWSMs_Sh(          TC3,GNU        Mauscursor zeigen*/
void  XbWSMs_Sh(void){
  if (!XbWVMs_CSet) {
#ifdef XbW_SYSDEF_TC3_VERSION

#ifndef XbWDMs_SoftMs
    XbWVMs_regs.x.ax = 1;
    /* Cursor EIN */
    int86(0x33,&XbWVMs_regs,&XbWVMs_regs);
#endif
#endif

#ifdef XbW_SYSDEF_GNU_VERSION
    if (!MouseCursorIsDisplayed()){
      MouseDisplayCursor();
      };
#endif
    XbWVMs_CSet = 1;
    };
  };
/*}}}  */
/*{{{  XbWSMs_Hd(          TC3,GNU        Mauscursor verstecken*/
void  XbWSMs_Hd(void){
  if (XbWVMs_CSet) {
#ifdef XbW_SYSDEF_TC3_VERSION
    XbWVMs_regs.x.ax = 2;
    /* Cursor AUS */
    int86(0x33,&XbWVMs_regs,&XbWVMs_regs);
#endif
    XbWVMs_CSet = 0;
#ifdef XbW_SYSDEF_GNU_VERSION
    if (MouseCursorIsDisplayed()){
      MouseEraseCursor();
      };
#endif
    };
  };
/*}}}  */
/*{{{  XbWSMs_ON(          TC3,GNU        Startet XbWSMs_Sh*/
void  XbWSMs_ON(void){
#ifdef XbW_SYSDEF_TC3_VERSION
#ifdef XbWDMs_SoftMs
  if ((XbWVMs_XPos > XbWFGr_MaxX() - 12) | (XbWVMs_YPos > XbWFGr_MaxY() - 12)){
    return;
    };
  if ((XbWVMs_axa != XbWVMs_XPos+XbWVIDEO_XA)|(XbWVMs_aya != XbWVMs_YPos+XbWVIDEO_YA)) {
    if ((XbWVMs_aya > -30000) & (XbWVMs_axa > -30000)) {
      putimage(XbWVMs_axa,XbWVMs_aya,XbWVMs_bits,COPY_PUT);
      };
    XbWVMs_axa = XbWVMs_XPos+XbWVIDEO_XA; XbWVMs_aya = XbWVMs_YPos+XbWVIDEO_YA;
    getimage(XbWVMs_axa,XbWVMs_aya,XbWVMs_axa+10,XbWVMs_aya+10,XbWVMs_bits);
    setcolor(DARKGRAY);
    setfillstyle(SOLID_FILL,DARKGRAY);
    bar(XbWVMs_axa+0,XbWVMs_aya+0,XbWVMs_axa+6,XbWVMs_aya+6);
    line(XbWVMs_axa+9,XbWVMs_aya+7,XbWVMs_axa+9,XbWVMs_aya+9);
    line(XbWVMs_axa+7,XbWVMs_aya+9,XbWVMs_axa+9,XbWVMs_aya+9);
    line(XbWVMs_axa+3,XbWVMs_aya+1,XbWVMs_axa+9,XbWVMs_aya+7);
    line(XbWVMs_axa+1,XbWVMs_aya+3,XbWVMs_axa+7,XbWVMs_aya+9);
    setcolor(WHITE);
    line(XbWVMs_axa+1,XbWVMs_aya+1,XbWVMs_axa+8,XbWVMs_aya+8);
    line(XbWVMs_axa+1,XbWVMs_aya+2,XbWVMs_axa+7,XbWVMs_aya+8);
    line(XbWVMs_axa+2,XbWVMs_aya+1,XbWVMs_axa+8,XbWVMs_aya+7);
    line(XbWVMs_axa+1,XbWVMs_aya+1,XbWVMs_axa+1,XbWVMs_aya+5);
    line(XbWVMs_axa+1,XbWVMs_aya+1,XbWVMs_axa+5,XbWVMs_aya+1);
    line(XbWVMs_axa+2,XbWVMs_aya+1,XbWVMs_axa+2,XbWVMs_aya+5);
    line(XbWVMs_axa+1,XbWVMs_aya+2,XbWVMs_axa+5,XbWVMs_aya+2);
    };
  XbWVMs_CSet = 1;
#endif
#endif
#ifdef XbW_SYSDEF_GNU_VERSION
#endif
  XbWSMs_Sh();
  };
/*}}}  */
/*{{{  XbWSMs_OFF(         TC3,GNU        Startet XbWSMs_Hd*/
void  XbWSMs_OFF(void){
#ifdef XbW_SYSDEF_TC3_VERSION
#ifdef XbWDMs_SoftMs
  if ((XbWVMs_XPos > XbWFGr_MaxX() - 12) | (XbWVMs_YPos > XbWFGr_MaxY() - 12)){
    return;
    };
  if ((XbWVMs_axa > -30000) & (XbWVMs_aya >-30000)) {
    putimage(XbWVMs_axa,XbWVMs_aya,XbWVMs_bits,COPY_PUT);
    XbWVMs_axa = -30000; XbWVMs_aya = -30000;
    };
  XbWVMs_CSet = 0;
#endif
#endif
#ifdef XbW_SYSDEF_GNU_VERSION
#endif
  XbWSMs_Hd();
  };
/*}}}  */
/*{{{  XbWSMs_Warp(        TC3,GNU        Mauscursor verschieben*/
void  XbWSMs_Warp(int x,int y){
#ifdef XbW_SYSDEF_TC3_VERSION
  XbWVMs_CX = x; XbWVMs_CY = y;
  XbWVMs_XPos = x;   XbWVMs_YPos = y;
#ifdef XbW_SYSDEF_TC3_VERSION
  /*
  Nun einen CALL an den Maustreiber, der die neue Position setzt.
  */
  XbWVMs_regs.x.ax = 4;
#ifdef ALTER_MAUSTREIBER
  XbWVMs_regs.x.cx = (x/2)+XbWVIDEO_XA;
  XbWVMs_regs.x.dx = (y/2)+XbWVIDEO_YA;
#else
  XbWVMs_regs.x.cx = x+XbWVIDEO_XA;
  XbWVMs_regs.x.dx = y+XbWVIDEO_YA;
#endif
    int86(0x33,&XbWVMs_regs,&XbWVMs_regs);
#endif
#endif

#ifdef XbW_SYSDEF_GNU_VERSION
    MouseWarp(x,y);
#endif
#ifdef XbW_SYSDEF_X11_VERSION
    XWarpPointer(
      XbWVSy_ConTxt.dpy,
      XbWVSy_ConTxt.window,
      XbWVSy_ConTxt.window,
      0,0,
      1000,
      1000,
      x,y);
#endif
 
  }
/*}}}  */
/*{{{  XbWSMs_ResPos(      TC3,GNU        Mausposition rucksetzen*/
void  XbWSMs_ResPos(void){
  int x,y;
  x = XbWVMs_XPos; y = XbWVMs_YPos;
  XbWVMs_CX = x; XbWVMs_CY = y;
  /*
  Nun einen CALL an den Maustreiber, der die neue Position setzt.
  */
#ifdef XbW_SYSDEF_TC3_VERSION
  XbWVMs_regs.x.ax = 4;
  XbWVMs_regs.x.cx = x+XbWVIDEO_XA;
  XbWVMs_regs.x.dx = y+XbWVIDEO_YA;
  int86(0x33,&XbWVMs_regs,&XbWVMs_regs);
#endif

#ifdef XbW_SYSDEF_GNU_VERSION
    MouseWarp(x,y);
#endif
  }
/*}}}  */
/*{{{  XbWSMs_Stat(        TC3,GNU        Tasten und Position holen*/
void  XbWSMs_Stat(void){
#ifdef XbW_SYSDEF_TC3_VERSION
  /* Die Mausposition abfragen. */
  XbWVMs_regs.x.ax = 3;
  int86(0x33,&XbWVMs_regs,&XbWVMs_regs);
#ifdef ALTER_MAUSTREIBER
  XbWVMs_XPos = XbWVMs_regs.x.cx*2 -XbWVIDEO_XA;
  XbWVMs_YPos = XbWVMs_regs.x.dx*2 -XbWVIDEO_YA;
#else
  XbWVMs_XPos = XbWVMs_regs.x.cx-XbWVIDEO_XA;
  XbWVMs_YPos = XbWVMs_regs.x.dx-XbWVIDEO_YA;
#endif

  /* Jetzt wird nachgesehen, welche Taste grdr"uckt ist. */
  if ((XbWVMs_regs.x.bx & 1) == 1)   {XbWVMs_LButt = 1;}
    else {XbWVMs_LButt = 0;}
  if ((XbWVMs_regs.x.bx & 2) == 2)   {XbWVMs_RButt = 1;}
    else {XbWVMs_RButt = 0;}
  if ((XbWVMs_regs.x.bx & 4) == 4)   {XbWVMs_MButt = 1;}
    else {XbWVMs_MButt = 0;}
#endif

#ifdef XbW_SYSDEF_GNU_VERSION
  GrCursor *tcur;
  MouseEvent mev;
  tcur = MouseGetCursor();
  XbWVMs_XPos = tcur->cr_xcord;
  XbWVMs_YPos = tcur->cr_ycord;
  MouseGetEvent(M_BUTTON_DOWN|M_POLL|M_NOPAINT, &mev);
  XbWVMs_LButt = XbWVMs_RButt = XbWVMs_MButt = 0;
  if (mev.flags & M_BUTTON_DOWN){
    if ((mev.flags)&M_LEFT_DOWN){ XbWVMs_LButt = 1; };
    if ((mev.flags)&M_RIGHT_DOWN){ XbWVMs_RButt = 1; };
    if ((mev.flags)&M_MIDDLE_DOWN){ XbWVMs_MButt = 1; };
    };
#endif

  /* XbWVMs_Button ist 1, wenn eine Maustaste gedr"uckt wurde. */
  XbWVMs_Button = XbWVMs_LButt | XbWVMs_MButt | XbWVMs_RButt;
  };

/*}}}  */
/*{{{  XbWSMs_ChkMot(      TC3,GNU        Prufe, ob Maus bewegt wurde*/
void  XbWSMs_ChkMot(void){
  if ((XbWVMs_cxa != XbWVMs_XPos) |
    (XbWVMs_cya != XbWVMs_YPos) ){
    XbWVMs_Bewegt = 1;
    XbWVMs_cxa = XbWVMs_XPos;
    XbWVMs_cya = XbWVMs_YPos;
    return;
    };
  XbWVMs_Bewegt = 0;
  };
/*}}}  */
/*}}}  */
/*{{{  XbWSMs_WButtXX(     TC3,GNU,X11    Maustreiber Buttons/Keyboard*/
/*{{{  XbWSMs_WButtUp(*/
void  XbWSMs_WButtUp(void){
  while (XbWVMs_Button == 1) {
#ifdef XbW_SYSDEF_TC3_VERSION
    XbWVMs_regs.x.ax = 3;  /*get position */
    int86(0x33,&XbWVMs_regs,&XbWVMs_regs);
    /* Wir "ubergeben auch gleich den Zustand der Tasten. */
    if ((XbWVMs_regs.x.bx & 1) == 1)   {XbWVMs_LButt = 1;}
      else {XbWVMs_LButt = 0;}
    if ((XbWVMs_regs.x.bx & 2) == 2)   {XbWVMs_RButt = 1;}
      else {XbWVMs_RButt = 0;}
    if ((XbWVMs_regs.x.bx & 4) == 4)   {XbWVMs_MButt = 1;}
      else {XbWVMs_MButt = 0;}
#endif
#ifdef XbW_SYSDEF_GNU_VERSION
    GrCursor *tcur;
    MouseEvent mev;
    tcur = MouseGetCursor();
    XbWVMs_XPos = tcur->cr_xcord;
    XbWVMs_YPos = tcur->cr_ycord;
    MouseGetEvent(M_BUTTON_UP, &mev);
    XbWVMs_LButt = XbWVMs_RButt = XbWVMs_MButt = 0;
    if (mev.flags & M_BUTTON_DOWN){
      if ((mev.flags)&M_LEFT_DOWN){ XbWVMs_LButt = 1; };
      if ((mev.flags)&M_RIGHT_DOWN){ XbWVMs_RButt = 1; };
      if ((mev.flags)&M_MIDDLE_DOWN){ XbWVMs_MButt = 1; };
      };
#endif
#ifdef XbW_SYSDEF_X11_VERSION
    while (!XbWVMs_Button) {
      Window root,child;
      int x_r,y_r, w_x,w_y;
      unsigned int mask;
      XQueryPointer(
        XbWVSy_ConTxt.dpy,
        XbWVSy_ConTxt.window,
        &root,&child,
        &x_r,&y_r,&w_x,&w_y,&mask);
      XbWVMs_LButt = ((mask & Button1Mask) != 0);
      XbWVMs_MButt = ((mask & Button2Mask) != 0);
      XbWVMs_RButt = ((mask & Button3Mask) != 0);
      XbWVMs_Button = XbWVMs_LButt | XbWVMs_MButt | XbWVMs_RButt;
      };
    while (XbWVMs_Button) {
      Window root,child;
      int x_r,y_r, w_x,w_y;
      unsigned int mask;
      XQueryPointer(
        XbWVSy_ConTxt.dpy,
        XbWVSy_ConTxt.window,
        &root,&child,
        &x_r,&y_r,&w_x,&w_y,&mask);
      XbWVMs_LButt = ((mask & Button1Mask) != 0);
      XbWVMs_MButt = ((mask & Button2Mask) != 0);
      XbWVMs_RButt = ((mask & Button3Mask) != 0);
      XbWVMs_Button = XbWVMs_LButt | XbWVMs_MButt | XbWVMs_RButt;
      };
#endif
    XbWVMs_Button = XbWVMs_LButt | XbWVMs_MButt | XbWVMs_RButt;
    }
  }
/*}}}  */
/*{{{  XbWSMs_WButtDn(     TC3,GNU,X11    Warte auf Maustaste drucken*/
void  XbWSMs_WButtDn(void){
  while (XbWVMs_Button == 0) {
#ifdef XbW_SYSDEF_TC3_VERSION
    XbWVMs_regs.x.ax = 3;  /*get position */
    int86(0x33,&XbWVMs_regs,&XbWVMs_regs);
    /* Wir "ubergeben auch gleich den Zustand der Tasten. */
    if ((XbWVMs_regs.x.bx & 1) == 1)   {XbWVMs_LButt = 1;}
      else {XbWVMs_LButt = 0;}
    if ((XbWVMs_regs.x.bx & 2) == 2)   {XbWVMs_RButt = 1;}
      else {XbWVMs_RButt = 0;}
    if ((XbWVMs_regs.x.bx & 4) == 4)   {XbWVMs_MButt = 1;}
      else {XbWVMs_MButt = 0;}
#endif
#ifdef XbW_SYSDEF_GNU_VERSION
    GrCursor *tcur;
    MouseEvent mev;
    tcur = MouseGetCursor();
    XbWVMs_XPos = tcur->cr_xcord;
    XbWVMs_YPos = tcur->cr_ycord;
    XbWVMs_LButt = XbWVMs_RButt = XbWVMs_MButt = 0;
    MouseGetEvent(M_BUTTON_DOWN, &mev);
    if ((mev.flags)&M_LEFT_DOWN){ XbWVMs_LButt = 1; };
    if ((mev.flags)&M_RIGHT_DOWN){ XbWVMs_RButt = 1; };
    if ((mev.flags)&M_MIDDLE_DOWN){ XbWVMs_MButt = 1; };
#endif
#ifdef XbW_SYSDEF_X11_VERSION
    while (XbWVMs_Button) {
      Window root,child;
      int x_r,y_r, w_x,w_y;
      unsigned int mask;
      XQueryPointer(
        XbWVSy_ConTxt.dpy,
        XbWVSy_ConTxt.window,
        &root,&child,
        &x_r,&y_r,&w_x,&w_y,&mask);
      XbWVMs_LButt = ((mask & Button1Mask) != 0);
      XbWVMs_MButt = ((mask & Button2Mask) != 0);
      XbWVMs_RButt = ((mask & Button3Mask) != 0);
      XbWVMs_Button = XbWVMs_LButt | XbWVMs_MButt | XbWVMs_RButt;
      };
    while (!XbWVMs_Button) {
      Window root,child;
      int x_r,y_r, w_x,w_y;
      unsigned int mask;
      XQueryPointer(
        XbWVSy_ConTxt.dpy,
        XbWVSy_ConTxt.window,
        &root,&child,
        &x_r,&y_r,&w_x,&w_y,&mask);
      XbWVMs_LButt = ((mask & Button1Mask) != 0);
      XbWVMs_MButt = ((mask & Button2Mask) != 0);
      XbWVMs_RButt = ((mask & Button3Mask) != 0);
      XbWVMs_Button = XbWVMs_LButt | XbWVMs_MButt | XbWVMs_RButt;
      };
#endif
    XbWVMs_Button = XbWVMs_LButt | XbWVMs_MButt | XbWVMs_RButt;
    };
  XbWSMs_WButtUp();
  };
/*}}}  */
/*{{{  XbWSMs_WButtUpDn(void){*/
void XbWSMs_WButtUpDn(void){
  XbWSMs_WButtUp();
  XbWSMs_WButtDn();
  };
/*}}}  */
/*{{{  XbWSMs_ConvKey(           LINUX    Funktionstasten "ubersetzen*/
char XbWSMs_ConvKey(void){
  printf("Keysym: %x\n",XbWVSy_ConTxt.keysym);
  switch(XbWVSy_ConTxt.keysym){
    case 0xFFBE: return(59); /* F1 */
    case 0xFFBF: return(60); /* F2 */
    case 0xFFC0: return(61); /* F3 */
    case 0xFFC1: return(62); /* F4 */
    case 0xFFC2: return(63); /* F5 */
    case 0xFFC3: return(64); /* F6 */
    case 0xFFC4: return(65); /* F7 */
    case 0xFFC5: return(66); /* F8 */
    case 0xFFC6: return(67); /* F9 */
    case 0xFFC7: return(68); /* F10*/
    case 0xFFC8: return(69); /* F11*/
    case 0xFFC9: return(70); /* F12*/
    case 0xFF63: return(82);   /* insert */
    case 0xFF55: return(73);   /* pgup */
    case 0xFF56: return(81);   /* pgdn */
    case 0xFF51: return(75);   /* cursor left */
    case 0xFF53: return(77);   /*        right */
    case 0xFF52: return(72);   /*        up */
    case 0xFF54: return(80);   /*        down*/
    case 0xFF50: return(71);   /* home */
    case 0xFF57: return(79);   /* end */
    default: return(0);
    };
  };


/*}}}  */
/*{{{  XbWSMs_GetKey(      TC3,GNU,X11    Aktuelle Taste holen*/
void  XbWSMs_GetKey(unsigned char  *c1, unsigned char  *c2){
#ifdef XbW_SYSDEF_TC3_VERSION
  char ch;
  ch = getch();
  if (ch != 0) {
    *c2 = ch;
    *c1 = 0;
    }
  else {
    *c1 = getch();
    *c2 = 0;
    };
  return;
#endif
#ifdef XbW_SYSDEF_GNU_VERSION
  if (!XbWVSy_ConTxt.is_a_key_waiting){
    MouseGetEvent(M_KEYPRESS, &XbWVSy_ConTxt.kbd_mev);
    };
  XbWVSy_ConTxt.is_a_key_waiting=0;
  *c1 = 0;
  /* (unsigned char)(XbWVSy_ConTxt.kbd_mev.kbstat & 0xFF);*/
  *c2 = (unsigned char)(XbWVSy_ConTxt.kbd_mev.key & 0xFF);
  if (XbWVSy_ConTxt.kbd_mev.key  & 0x100){
    *c2=0;
    *c1 = (unsigned char)(XbWVSy_ConTxt.kbd_mev.key & 0xFF);
    if (XbWVSy_ConTxt.kbd_mev.kbstat & 8){
      *c2 += 45;
      };
    if (XbWVSy_ConTxt.kbd_mev.kbstat & 4){
      *c2 += 35;
      };
    if (XbWVSy_ConTxt.kbd_mev.kbstat & 2){
      *c2 += 25;
      };
    if (XbWVSy_ConTxt.kbd_mev.kbstat & 1){
      *c2 += 25;
      };
    };
#endif
#ifdef XbW_SYSDEF_X11_VERSION
  if (XbWVSy_ConTxt.is_a_key_waiting){
    *c1 = 0;
    *c2 = XbWVSy_ConTxt.key[0];
    if (!*c2){
      *c1 = XbWSMs_ConvKey();
      };
    XbWVSy_ConTxt.is_a_key_waiting=0;
    return;
    };
  while(1){
    XEvent event;
    KeySym keysym;
    int n;
    char string[257];
    XKeyEvent *keyevent;
    XNextEvent(XbWVSy_ConTxt.dpy,&event);
    switch (event.type){
      case KeyPress:
        keyevent = (XKeyEvent *)&event;
        string[0] = 0;
        n = XLookupString(keyevent, string, 256, &keysym, NULL);
        *c1 = 0;
        *c2 = string[0];
        if (!*c2){
          *c1 = XbWSMs_ConvKey();
          };
        return;
      };
    };
#endif
  };
/*}}}  */
/*{{{  XbWSMs_IsAKey(      TC3,GNU,X11    Ist Taste gedrckt (Keyboard)*/
boolean  XbWSMs_IsAKey(int wait){
#ifdef XbW_SYSDEF_TC3_VERSION
  /* Die Mausposition abfragen. */
  XbWVMs_regs.x.ax = 3;
  int86(0x33,&XbWVMs_regs,&XbWVMs_regs);
#ifdef ALTER_MAUSTREIBER
  XbWVMs_XPos = XbWVMs_regs.x.cx*2 -XbWVIDEO_XA;
  XbWVMs_YPos = XbWVMs_regs.x.dx*2 -XbWVIDEO_YA;
#else
  XbWVMs_XPos = XbWVMs_regs.x.cx-XbWVIDEO_XA;
  XbWVMs_YPos = XbWVMs_regs.x.dx-XbWVIDEO_YA;
#endif

  /* Jetzt wird nachgesehen, welche Taste grdr"uckt ist. */
  if ((XbWVMs_regs.x.bx & 1) == 1)   {XbWVMs_LButt = 1;}
    else {XbWVMs_LButt = 0;}
  if ((XbWVMs_regs.x.bx & 2) == 2)   {XbWVMs_RButt = 1;}
    else {XbWVMs_RButt = 0;}
  if ((XbWVMs_regs.x.bx & 4) == 4)   {XbWVMs_MButt = 1;}
    else {XbWVMs_MButt = 0;}
  /* XbWVMs_Button ist 1, wenn eine Maustaste gedr"uckt wurde. */
  XbWVMs_Button = XbWVMs_LButt | XbWVMs_MButt | XbWVMs_RButt;
  XbWSMs_ChkMot();
  if (wait){
    while(!kbhit()){};
    };
  return(kbhit());
#endif
#ifdef XbW_SYSDEF_GNU_VERSION
  if (XbWVSy_ConTxt.is_a_key_waiting){
    return(1);
    };
  XbWSMs_ChkMot();
  {
    GrCursor *tcur;
    MouseEvent mev;
    tcur = MouseGetCursor();
    XbWVMs_XPos = tcur->cr_xcord;
    XbWVMs_YPos = tcur->cr_ycord;
    };
  if (wait){
    MouseGetEvent(M_BUTTON_DOWN|M_KEYPRESS, &XbWVSy_ConTxt.kbd_mev);
    }
  else {
    MouseGetEvent(M_BUTTON_DOWN|M_KEYPRESS|M_NOPAINT|M_POLL, &XbWVSy_ConTxt.kbd_mev);
    };
  XbWVMs_LButt = XbWVMs_RButt = XbWVMs_MButt = 0;
  if (XbWVSy_ConTxt.kbd_mev.flags & M_BUTTON_DOWN){
    if ((XbWVSy_ConTxt.kbd_mev.flags)&M_LEFT_DOWN){ XbWVMs_LButt = 1; };
    if ((XbWVSy_ConTxt.kbd_mev.flags)&M_RIGHT_DOWN){ XbWVMs_RButt = 1; };
    if ((XbWVSy_ConTxt.kbd_mev.flags)&M_MIDDLE_DOWN){ XbWVMs_MButt = 1; };
    };
  XbWVMs_Button = XbWVMs_LButt | XbWVMs_MButt | XbWVMs_RButt;
  XbWVSy_ConTxt.is_a_key_waiting = (XbWVSy_ConTxt.kbd_mev.flags & M_KEYPRESS);
  return(XbWVSy_ConTxt.is_a_key_waiting);
#endif
#ifdef XbW_SYSDEF_X11_VERSION
  if (XbWVSy_ConTxt.is_a_key_waiting){
    return(1);
    };
  {
    XEvent event;
    KeySym keysym;
    int n;
    char string[257];
    XKeyEvent *keyevent;
    while (wait){
      XNextEvent(XbWVSy_ConTxt.dpy,&event);
      switch (event.type){
        case KeyPress:
          keyevent = (XKeyEvent *)&event;
          string[0]=0;
          n = XLookupString(keyevent, string, 256, &keysym, NULL);
          XbWVSy_ConTxt.keysym = keysym;
          strncpy(XbWVSy_ConTxt.key,string,255);
          XbWVSy_ConTxt.key[255] = 0;
          XbWVSy_ConTxt.is_a_key_waiting =1;
          return(1);
        };
      };
    if (XCheckMaskEvent(XbWVSy_ConTxt.dpy,KeyPressMask,&event)){
      switch (event.type){
        case KeyPress:
          keyevent = (XKeyEvent *)&event;
          string[0]=0;
          n = XLookupString(keyevent, string, 256, &keysym, NULL);
          strncpy(XbWVSy_ConTxt.key,string,255);
          XbWVSy_ConTxt.keysym = keysym;
          XbWVSy_ConTxt.key[255] = 0;
          XbWVSy_ConTxt.is_a_key_waiting =1;
          return(1);
        };
      };
    return(0);
    };
#endif
  };
/*}}}  */
/*{{{  XbWSMs_ButUp(       TC3,GNU,X11    Ist Taste gedrueckt (Maus)*/
boolean  XbWSMs_ButUp(int wait){
#ifdef XbW_SYSDEF_TC3_VERSION
  /* Die Mausposition abfragen. */
  XbWVMs_regs.x.ax = 3;
  int86(0x33,&XbWVMs_regs,&XbWVMs_regs);
#ifdef ALTER_MAUSTREIBER
  XbWVMs_XPos = XbWVMs_regs.x.cx*2 -XbWVIDEO_XA;
  XbWVMs_YPos = XbWVMs_regs.x.dx*2 -XbWVIDEO_YA;
#else
  XbWVMs_XPos = XbWVMs_regs.x.cx-XbWVIDEO_XA;
  XbWVMs_YPos = XbWVMs_regs.x.dx-XbWVIDEO_YA;
#endif

  /* Jetzt wird nachgesehen, welche Taste grdr"uckt ist. */
  if ((XbWVMs_regs.x.bx & 1) == 1)   {XbWVMs_LButt = 1;}
    else {XbWVMs_LButt = 0;}
  if ((XbWVMs_regs.x.bx & 2) == 2)   {XbWVMs_RButt = 1;}
    else {XbWVMs_RButt = 0;}
  if ((XbWVMs_regs.x.bx & 4) == 4)   {XbWVMs_MButt = 1;}
    else {XbWVMs_MButt = 0;}
  /* XbWVMs_Button ist 1, wenn eine Maustaste gedr"uckt wurde. */
  XbWVMs_Button = XbWVMs_LButt | XbWVMs_MButt | XbWVMs_RButt;
  XbWSMs_ChkMot();
  return(XbWVMs_Button);
#endif
#ifdef XbW_SYSDEF_GNU_VERSION
  XbWSMs_ChkMot();
  {
    GrCursor *tcur;
    MouseEvent mev;
    tcur = MouseGetCursor();
    XbWVMs_XPos = tcur->cr_xcord;
    XbWVMs_YPos = tcur->cr_ycord;
    };
  if (wait){
    MouseGetEvent(M_BUTTON_UP, &XbWVSy_ConTxt.kbd_mev);
    }
  else {
    MouseGetEvent(M_BUTTON_UP|M_NOPAINT|M_POLL, &XbWVSy_ConTxt.kbd_mev);
    };
  XbWVMs_LButt = XbWVMs_RButt = XbWVMs_MButt = 1;
  if (XbWVSy_ConTxt.kbd_mev.flags & M_BUTTON_UP){
    if ((XbWVSy_ConTxt.kbd_mev.flags)&M_LEFT_UP){ XbWVMs_LButt = 0; };
    if ((XbWVSy_ConTxt.kbd_mev.flags)&M_RIGHT_UP){ XbWVMs_RButt = 0; };
    if ((XbWVSy_ConTxt.kbd_mev.flags)&M_MIDDLE_UP){ XbWVMs_MButt = 0; };
    };
  XbWVMs_Button = XbWVMs_LButt | XbWVMs_MButt | XbWVMs_RButt;
  return(XbWVMs_Button);
#endif
#ifdef XbW_SYSDEF_X11_VERSION
  {
    Window root, child;
    int xr, yr, xp, yp;
    unsigned int mask;
 
    XbWVMs_Button = 0;
    while(!XbWVMs_Button){
      XQueryPointer(
          XbWVSy_ConTxt.dpy,
          XbWVSy_ConTxt.window,
          &root, &child,
          &xr, &yr, &xp, &yp, &mask);
      XbWVMs_LButt = ((mask & Button1Mask) != 0);
      XbWVMs_MButt = ((mask & Button2Mask) != 0);
      XbWVMs_RButt = ((mask & Button3Mask) != 0);
      XbWVMs_Button = XbWVMs_LButt | XbWVMs_MButt | XbWVMs_RButt;
      XbWVMs_XPos=xp;
      XbWVMs_YPos=yp;
      if (!wait){
        return(XbWVMs_Button);
        };
      };
    return(XbWVMs_Button);
    };
#endif
  };
/*}}}  */
/*{{{  XbWSMs_WaitKey(     TC3,GNU,X11    Warte auf Taste (kbd)*/
void  XbWSMs_WaitKey(void){
#ifdef XbW_SYSDEF_TC3_VERSION
  while (!kbhit()){};
  return;
#endif
#ifdef XbW_SYSDEF_GNU_VERSION
  MouseGetEvent(M_KEYPRESS, &XbWVSy_ConTxt.kbd_mev);
  XbWVSy_ConTxt.is_a_key_waiting = (XbWVSy_ConTxt.kbd_mev.flags & M_KEYPRESS);
  return;
#endif
#ifdef XbW_SYSDEF_X11_VERSION
  XbWSMs_IsAKey(1);
#endif
  };
/*}}}  */
/*}}}  */
/*{{{  XbWSMs_DFramXX(     TC3,g//,x??    Rahmen zum Fenster modifizieren zeichnen*/
/*{{{  XbWSMs_DFramON(     TC3,g//,x??    Rahmen zum Fenster modifizieren zeichnen*/

static void *XbWSMs_DFramONFrames[4]={NULL,NULL,NULL,NULL};
void  XbWSMs_DFramON(int xa,int ya,int xb,int yb,int col){
#ifdef XbW_SYSDEF_TC3_VERSION
  int ll;
  if ((xa == xb) | (ya == yb))   { }
  else {
    if (xa > xb)   {ll = xa;xa = xb;xb = ll;};
    if (ya > yb)   {ll = ya;ya = yb;yb = ll;};
    ll = xa;
    while (ll < xb) {
      putpixel(ll,ya,getpixel(ll,ya)+XbWDMs_Pix);
      putpixel(ll,yb,getpixel(ll,yb)+XbWDMs_Pix);  ll = ll + 5;};
    ll = ya;
    while (ll < yb) {
      putpixel(xa,ll,getpixel(xa,ll)+XbWDMs_Pix);
      putpixel(xb,ll,getpixel(xb,ll)+XbWDMs_Pix);  ll = ll + 5;};
    XbWVMs_CX = xb + 2;   XbWVMs_CY = yb + 2;
    };
#endif
#ifdef XbW_SYSDEF_X11_VERSION
  XbWSMs_DFramONFrames[0] = XbWSGr_SavImag(xa,ya,xb,ya);
  XbWSMs_DFramONFrames[1] = XbWSGr_SavImag(xa,ya,xa,yb);
  XbWSMs_DFramONFrames[2] = XbWSGr_SavImag(xa,yb,xb,yb);
  XbWSMs_DFramONFrames[3] = XbWSGr_SavImag(xb,ya,xb,yb);
  XbWSGr_Line(xa,ya,xb,ya,col);
  XbWSGr_Line(xa,ya,xa,yb,col);
  XbWSGr_Line(xa,yb,xb,yb,col);
  XbWSGr_Line(xb,ya,xb,yb,col);
#endif
  };
/*}}}  */
/*{{{  XbWSMs_FramON(      TC3,g//,x??*/
void   XbWSMs_FramON(int xxa,int yya,int xxb,int yyb, int col){
#ifdef XbW_SYSDEF_TC3_VERSION
  int ll,xa,ya,xb,yb;
  xa = xxa;ya = yya;xb = xxb;yb = yyb;
  XbWFGr_MaxPort();
  if ((xa == xb) | (ya == yb)) { }
  else { if (xa > xb)   {ll = xa;xa = xb;xb = ll;};
    if (ya > yb)   {ll = ya;ya = yb;yb = ll;};
    ll = xa;
    while (ll < xb) {
      putpixel(ll,ya, getpixel(ll,ya)+XbWDMs_Pix);
      putpixel(ll,yb, getpixel(ll,yb)+XbWDMs_Pix);  ll = ll + 5;};
    ll = ya;
    while (ll < yb) {
      putpixel(xa,ll, getpixel(xa,ll)+XbWDMs_Pix);
      putpixel(xb,ll, getpixel(xb,ll)+XbWDMs_Pix);  ll = ll + 5;};
    };
  XbWVMs_CX = xb + 2;  XbWVMs_CY = yb + 2;
  XbWSMs_ON();
  XbWFGr_ResPort();
#endif
#ifdef XbW_SYSDEF_X11_VERSION
  XbWSMs_DFramONFrames[0] = XbWSGr_SavImag(xxa,yya,xxb,yya);
  if (XbWSMs_DFramONFrames[0]==NULL){ puts("ERR: cannot alloc graphic mem!"); };
  XbWSMs_DFramONFrames[1] = XbWSGr_SavImag(xxa,yya,xxa,yyb);
  if (XbWSMs_DFramONFrames[1]==NULL){ puts("ERR: cannot alloc graphic mem!"); };
  XbWSMs_DFramONFrames[2] = XbWSGr_SavImag(xxa,yyb,xxb,yyb);
  if (XbWSMs_DFramONFrames[2]==NULL){ puts("ERR: cannot alloc graphic mem!"); };
  XbWSMs_DFramONFrames[3] = XbWSGr_SavImag(xxb,yya,xxb,yyb);
  if (XbWSMs_DFramONFrames[3]==NULL){ puts("ERR: cannot alloc graphic mem!"); };
  XbWSGr_Line(xxa,yya,xxb,yya,col);
  XbWSGr_Line(xxa,yya,xxa,yyb,col);
  XbWSGr_Line(xxa,yyb,xxb,yyb,col);
  XbWSGr_Line(xxb,yya,xxb,yyb,col);
#endif
  };
/*}}}  */
/*{{{  XbWSMs_FramOFF(     TC3,g//,x??*/
void   XbWSMs_FramOFF(int xa,int ya,int xb,int yb){
#ifdef XbW_SYSDEF_TC3_VERSION
  int ll;
  if ((xa == xb) | (ya == yb))   { }
  else {
    if (xa > xb)   {ll = xa;xa = xb;xb = ll;};
    if (ya > yb)   {ll = ya;ya = yb;yb = ll;};
    ll = xa;
    while (ll < xb) {
      putpixel(ll,ya,getpixel(ll,ya)-XbWDMs_Pix);
      putpixel(ll,yb,getpixel(ll,yb)-XbWDMs_Pix);  ll = ll + 5;};
    ll = ya;
    while (ll < yb) {
      putpixel(xa,ll,getpixel(xa,ll)-XbWDMs_Pix);
      putpixel(xb,ll,getpixel(xb,ll)-XbWDMs_Pix);  ll = ll + 5;};
    XbWVMs_CX = xb + 2;  XbWVMs_CY = yb + 2;
    };
#endif
#ifdef XbW_SYSDEF_X11_VERSION
  XbWSGr_ResImag(XbWSMs_DFramONFrames[3],xb, ya, xb, yb,XbWDGr_Write);
  XbWSGr_ResImag(XbWSMs_DFramONFrames[2],xa, yb, xb, yb,XbWDGr_Write);
  XbWSGr_ResImag(XbWSMs_DFramONFrames[1],xa, ya, xa, yb,XbWDGr_Write);
  XbWSGr_ResImag(XbWSMs_DFramONFrames[0],xa, ya, xb, ya,XbWDGr_Write);
#endif
  };
/*}}}  */
/*{{{  XbWSMs_DFramOFF(    TC3,g//,x??*/
void   XbWSMs_DFramOFF(int xxa,int yya,int xxb,int yyb){
#ifdef XbW_SYSDEF_TC3_VERSION
  int ll,xa,ya,xb,yb;
  xa = xxa;ya = yya;xb = xxb;yb = yyb;
  XbWFGr_MaxPort();
  XbWSMs_OFF();
  if ((xa == xb) | (ya == yb))   { }
  else { if (xa > xb)   { ll = xa; xa = xb; xb = ll; };
    if (ya > yb)   { ll = ya;ya = yb; yb = ll; };
    ll = xa;
    while (ll < xb) {
      putpixel(ll,ya,getpixel(ll,ya)-XbWDMs_Pix);
      putpixel(ll,yb,getpixel(ll,yb)-XbWDMs_Pix);  ll = ll + 5;};
    ll = ya;
    while (ll < yb) {
      putpixel(xa,ll,getpixel(xa,ll)-XbWDMs_Pix);
      putpixel(xb,ll,getpixel(xb,ll)-XbWDMs_Pix);  ll = ll + 5;};
    };
  XbWFGr_ResPort();
#endif
#ifdef XbW_SYSDEF_X11_VERSION
  XbWSGr_ResImag(XbWSMs_DFramONFrames[0],xxa, yya, xxb, yya,XbWDGr_Write);
  XbWSGr_ResImag(XbWSMs_DFramONFrames[1],xxa, yya, xxa, yyb,XbWDGr_Write);
  XbWSGr_ResImag(XbWSMs_DFramONFrames[2],xxa, yyb, xxb, yyb,XbWDGr_Write);
  XbWSGr_ResImag(XbWSMs_DFramONFrames[3],xxb, yya, xxb, yyb,XbWDGr_Write);
#endif
  };
/*}}}  */
/*}}}  */
/*{{{  XbWSGr_BitXXXX(     t--,GNU,x//    Bit-Blitter fur Grafik*/
/*{{{  XbWSGr_BitBlit(     t--,GNU,x//    Bit-Blitter fur Grafik*/
void  XbWSGr_BitBlit(void  *dest, int x, int y,
               void  *source, int x1, int y1, int x2, int y2,
               int oper){
#ifdef XbW_SYSDEF_GNU_VERSION
  GrBitBlt((GrContext *)dest,x,y,(GrContext *)source,x1,y1,x2,y2,oper);
#endif
#ifdef XbW_SYSDEF_X11_VERSION
  XCopyArea(
    XbWVSy_ConTxt.dpy,
    XbWVSy_ConTxt.window,
    XbWVSy_ConTxt.window,
    XbWVSy_ConTxt.gc,
    x1,y1,
    x2-x1,y2-y1,
    x,y);
#endif
  };
/*}}}  */
/*{{{  XbWSGr_SavImag(     TC3,GNU,x//    Blit Image in Memory-Context*/
void  *XbWSGr_SavImag(int x1, int y1, int x2, int y2){
#ifdef XbW_SYSDEF_TC3_VERSION
  void far *scrinh;
  if (imagesize(x1,y1,x2+1,y2+1) == (unsigned)(0xFFFF-1)){
    return(NULL);
    };
  if((scrinh = farcalloc(1,imagesize(x1,y1,x2+1,y2+1))) == NULL){
    return(scrinh);
    };
  getimage(x1,y1,x2,y2,scrinh);
  return(scrinh);
#endif
#ifdef XbW_SYSDEF_GNU_VERSION
  GrContext *tc;
  tc = GrCreateContext(x2-x1+2,y2-y1+2,NULL,NULL);
  if (tc==NULL){ return(tc);};
  GrBitBlt(tc,0,0,NULL,x1,y1,x2+1,y2+1,GrWRITE);
  return(tc);
#endif
#ifdef XbW_SYSDEF_X11_VERSION
  Pixmap *pmap;
  pmap = XbWSSy_AlocMem(sizeof(Pixmap),1);
  if (pmap==NULL){ return(NULL); };
 
  *pmap = XCreatePixmap(XbWVSy_ConTxt.dpy,XbWVSy_ConTxt.window,x2-x1+2,y2-y1+2,
      XDefaultDepthOfScreen(XbWVSy_ConTxt.screen));
  if (*pmap<=0){ return(NULL);};
 
  XCopyArea(XbWVSy_ConTxt.dpy,
    XbWVSy_ConTxt.window, /* src */
    *pmap,                /* target */
    XbWVSy_ConTxt.gc,
    x1,y1,
    x2-x1+1,y2-y1+1,
    1,1);
  return(pmap);
#endif
  return(NULL);
  };
/*}}}  */
/*{{{  XbWSGr_ResImag(     TC3,GNU,x//    Blit Image aus Memory-Context*/
void  XbWSGr_ResImag(void  *where,int x1, int y1,
  int x2, int y2,
  int oper){
/*{{{  */
#ifdef XbW_SYSDEF_TC3_VERSION
  switch(oper){
    case XbWDGr_Write: oper = COPY_PUT; break;
    case XbWDGr_XOR:   oper = XOR_PUT; break;
    case XbWDGr_OR:    oper = OR_PUT; break;
    case XbWDGr_AND:   oper = AND_PUT; break;
    };
  putimage(x1,y1,where,oper);
  farfree(where);
#endif
#ifdef XbW_SYSDEF_GNU_VERSION
  switch(oper){
    case XbWDGr_Write: oper = GrWRITE; break;
    case XbWDGr_XOR:   oper = GrXOR; break;
    case XbWDGr_OR:    oper = GrOR; break;
    case XbWDGr_AND:   oper = GrAND; break;
    };
  GrBitBlt(NULL,x1,y1,(GrContext *)where,0,0,x2-x1+1,y2-y1+1,oper);
  GrDestroyContext(where);
#endif
/*}}}  */
#ifdef XbW_SYSDEF_X11_VERSION
  Pixmap *pmap;
  pmap = where;
  if (pmap==NULL){ return; };
 
  XCopyArea(XbWVSy_ConTxt.dpy,
    *pmap,                /* src */
    XbWVSy_ConTxt.window, /* dest */
    XbWVSy_ConTxt.gc,
    1,1,
    x2-x1+1,y2-y1+1,
    x1,y1);
  XFreePixmap(XbWVSy_ConTxt.dpy,*pmap);
  XbWSSy_FreeMem(pmap);
#endif
  };
/*}}}  */
/*{{{  XbWSGr_DelImag(     TC3,GNU,x//    Memory-Context loeschen*/
void  XbWSGr_DelImag(void  *where){
#ifdef XbW_SYSDEF_TC3_VERSION
  farfree(where);
#endif
#ifdef XbW_SYSDEF_GNU_VERSION
  GrDestroyContext(where);
#endif
#ifdef XbW_SYSDEF_X11_VERSION
  Pixmap *pmap;
  pmap = where;
  if (pmap==NULL){ return; };
 
  XFreePixmap(XbWVSy_ConTxt.dpy,*pmap);
  XbWSSy_FreeMem(pmap);
#endif
  };
/*}}}  */
/*{{{  XbWSGr_CopImag(     TC3,GNU,x//    Blit Image aus Memory-Context*/
void  XbWSGr_CopImag(void  *where,int x1, int y1,
  int x2, int y2,
  int oper){
#ifdef XbW_SYSDEF_TC3_VERSION
  switch(oper){
    case XbWDGr_Write: oper = COPY_PUT; break;
    case XbWDGr_XOR:   oper = XOR_PUT; break;
    case XbWDGr_OR:    oper = OR_PUT; break;
    case XbWDGr_AND:   oper = AND_PUT; break;
    };
  putimage(x1,y1,where,oper);
#endif
#ifdef XbW_SYSDEF_GNU_VERSION
  switch(oper){
    case XbWDGr_Write: oper = GrWRITE; break;
    case XbWDGr_XOR:   oper = GrXOR; break;
    case XbWDGr_OR:    oper = GrOR; break;
    case XbWDGr_AND:   oper = GrAND; break;
    };
  GrBitBlt(NULL,x1,y1,(GrContext *)where,0,0,x2-x1+1,y2-y1+1,oper);
  XCopyArea(XbWVSy_ConTxt.dpy,
    *pmap,                 /* src */
    XbWVSy_ConTxt.window,  /* dest */
    XbWVSy_ConTxt.gc,
    0,0,
    x2-x1+1,y2-y1+1,
    x1,y1);
#endif
  };
/*}}}  */
 
/*{{{  XbWSGr_Line(        TC3,GNU        Linie zeichnen*/
void  XbWSGr_Line(int xa,int ya,int xb,int yb,unsigned char color){
#ifdef XbW_SYSDEF_TC3_VERSION
  setcolor(color); line(xa,ya,xb,yb);
#endif
#ifdef XbW_SYSDEF_GNU_VERSION
  GrLine(xa+XbWVSy_ConTxt.XA,ya+XbWVSy_ConTxt.YA,xb+XbWVSy_ConTxt.XA,yb+XbWVSy_ConTxt.YA,color);
#endif
#ifdef XbW_SYSDEF_X11_VERSION
  XSetForeground(XbWVSy_ConTxt.dpy,
    XbWVSy_ConTxt.gc,
    XbWVGr_ColorValues[color]);
  XSetLineAttributes(
    XbWVSy_ConTxt.dpy,
    XbWVSy_ConTxt.gc,
    1,
    LineSolid,
    CapRound,
    JoinRound);
 
  if (xa < 0){ xa = 0; };
  if (ya < 0){ ya = 0; };
  if (xb < 0){ xb = 0; };
  if (yb < 0){ yb = 0; };
  if (xb < 0 ) { xa = -xb; xb = 0; };
  if (yb < 0 ) { ya = -yb; yb = 0; };
  if ( (xa != xb) || (ya != yb)) {
    XDrawLine(
      XbWVSy_ConTxt.dpy,
      XbWVSy_ConTxt.window,
      XbWVSy_ConTxt.gc,
      xa+XbWVSy_ConTxt.XA,
      ya+XbWVSy_ConTxt.YA,
      xb+XbWVSy_ConTxt.XA,
      yb+XbWVSy_ConTxt.YA);
    };
#endif
  };
/*}}}  */
/*{{{  XbWSGr_HLin(        TC3,GNU        Horizontale Linie (schnell)*/
void  XbWSGr_HLin(int xa,int xb,int ya,unsigned char color){
#ifdef XbW_SYSDEF_TC3_VERSION
  setcolor(color); line(xa,ya,xb,ya);
#endif
#ifdef XbW_SYSDEF_GNU_VERSION
  GrHLine(xa+XbWVSy_ConTxt.XA,xb+XbWVSy_ConTxt.XA,ya+XbWVSy_ConTxt.YA,color);
#endif
#ifdef XbW_SYSDEF_X11_VERSION
  XbWSGr_Line(xa,ya,xb,ya,color);
#endif
  };
/*}}}  */
/*{{{  XbWSGr_VLin(        TC3,GNU        Vertikale Linie (schnell)*/
void  XbWSGr_VLin(int xa,int ya,int yb,unsigned char color){
#ifdef XbW_SYSDEF_TC3_VERSION
  setcolor(color); line(xa,ya,xa,yb);
#endif
#ifdef XbW_SYSDEF_GNU_VERSION
  GrVLine(xa+XbWVSy_ConTxt.XA,ya+XbWVSy_ConTxt.YA,yb+XbWVSy_ConTxt.YA,color);
#endif
#ifdef XbW_SYSDEF_X11_VERSION
  XbWSGr_Line(xa,ya,xa,yb,color);
#endif
  };
/*}}}  */
/*{{{  XbWSGr_Ell(         TC3,!!!        Kreis bzw. Ellipse*/
void  XbWSGr_Ell(int xa,int ya,int stang,int endang,
              int ra,int rb,int farbe){
#ifdef XbW_SYSDEF_TC3_VERSION
  setcolor(farbe);
  ellipse(xa,ya,stang,endang,ra,rb);
#endif
  };
/*}}}  */
/*}}}  */
/*{{{  XbWSGr_TxtXXXX(     t--,GNU,X11    Textstring als Grafik ausg.*/
/*{{{  XbWSGr_TxtDraw(     t--,GNU,X11    Textstring als Grafik ausg.*/
void  XbWSGr_TxtDraw(int x, int y,char *txt,  int tc, int bc){
#ifdef XbW_SYSDEF_GNU_VERSION
  XbWVSy_ConTxt.top.txo_fgcolor.v = (int)tc;
/*  XbWVSy_ConTxt.top.txo_bgcolor.v = (int)bc; */
  XbWVSy_ConTxt.top.txo_bgcolor.v = GrNOCOLOR;
  GrDrawString(txt,strlen(txt),x,y,&XbWVSy_ConTxt.top);
#endif
  };
/*}}}  */
/*{{{  XbWSGr_TLBox(       TC3,GNU,X11    Text-Box, linksbundig, oben*/
void  XbWSGr_TLBox(
  int xa,int ya,
  int xb,int yb,
  char  *msg,
  int fillcol, int textcol, int framecol){
#ifdef XbW_SYSDEF_TC3_VERSION
  if (xb){
    setfillstyle(SOLID_FILL,fillcol);
    bar(xa,ya,xb,yb);
    };
  setcolor(textcol);
  if (msg!=NULL) {
    outtextxy(xa+1,ya+2,(char far *)msg);
    };
  if (xb){
    setcolor(framecol);
    line(xa,ya,xb,ya);
    line(xa,ya,xa,yb);
    line(xb,yb,xb,ya);
    line(xb,yb,xa,yb);
    };
#endif

#ifdef XbW_SYSDEF_GNU_VERSION
  if (xb!=0){

    GrFilledBox(xa+XbWVSy_ConTxt.XA,ya+XbWVSy_ConTxt.YA,xb+XbWVSy_ConTxt.XA,yb+XbWVSy_ConTxt.YA,fillcol);
    };
  if (msg!=NULL) {
    XbWSGr_TxtDraw(xa+1+XbWVSy_ConTxt.XA,ya+2+XbWVSy_ConTxt.YA,msg,textcol,fillcol);
    };
  if (xb!=0){
    GrHLine(xa+XbWVSy_ConTxt.XA,xb+XbWVSy_ConTxt.XA,ya+XbWVSy_ConTxt.YA,framecol);
    GrHLine(xa+XbWVSy_ConTxt.XA,xb+XbWVSy_ConTxt.XA,yb+XbWVSy_ConTxt.YA,framecol);
    GrVLine(xa+XbWVSy_ConTxt.XA,ya+XbWVSy_ConTxt.YA,yb+XbWVSy_ConTxt.YA,framecol);
    GrVLine(xb+XbWVSy_ConTxt.XA,ya+XbWVSy_ConTxt.YA,yb+XbWVSy_ConTxt.YA,framecol);
    };
#endif

#ifdef XbW_SYSDEF_X11_VERSION
  if (xb!=0){
    XSetForeground(XbWVSy_ConTxt.dpy,XbWVSy_ConTxt.gc,
      XbWVGr_ColorValues[fillcol] );
    XFillRectangle(XbWVSy_ConTxt.dpy,XbWVSy_ConTxt.window,
      XbWVSy_ConTxt.gc,
      xa+XbWVSy_ConTxt.XA,
      ya+XbWVSy_ConTxt.YA,xb-xa,yb-ya);
      };
  if (msg!=NULL) {
    XSetForeground(XbWVSy_ConTxt.dpy,XbWVSy_ConTxt.gc,
      XbWVGr_ColorValues[textcol] );
    XDrawString(XbWVSy_ConTxt.dpy, XbWVSy_ConTxt.window,XbWVSy_ConTxt.gc,
      xa+1+XbWVSy_ConTxt.XA,
      ya+XbWFGr_THeight()-2+XbWVSy_ConTxt.YA,
      msg,strlen(msg));
    };
  if (xb!=0){
    XSetForeground(XbWVSy_ConTxt.dpy,XbWVSy_ConTxt.gc,
      XbWVGr_ColorValues[framecol] );
    XDrawRectangle(XbWVSy_ConTxt.dpy,XbWVSy_ConTxt.window,
      XbWVSy_ConTxt.gc,
      xa+XbWVSy_ConTxt.XA,
      ya+XbWVSy_ConTxt.YA,
      xb-xa,yb-ya);
    };
#endif
  };
/*}}}  */
/*{{{  XbWSGr_CCBox(       TC3,GNU,X11    Text-Box, zentriert*/
void  XbWSGr_CCBox(
  int xa,int ya,
  int xb,int yb,
  char  *msg,
  int fillcol, int textcol, int framecol){
#ifdef XbW_SYSDEF_TC3_VERSION
  if (xb){
    setcolor(framecol);
    setfillstyle(SOLID_FILL,fillcol);
    bar(xa,ya,xb,yb);
    };
  setcolor(textcol);
  if (msg!=NULL) {
    outtextxy(
      (xa+xb)/2-(XbWFGr_TWidth((char*)msg)/2),
      (ya+yb)/2-XbWFGr_THeight()/2+2,
      (char far *)msg);
    };
  if (xb){
    setcolor(framecol);
    line(xa,ya,xb,ya);
    line(xa,ya,xa,yb);
    line(xb,yb,xb,ya);
    line(xb,yb,xa,yb);
    };
#endif

#ifdef XbW_SYSDEF_GNU_VERSION
  if (xb){
    GrFilledBox(xa+XbWVSy_ConTxt.XA,ya+XbWVSy_ConTxt.YA,xb+XbWVSy_ConTxt.XA,yb+XbWVSy_ConTxt.YA,fillcol);
    };
  if (msg != NULL) {
    XbWSGr_TxtDraw(
      (xa+XbWVSy_ConTxt.XA+xb+XbWVSy_ConTxt.XA)/2-(XbWFGr_TWidth(msg)/2),
      (ya+XbWVSy_ConTxt.YA+yb+XbWVSy_ConTxt.YA)/2-XbWFGr_THeight()/2+2,
      msg,textcol,fillcol);
    };
  if (xb){
    GrHLine(xa+XbWVSy_ConTxt.XA,xb+XbWVSy_ConTxt.XA,ya+XbWVSy_ConTxt.YA,framecol);
    GrHLine(xa+XbWVSy_ConTxt.XA,xb+XbWVSy_ConTxt.XA,yb+XbWVSy_ConTxt.YA,framecol);
    GrVLine(xa+XbWVSy_ConTxt.XA,ya+XbWVSy_ConTxt.YA,yb+XbWVSy_ConTxt.YA,framecol);
    GrVLine(xb+XbWVSy_ConTxt.XA,ya+XbWVSy_ConTxt.YA,yb+XbWVSy_ConTxt.YA,framecol);
    };
#endif
#ifdef XbW_SYSDEF_X11_VERSION
  if (xb!=0){
    XSetForeground(XbWVSy_ConTxt.dpy,XbWVSy_ConTxt.gc,
      XbWVGr_ColorValues[fillcol] );
    XFillRectangle(XbWVSy_ConTxt.dpy,XbWVSy_ConTxt.window,
      XbWVSy_ConTxt.gc,
      xa+XbWVSy_ConTxt.XA,
      ya+XbWVSy_ConTxt.YA,xb-xa,yb-ya);
      };
  if (msg!=NULL) {
    XSetForeground(XbWVSy_ConTxt.dpy,XbWVSy_ConTxt.gc,
      XbWVGr_ColorValues[textcol] );
    XDrawString(XbWVSy_ConTxt.dpy, XbWVSy_ConTxt.window,XbWVSy_ConTxt.gc,
      (xa+XbWVSy_ConTxt.XA+xb+XbWVSy_ConTxt.XA)/2-(XbWFGr_TWidth(msg)/2),
      (ya+XbWVSy_ConTxt.YA+yb+XbWVSy_ConTxt.YA)/2+XbWFGr_THeight()/2+2,
      msg,strlen(msg));
    };
  if (xb!=0){
    XSetForeground(XbWVSy_ConTxt.dpy,XbWVSy_ConTxt.gc,
      XbWVGr_ColorValues[framecol] );
    XDrawRectangle(XbWVSy_ConTxt.dpy,XbWVSy_ConTxt.window,
      XbWVSy_ConTxt.gc,
      xa+XbWVSy_ConTxt.XA,
      ya+XbWVSy_ConTxt.YA,
      xb-xa,yb-ya);
    };
#endif
  };
/*}}}  */
/*{{{  XbWSGr_BCBox(       TC3,GNU,X11    Text-Box, unten zentriert*/
void  XbWSGr_BCBox(
  int xa,int ya,
  int xb,int yb,
  char  *msg,
  int fillcol, int textcol, int framecol){
  ya = yb - XbWFGr_THeight()-2;
#ifdef XbW_SYSDEF_TC3_VERSION
  if (xb){
    setcolor(framecol);
    setfillstyle(SOLID_FILL,fillcol);
    bar(xa,ya,xb,yb);
    };
  setcolor(textcol);
  if (msg!=NULL) {
    outtextxy(
      (xa+xb)/2-(XbWFGr_TWidth((char*)msg)/2),
      ya,
      (char far *)msg);
    };
  if (xb){
    setcolor(framecol);
    line(xa,ya,xb,ya);
    line(xa,ya,xa,yb);
    line(xb,yb,xb,ya);
    line(xb,yb,xa,yb);
    };
#endif

#ifdef XbW_SYSDEF_GNU_VERSION
  if (xb){
    GrFilledBox(xa+XbWVSy_ConTxt.XA,ya+XbWVSy_ConTxt.YA,xb+XbWVSy_ConTxt.XA,yb+XbWVSy_ConTxt.YA,fillcol);
    };
  if (msg != NULL) {
    XbWSGr_TxtDraw(
      (xa+XbWVSy_ConTxt.XA+xb+XbWVSy_ConTxt.XA)/2-(XbWFGr_TWidth(msg)/2),
      ya+XbWVSy_ConTxt.YA,
      msg,textcol,fillcol);
    };
  if (xb){
    GrHLine(xa+XbWVSy_ConTxt.XA,xb+XbWVSy_ConTxt.XA,ya+XbWVSy_ConTxt.YA,framecol);
    GrHLine(xa+XbWVSy_ConTxt.XA,xb+XbWVSy_ConTxt.XA,yb+XbWVSy_ConTxt.YA,framecol);
    GrVLine(xa+XbWVSy_ConTxt.XA,ya+XbWVSy_ConTxt.YA,yb+XbWVSy_ConTxt.YA,framecol);
    GrVLine(xb+XbWVSy_ConTxt.XA,ya+XbWVSy_ConTxt.YA,yb+XbWVSy_ConTxt.YA,framecol);
    };
#endif
#ifdef XbW_SYSDEF_X11_VERSION
  if (xb!=0){
    XSetForeground(XbWVSy_ConTxt.dpy,XbWVSy_ConTxt.gc,
      XbWVGr_ColorValues[fillcol] );
    XFillRectangle(XbWVSy_ConTxt.dpy,XbWVSy_ConTxt.window,
      XbWVSy_ConTxt.gc,
      xa+XbWVSy_ConTxt.XA,
      ya+XbWVSy_ConTxt.YA,xb-xa,yb-ya);
      };
  if (msg!=NULL) {
    XSetForeground(XbWVSy_ConTxt.dpy,XbWVSy_ConTxt.gc,
      XbWVGr_ColorValues[textcol] );
    XDrawString(XbWVSy_ConTxt.dpy, XbWVSy_ConTxt.window,XbWVSy_ConTxt.gc,
      (xa+XbWVSy_ConTxt.XA+xb+XbWVSy_ConTxt.XA)/2-(XbWFGr_TWidth(msg)/2),
      ya+XbWVSy_ConTxt.YA+XbWFGr_THeight(),
      msg,strlen(msg));
    };
  if (xb!=0){
    XSetForeground(XbWVSy_ConTxt.dpy,XbWVSy_ConTxt.gc,
      XbWVGr_ColorValues[framecol] );
    XDrawRectangle(XbWVSy_ConTxt.dpy,XbWVSy_ConTxt.window,
      XbWVSy_ConTxt.gc,
      xa+XbWVSy_ConTxt.XA,
      ya+XbWVSy_ConTxt.YA,
      xb-xa,yb-ya);
    };
#endif
  };
/*}}}  */
/*{{{  XbWSGr_RBBox(       TC3,GNU,X11    Text-Box rechts unten aligned*/
void  XbWSGr_RBBox(
  int xa,int ya,
  int xb,int yb,
  char  *msg,
  int fillcol, int textcol, int framecol){
#ifdef XbW_SYSDEF_TC3_VERSION
  if (xb){
    setcolor(framecol);
    setfillstyle(SOLID_FILL,fillcol);
    bar(xa,ya,xb,yb);
    };
  setcolor(textcol);
  if (msg!=NULL) {
    outtextxy(
      xb-2-XbWFGr_TWidth((char*)msg),
      yb+2-XbWFGr_THeight(),(char far *)msg);
    };
  if (xb){
    setcolor(framecol);
    line(xa,ya,xb,ya);
    line(xa,ya,xa,yb);
    line(xb,yb,xb,ya);
    line(xb,yb,xa,yb);
    };
#endif

#ifdef XbW_SYSDEF_GNU_VERSION
  if (xb){
    GrFilledBox(xa+XbWVSy_ConTxt.XA,ya+XbWVSy_ConTxt.YA,xb+XbWVSy_ConTxt.XA,yb+XbWVSy_ConTxt.YA,fillcol);
    };
  if (msg!=NULL) {
    XbWSGr_TxtDraw(
      xb+XbWVSy_ConTxt.XA-2-XbWFGr_TWidth(msg),
      yb+XbWVSy_ConTxt.YA+2-XbWFGr_THeight(),msg,textcol,fillcol);
    };
  if (xb){
    GrHLine(xa+XbWVSy_ConTxt.XA,xb+XbWVSy_ConTxt.XA,ya+XbWVSy_ConTxt.YA,framecol);
    GrHLine(xa+XbWVSy_ConTxt.XA,xb+XbWVSy_ConTxt.XA,yb+XbWVSy_ConTxt.YA,framecol);
    GrVLine(xa+XbWVSy_ConTxt.XA,ya+XbWVSy_ConTxt.YA,yb+XbWVSy_ConTxt.YA,framecol);
    GrVLine(xb+XbWVSy_ConTxt.XA,ya+XbWVSy_ConTxt.YA,yb+XbWVSy_ConTxt.YA,framecol);
    };
#endif
#ifdef XbW_SYSDEF_X11_VERSION
  if (xb!=0){
    XSetForeground(XbWVSy_ConTxt.dpy,XbWVSy_ConTxt.gc,
      XbWVGr_ColorValues[fillcol] );
    XFillRectangle(XbWVSy_ConTxt.dpy,XbWVSy_ConTxt.window,
      XbWVSy_ConTxt.gc,
      xa+XbWVSy_ConTxt.XA,
      ya+XbWVSy_ConTxt.YA,xb-xa,yb-ya);
      };
  if (msg!=NULL) {
    XSetForeground(XbWVSy_ConTxt.dpy,XbWVSy_ConTxt.gc,
      XbWVGr_ColorValues[textcol] );
    XDrawString(XbWVSy_ConTxt.dpy, XbWVSy_ConTxt.window,XbWVSy_ConTxt.gc,
      xb+XbWVSy_ConTxt.XA-2-XbWFGr_TWidth(msg),
      yb+XbWVSy_ConTxt.YA-1,
      msg,strlen(msg));
    };
  if (xb!=0){
    XSetForeground(XbWVSy_ConTxt.dpy,XbWVSy_ConTxt.gc,
      XbWVGr_ColorValues[framecol] );
    XDrawRectangle(XbWVSy_ConTxt.dpy,XbWVSy_ConTxt.window,
      XbWVSy_ConTxt.gc,
      xa+XbWVSy_ConTxt.XA,
      ya+XbWVSy_ConTxt.YA,
      xb-xa,yb-ya);
    };
#endif
  };
/*}}}  */
/*{{{  XbWSGr_GotoXY(      ???,TC3*/
void  XbWSGr_GotoXY(int x, int y){
#ifdef XbW_SYSDEF_TC3_VERSION
  gotoxy(x,y);
#endif
  };
/*}}}  */
/*}}}  */
/*{{{  XbWSWd_XXXXXX(      TC3,GNU,X!!    Aktuelle Fenstergrosse andern*/
/*{{{  XbWSWd_Resize(      TC3,GNU,X!!    Aktuelle Fenstergrosse andern*/
void  XbWSWd_Resize(void  *(*p)[]){
#ifdef XbW_SYSDEF_TC3_VERSION
  int Mausx,Mausy;
#endif
  int SizeXneu,SizeYneu;
  SizeXneu = *XbWVWd_W.sx;
  SizeYneu = *XbWVWd_W.sy;
#ifdef XbW_SYSDEF_TC3_VERSION
  XbWSMs_FramON(*XbWVWd_W.nx,*XbWVWd_W.ny,*XbWVWd_W.nx+*XbWVWd_W.sx,*XbWVWd_W.ny+*XbWVWd_W.sy,14);
  while (XbWVMs_Button==1)  {
    Mausx = XbWVMs_XPos; Mausy = XbWVMs_YPos;
    XbWSMs_Stat(); XbWSMs_ChkMot();
    if (XbWVMs_Bewegt==1) {
      Mausx = XbWVMs_XPos-Mausx; Mausy = XbWVMs_YPos-Mausy;
      XbWFGr_MaxPort();
      XbWSMs_DFramOFF(*XbWVWd_W.nx,*XbWVWd_W.ny,*XbWVWd_W.nx+SizeXneu,*XbWVWd_W.ny+SizeYneu);
      SizeXneu = SizeXneu + Mausx;
      SizeYneu = SizeYneu + Mausy;
      XbWSMs_FramON(*XbWVWd_W.nx,*XbWVWd_W.ny,*XbWVWd_W.nx+SizeXneu,*XbWVWd_W.ny+SizeYneu,14);
      };
    };
  XbWFGr_CurOFF();
  XbWFWd_BackGr();
  XbWFGr_CurOFF();
  *XbWVWd_W.sx = SizeXneu;
  *XbWVWd_W.sy = SizeYneu;
#endif
#ifdef XbW_SYSDEF_GNU_VERSION
  {
    int ende = 0;
    MouseEvent mev;
    XbWSMs_SetHandCursor();
    MouseWarp(*XbWVWd_W.nx+SizeXneu,*XbWVWd_W.ny+SizeYneu);
    MouseSetCursorMode(M_CUR_RUBBER,*XbWVWd_W.nx,*XbWVWd_W.ny,15);
    MouseGetEvent(M_BUTTON_UP, &mev);
    SizeXneu = mev.x;
    SizeYneu = mev.y;
    MouseSetCursorMode(M_CUR_NORMAL);
    XbWFGr_CurOFF();
    XbWFWd_BackGr();
    XbWFGr_CurOFF();
    XbWSMs_SetArrowCursor();
    if (SizeXneu > *XbWVWd_W.nx + 10){
      *XbWVWd_W.sx = SizeXneu-*XbWVWd_W.nx;
      };
    if (SizeYneu > *XbWVWd_W.ny + 10){
      *XbWVWd_W.sy = SizeYneu-*XbWVWd_W.ny;
      };
    };
#endif
#ifdef XbW_SYSDEF_X11_VERSION
  {
    int ende = 0;
    Window root, child;
    int xr, yr, xp, yp;
    unsigned int mask;
 
    XbWFGr_MaxPort();
    XbWVMs_XPos = *XbWVWd_W.nx+*XbWVWd_W.sx;
    XbWVMs_YPos = *XbWVWd_W.ny+*XbWVWd_W.sy;
    XbWSMs_Warp(XbWVMs_XPos, XbWVMs_YPos);
    XbWSMs_SetHandCursor();
    if (XQueryPointer(
          XbWVSy_ConTxt.dpy,
          XbWVSy_ConTxt.window,
          &root, &child,
          &xr, &yr, &xp, &yp, &mask)==True){
      SizeXneu = xp;
      SizeYneu = yp;
      XbWSMs_FramON(*XbWVWd_W.nx,*XbWVWd_W.ny,SizeXneu,SizeYneu,14);
      while (!ende){
        if (XQueryPointer(
            XbWVSy_ConTxt.dpy,
            XbWVSy_ConTxt.window,
            &root, &child,
            &xr, &yr, &xp, &yp, &mask)==True){
          if (mask & Button1Mask){
            XbWSMs_FramOFF(*XbWVWd_W.nx,*XbWVWd_W.ny,SizeXneu,SizeYneu);
            SizeXneu = xp;
            SizeYneu = yp;
            XbWSMs_FramON(*XbWVWd_W.nx,*XbWVWd_W.ny,SizeXneu,SizeYneu,14);
            }
          else {
            ende=1;
            };
          };
        };
      };
 
    XbWSMs_FramOFF(*XbWVWd_W.nx,*XbWVWd_W.ny,SizeXneu,SizeYneu);
    XbWSMs_SetArrowCursor();
    XbWFWd_EraWdw();
    if (SizeXneu < 0) { SizeXneu = 0;};
    if (SizeXneu > XbWFGr_MaxX()) { SizeXneu = XbWFGr_MaxX()-20;};
    if (SizeYneu < 0) { SizeYneu = 0;  };
    if (SizeYneu > XbWFGr_MaxY()) { SizeYneu = XbWFGr_MaxY()-40;};
 
    *XbWVWd_W.sx = SizeXneu-*XbWVWd_W.nx;
    *XbWVWd_W.sy = SizeYneu-*XbWVWd_W.ny;
    XbWFWd_DrawAll();
    };
#endif
  XbWFWd_DrawAll();
  if (p == NULL){
    XbWFWd_DrawAll();
    }
  else {
    if ((int)(*p)[0] > 0) {
      if ((int)(*p)[1] > 0) {
        XbWFWd_DrawAll();
        };
      }
    else {
      XbWFWd_DrawAll();
      };
    };
  XbWFGr_CurON();
  };
/*}}}  */
/*{{{  XbWSWd_Move(        TC3,GNU,X!!    Aktuelles Fenster bewegen*/
void  XbWSWd_Move(void){
  int NullXneu,NullYneu,Mausx,Mausy;
  NullXneu = *XbWVWd_W.nx; NullYneu = *XbWVWd_W.ny;
  Mausx = XbWVMs_XPos; Mausy = XbWVMs_YPos;
  XbWFGr_MaxPort();
#ifdef XbW_SYSDEF_TC3_VERSION
  XbWSMs_FramON(*XbWVWd_W.nx,*XbWVWd_W.ny,*XbWVWd_W.nx+*XbWVWd_W.sx,*XbWVWd_W.ny+*XbWVWd_W.sy,14);
  while (XbWVMs_Button == 1){
    Mausx = XbWVMs_XPos; Mausy = XbWVMs_YPos;
    XbWSMs_Stat(); XbWSMs_ChkMot();
    if (XbWVMs_Bewegt == 1){
      XbWSMs_DFramOFF(NullXneu,NullYneu,NullXneu+*XbWVWd_W.sx,NullYneu+*XbWVWd_W.sy);
      Mausx = XbWVMs_XPos-Mausx;Mausy = XbWVMs_YPos-Mausy;

      NullXneu = NullXneu + Mausx; NullYneu = NullYneu +Mausy;
      XbWVMs_CX = XbWVMs_XPos; XbWVMs_CY = XbWVMs_YPos;
      XbWSMs_FramON(NullXneu,NullYneu,NullXneu+*XbWVWd_W.sx,NullYneu+*XbWVWd_W.sy,14);
      };
    };
  XbWSMs_DFramOFF(NullXneu,NullYneu,NullXneu+*XbWVWd_W.sx,NullYneu+*XbWVWd_W.sy);
#endif
#ifdef XbW_SYSDEF_GNU_VERSION
  {
    int ende = 0;
    MouseEvent mev;
    MouseWarp(NullXneu+3,NullYneu+2);
    XbWSMs_SetHandCursor();
    MouseSetCursorMode(M_CUR_BOX,-3,-2,*XbWVWd_W.sx-3,*XbWVWd_W.sy-2,15);
    MouseGetEvent(M_BUTTON_UP, &mev);
    NullXneu = mev.x-3;
    NullYneu = mev.y-2;
    XbWSMs_SetArrowCursor();
    MouseSetCursorMode(M_CUR_NORMAL);
    MouseWarp(Mausx,Mausy);
    };
#endif
#ifdef XbW_SYSDEF_X11_VERSION
  {
    int ende = 0;
    Window root, child;
    int xr, yr, xp, yp;
    unsigned int mask;
 
    XbWVMs_XPos = *XbWVWd_W.nx;
    XbWVMs_YPos = *XbWVWd_W.ny;
    XbWSMs_Warp(XbWVMs_XPos, XbWVMs_YPos);
    Mausx = XbWVMs_XPos; Mausy = XbWVMs_YPos;
    XbWSMs_SetHandCursor();
    if (XQueryPointer(
          XbWVSy_ConTxt.dpy,
          XbWVSy_ConTxt.window,
          &root, &child,
          &xr, &yr, &xp, &yp, &mask)==True){
      NullXneu = xp;
      NullYneu = yp;
      XbWSMs_FramON(NullXneu,NullYneu,NullXneu+*XbWVWd_W.sx,NullYneu+*XbWVWd_W.sy,14);
      while (!ende){
        if (XQueryPointer(
            XbWVSy_ConTxt.dpy,
            XbWVSy_ConTxt.window,
            &root, &child,
            &xr, &yr, &xp, &yp, &mask)==True){
          if (mask & Button1Mask){
            XbWSMs_FramOFF(NullXneu,NullYneu,NullXneu+*XbWVWd_W.sx,NullYneu+*XbWVWd_W.sy);
            NullXneu = xp;
            NullYneu = yp;
            XbWSMs_FramON(NullXneu,NullYneu,NullXneu+*XbWVWd_W.sx,NullYneu+*XbWVWd_W.sy,8);
            }
          else {
            ende=1;
            };
          };
        };
      };
 
    XbWSMs_FramOFF(NullXneu,NullYneu,NullXneu+*XbWVWd_W.sx,NullYneu+*XbWVWd_W.sy);
    XbWSMs_SetArrowCursor();
    };
#endif
  XbWFWd_EraWdw();
  if (NullXneu < 0) { NullXneu = 0;};
  if (NullXneu > XbWFGr_MaxX()) { NullXneu = XbWFGr_MaxX()-20;};
  if (NullYneu < 0) { NullYneu = 0;  };
  if (NullYneu > XbWFGr_MaxY()) { NullYneu = XbWFGr_MaxY()-40;};

  *XbWVWd_W.nx = NullXneu;
  *XbWVWd_W.ny = NullYneu;
  XbWFWd_DrawAll();
  };
/*}}}  */
/*}}}  */
/*{{{  XbWSGr_XXXXXXX(     TC3,GNU,x--    Grafikfunktionen/Modi*/
/*{{{  XbWSGr_ResMode(     TC3,GNU,x--    Grafikmodus wiederherstellen*/
void  XbWSGr_ResMode(void){
#ifdef XbW_SYSDEF_TC3_VERSION
  int GT = XbWDGr_AkDrivr;
  int GM = XbWDGr_AkGrMod;
  initgraph((int far *)&GT,(int far *)&GM,"\\xw\\bgi");
  if ((GT=graphresult()) != grOk) {
    printf("VGA Graphic Error: %s\n",
    grapherrormsg(GT));
    exit(1);
    };
#endif
#ifdef XbW_SYSDEF_GNU_VERSION
  if ((XbWVSy_ConTxt.top.txo_font = GrLoadFont("pc8x8.fnt")) == NULL) {return;};
  XbWVSy_ConTxt.top.txo_xmag = 1;
  XbWVSy_ConTxt.top.txo_ymag = 1;
  XbWVSy_ConTxt.top.txo_direct = GR_TEXT_RIGHT;
  XbWVSy_ConTxt.top.txo_xalign = GR_ALIGN_LEFT;
  XbWVSy_ConTxt.top.txo_yalign = GR_ALIGN_TOP;
  XbWVSy_ConTxt.top.txo_chrtype = GR_BYTE_TEXT;
  XbWSMs_Init();
#endif
  };
/*}}}  */
/*{{{  XbWSGr_Close(       TC3,g--,x--    Grafik schlieen*/
void   XbWSGr_Close(void){
#ifdef XbW_SYSDEF_TC3_VERSION
  closegraph();
  textmode(C80);
  textcolor(WHITE);
  textbackground(BLACK);
  clrscr();
#endif
  };
/*}}}  */
/*{{{  XbWSGr_GtPhysX(     TC3,GNU,X11    Grosste Schirmkoordinate X*/
int  XbWSGr_GtPhysX(void){
#ifdef XbW_SYSDEF_TC3_VERSION
  return(getmaxx());
#endif
#ifdef XbW_SYSDEF_GNU_VERSION
  return(GrMaxX()-1);
#endif
#ifdef XbW_SYSDEF_X11_VERSION
  return(XbW_X11_ScreenWidth);
#endif
  };
/*}}}  */
/*{{{  XbWSGr_GtPhysY(     TC3,GNU,X11           -"-               Y*/
int  XbWSGr_GtPhysY(void){
#ifdef XbW_SYSDEF_TC3_VERSION
  return(getmaxy());
#endif
#ifdef XbW_SYSDEF_GNU_VERSION
  return(GrMaxY()-1);
#endif
#ifdef XbW_SYSDEF_X11_VERSION
  return(XbW_X11_ScreenHeight);
#endif
  };
/*}}}  */
/*{{{  XbWSGr_DspIcon(     TC3,g!!,x!!    Icon darstellen*/
void  XbWSGr_DspIcon(
    XbWDDb_DbIObj  *TO){
#ifdef XbW_SYSDEF_TC3_VERSION
  FILE *fp;
  char *fname;
  char pict[1600];
  fname = (char*)XbWFDb_VarInh(TO->chn,XbWDDb_Str,"V",1);
  if (fname != NULL) {
    if ((fp = XbWSSy_fopen(fname,"rb")) != NULL) {
      fseek(fp,68,SEEK_SET);
      fread(pict,1,1599,fp);
      putimage(*TO->XA+1, *TO->YA+1,pict,COPY_PUT);
      fclose(fp);
      };
    };
#endif
  };
/*}}}  */
/*{{{  XbWSGr_GtImSiz(     TC3,g--,x--    Turbo C-Funktion*/
unsigned  XbWSGr_GtImSiz(int a, int b, int c, int d){
#ifdef XbW_SYSDEF_TC3_VERSION
  return(imagesize(a,b,c,d));
#endif
  return(1);
  };
/*}}}  */
/*{{{  XbWSGr_PutImag(     TC3,g--,x--    Turbo C-Funktion*/
void  XbWSGr_PutImag(int a, int b, void  *c, int d){
#ifdef XbW_SYSDEF_TC3_VERSION
  putimage(a,b,c,d);
#endif
  };
/*}}}  */
/*{{{  XbWSGr_GetImag(     TC3,g--,x--    Turbo C-Funktion*/
void  XbWSGr_GetImag(int a, int b, int c, int d, void  *e){
#ifdef XbW_SYSDEF_TC3_VERSION
  getimage(a,b,c,d,e);
#endif
  };
/*}}}  */
/*{{{  XbWSGr_SetClip(     TC3,GNU,X11    Clipping fr Zeichenfunkt.*/
void  XbWSGr_SetClip(
    int xa, int ya, int xb, int yb){
#ifdef XbW_SYSDEF_TC3_VERSION
  setviewport(xa,ya,xb,yb,1);
#endif
#ifdef XbW_SYSDEF_GNU_VERSION
  XbWVSy_ConTxt.XA = xa;
  XbWVSy_ConTxt.YA = ya;
  XbWVSy_ConTxt.XB = xb;
  XbWVSy_ConTxt.YB = yb;
  GrSetClipBox(XbWVSy_ConTxt.XA,XbWVSy_ConTxt.YA,XbWVSy_ConTxt.XB,XbWVSy_ConTxt.YB);
#endif
#ifdef XbW_SYSDEF_X11_VERSION
  {
    XRectangle rect[1];
    int hh;
    if (xa > xb) {
      hh = xa; xa = xb; xb = hh;
      };
    if (ya > yb) {
      hh = ya; ya = yb; yb = hh;
      };
    rect[0].x = xa-1;        rect[0].y = ya-1;
    rect[0].width = xb-xa+2; rect[0].height = yb-ya+2;
    XbWVSy_ConTxt.XA = xa;
    XbWVSy_ConTxt.YA = ya;
    XbWVSy_ConTxt.XB = xb;
    XbWVSy_ConTxt.YB = yb;
 
    XSetClipRectangles(
      XbWVSy_ConTxt.dpy,
      XbWVSy_ConTxt.gc,
      0,
      0,
      rect,
      1,
      Unsorted);
 
    };
#endif
  };
/*}}}  */
/*{{{  XbWSGr_GetClip(     TC3,GNU,X11    Clipping fr Zeichenfunkt.*/
void  XbWSGr_GetClip(void  *theport){
#ifdef XbW_SYSDEF_TC3_VERSION
  getviewsettings((struct viewporttype far *)theport);
#endif
#ifdef XbW_SYSDEF_GNU_VERSION
  int a,b,c,d;
  struct viewporttype far *t = (struct viewporttype far *)theport;
  t->left   = XbWVSy_ConTxt.XA;
  t->top    = XbWVSy_ConTxt.YA;
  t->right  = XbWVSy_ConTxt.XB;
  t->bottom = XbWVSy_ConTxt.YB;
  t->clip = 1;
#endif
#ifdef XbW_SYSDEF_X11_VERSION
 
  struct viewporttype far *t = (struct viewporttype far *)theport;
  t->left   = XbWVSy_ConTxt.XA;
  t->top    = XbWVSy_ConTxt.YA;
  t->right  = XbWVSy_ConTxt.XB;
  t->bottom = XbWVSy_ConTxt.YB;
  t->clip = 1;
#endif
  };
/*}}}  */
/*}}}  */
/*{{{  XbWSGr_SetFontLib(  TC3,g--,x--    Font Parameter aufsetzen*/
int  XbWSGr_SetFontLib(void){
#ifdef XbW_SYSDEF_TC3_VERSION
  setusercharsize(1,1,1,1);
#endif
  return(0);
  };
/*}}}  */
/*{{{  XbWSOS_FilDir(      TC3,g!!,x!!    String-Array mit Dateinamen*/
int  XbWSOS_FilDir(void  *(*p)[]){
#ifdef XbW_SYSDEF_TC3_VERSION
  int ii,atrb,firstfound;
  struct ffblk erg;
  char suchname[60],sstr[60],*strp;
  FILE *fp;
  XbWDDb_Header th;
  XbWDDb_DbIVar  *ac_gp;
  /* Parameterliste
     =======================================================
     1 - Listenname (z.B. OBJ)
     2 - Gruppenname (z.B. oszill)
     3 - Variablenname (chain) ohne chain-Nr
         (BSP: fp fuer alle fp0...fp13)
     4 - Drive auf dem gesucht wird
     5 - Subdirectory in dem gesucht wird
     6 - Suchmodus:
         'A' - finde archivierte Dateien
         'D' - finde Directories
         'S' - finde Systemdateien
         'P' - finde XbW-Projekte
     7 - Anzeigespezifikation
         'P' - mit Pfad
         'E' - mit Extension
     8 - Startnummer zum Fuellen (ausgelassene Eintraege)
     9 - Suchspezifikation
  [  10 - Variable fuer Datei-Beschreibungen (selbe Liste & Gruppe)
     11 - Variable fuer Datei-Laengen          ] (optionale Param.)
     ======================================================= */
  switch ( (int)(*p)[0] ) {
    case 9:
    case 11: break;
    default: return(1);
    };
  atrb = 0;
  if (strchr((char*)(*p)[6],'A') != NULL) { atrb |= FA_ARCH; };
  if (strchr((char*)(*p)[6],'D') != NULL) { atrb |= FA_DIREC; };
  if (strchr((char*)(*p)[6],'S') != NULL) { atrb |= FA_SYSTEM; };
  firstfound = 0;
  sprintf(suchname,"%s%s\\%s",(char*)(*p)[4],(char*)(*p)[5],(char*)(*p)[9]);
  for (ii=0; ii< (int)(*p)[8]; ii++){
    if (!ii){
      if (findfirst(suchname,&erg,atrb)){ return(0);};
      firstfound = 1;
      }
    else {
      if (findnext(&erg) ){ return(0);};
      };
    };
  if ((ac_gp = XbWFDb_FindGrp((char*)(*p)[1],(char*)(*p)[2])) == NULL) {
    return(0);
    };
  for (ii=0; ii< 2000; ii++){
    sprintf(sstr,"%s%d",(char*)(*p)[3],ii);
    if ((strp = (char*)XbWFDb_VarInh(ac_gp,XbWDDb_Str,sstr,1)) == NULL) {
      ii = 3000;
      }
    else {
      strcpy(strp,"");
      sprintf(sstr,"%s%d",(char*)(*p)[10],ii);
      if (!XbWFDb_PutStr(ac_gp,sstr,1," ")) {
        }
      else {
        sprintf(sstr,"%s%d",(char*)(*p)[11],ii);
        XbWFDb_PutNum(ac_gp,sstr,1,0);
        };
      };
    };
  for (ii=0; ii< 2000; ii++){
    if ((!ii)&(!firstfound)){
      if (findfirst(suchname,&erg,atrb)){ return(0);};
      firstfound = 1;
      }
    else {
      if (findnext(&erg) ){ return(0);};
      };
    sprintf(sstr,"%s%d",(char*)(*p)[3],ii);
    if ((strp = (char*)XbWFDb_VarInh(ac_gp,XbWDDb_Str,sstr,1)) == NULL) {
      return(0);
      };
    if (strchr((char*)(*p)[7],'P') != NULL) {
      strcpy(strp,(char*)(*p)[4]);
      strcat(strp,(char*)(*p)[5]);
      }
    else {
      strcpy(strp,"");
      };
    if (strchr((char*)(*p)[7],'E') != NULL) {
      strcat(strp,erg.ff_name);
      }
    else {
      if (strchr(erg.ff_name,'.') != NULL) {
        strcpy(strchr(erg.ff_name,'.'),"\0");
        };
      strcat(strp,erg.ff_name);
      };
    if (strchr((char*)(*p)[6],'P') != NULL) {
      if (strchr((char*)(*p)[7],'E') != NULL) {
        sprintf(sstr,"%s%s\\%s",(char*)(*p)[4],(char*)(*p)[5],erg.ff_name);
        }
      else {
        sprintf(sstr,"%s%s\\%s.prj",(char*)(*p)[4],(char*)(*p)[5],erg.ff_name);
        };
      if ((fp = XbWSSy_fopen(sstr,"rb") ) != NULL){
        fread(&th,sizeof(XbWDDb_Header),1,fp);
        fclose(fp);
        sprintf(sstr,"%s%d",(char*)(*p)[10],ii);
        if (!XbWFDb_PutStr(ac_gp,sstr,1,th.reserviert)) {
          return(0);
          };
        sprintf(sstr,"%s%d",(char*)(*p)[11],ii);
        XbWFDb_PutNum(ac_gp,sstr,1,(double)((th.tab_size/1000)+1));
        };
      };
    };
#endif
  return(0);
  };
/*}}}  */
/*{{{  XbWSOS_SpwnShel(    TC3,g!!,x!!    OS-Shell spawn*/
void  XbWSOS_SpwnShel(void){
#ifdef XbW_SYSDEF_TC3_VERSION
  int curdrive; char curpath[70];curdrive = getdisk();
  getcurdir(0,curpath);
  XbWSGr_Close();
  if (system("c:\\command.com c:\\") != 0) {
    puts("Cannot spawn system task ");
    exit(0);};
  setdisk(curdrive);chdir(curpath);
#endif
#ifdef XbW_SYSDEF_X11_VERSION
  if (system("xterm") != 0) {
    puts("Cannot spawn system task ");
    exit(0);};
#endif
  XbWSGr_ResMode(); XbWFWd_BackGr();
  XbWFWd_DrawAll();
  };
/*}}}  */
/*{{{  XbWSOS_SpwnStd(     TC3,g!!,x!!    Standard-Task spawnen*/
int  XbWSOS_SpwnStd(void  *(*p)[], int (*t)[]){
/*{{{  TC3-Version*/
#ifdef XbW_SYSDEF_TC3_VERSION
  int curdrive; char curpath[70];
  curdrive = getdisk();
  getcurdir(0,curpath);
  if ((int)(*p)[0] < 1 ) {return(1);};
  switch ( (int)(*t)[1] ) {
    case XbWDMf_StrPar:
      strcpy(XbWVSy_DosCmd,(char*)(*p)[1]);
      break;
    case XbWDMf_VLPar:
      {
        XbWDDb_DbIVar  *QQ;
        char *fsp;
        QQ = (XbWDDb_DbIVar  *)(*p)[1];
        if (QQ == NULL) { return(1); };
        fsp = (char*)XbWFDb_VarInh(QQ,XbWDDb_Str,NULL,1);
        strcpy(XbWVSy_DosCmd,(char*)XbWFTb_PckTxt(fsp));
        };
      break;
    default: return(1);
    };

  {
    int ll = 2;
    while ((int)(*p)[0] >= ll) {
      switch ( (int)(*t)[ll] ) {
        case XbWDMf_IntPar:
        case XbWDMf_VPPar:
          {
            char zzs[30];
            sprintf(zzs,"%d ",(int)(*p)[ll]);
            strcat(XbWVSy_DosCmd,zzs);
            goto SpawnWeiter;
            };

        case XbWDMf_DblPar:
        case XbWDMf_StrPar:
          strcat(XbWVSy_DosCmd,(char*)(*p)[ll]);
          strcat(XbWVSy_DosCmd," ");
          break;
        case XbWDMf_VLPar:
          {
            XbWDDb_DbIVar  *QQ;
            char *fsp; double zz; int zi;
            QQ = (XbWDDb_DbIVar  *)(*p)[ll];
            if (QQ == NULL) { return(1); };
            if ((fsp = (char*)XbWFDb_VarInh(QQ,XbWDDb_Str,NULL,1)) != NULL) {
              strcat(XbWVSy_DosCmd,(char*)XbWFTb_PckTxt(fsp));
              strcat(XbWVSy_DosCmd," ");
              goto SpawnWeiter;
              };
            if ((fsp = (char*)XbWFDb_VarInh(QQ,XbWDDb_Int,NULL,1)) != NULL) {
              zi = XbWFDb_GetNum(QQ,NULL,1);
              {
                char zzs[200];
                sprintf(zzs,"%d ",zi);
                strcat(XbWVSy_DosCmd,zzs);
                goto SpawnWeiter;
                };
              };
            if ((fsp = (char*)XbWFDb_VarInh(QQ,XbWDDb_Dbl,NULL,1)) != NULL) {
              zz = XbWFDb_GetNum(QQ,NULL,1);
              {
                char zzs[200];
                sprintf(zzs,"%7.3f ",zz);
                strcat(XbWVSy_DosCmd,zzs);
                goto SpawnWeiter;
                };
              };
            };
          break;
        };
      SpawnWeiter:;
      ll++;
      };
    };
  XbWFTb_SpwnTsk();
  setdisk(curdrive);chdir(curpath);
  XbWSGr_GotoXY(1,1);
#endif
/*}}}  */
/*{{{  X11-Version*/
#ifdef XbW_SYSDEF_X11_VERSION
  if ((int)(*p)[0] < 1 ) {return(1);};
  switch ( (int)(*t)[1] ) {
    case XbWDMf_StrPar:
      strcpy(XbWVSy_DosCmd,(char*)(*p)[1]);
        strcpy(XbWVSy_DosCmd,(char*)XbWFTb_PckTxt(XbWVSy_DosCmd));
      break;
    case XbWDMf_VLPar:
      {
        XbWDDb_DbIVar  *QQ;
        char *fsp;
        QQ = (XbWDDb_DbIVar  *)(*p)[1];
        if (QQ == NULL) { return(1); };
        fsp = (char*)XbWFDb_VarInh(QQ,XbWDDb_Str,NULL,1);
        strcpy(XbWVSy_DosCmd,(char*)XbWFTb_PckTxt(fsp));
        };
      break;
    default: return(1);
    };
 
  {
    int ll = 2;
    while ((int)(*p)[0] >= ll) {
      switch ( (int)(*t)[ll] ) {
        case XbWDMf_IntPar:
        case XbWDMf_VPPar:
          {
            char zzs[30];
            sprintf(zzs,"%d ",(int)(*p)[ll]);
            strcat(XbWVSy_DosCmd,zzs);
            goto SpawnWeiter;
            };

        case XbWDMf_DblPar:
        case XbWDMf_StrPar:
            {
              char SsTr[200];
              sprintf(SsTr,(char*)(*p)[ll]);
              if (strstr(SsTr,"/")!= NULL){
                int ii;
                for (ii=0;ii<strlen(SsTr);ii++){
                  if (SsTr[ii] == '\\'){
                    SsTr[ii] = '/';
                    }
                  else {
                    if ((SsTr[ii] >= 'A') & (SsTr[ii] <= 'Z')){
                      SsTr[ii] = tolower(SsTr[ii]);
                      };
                    };
                  };
                strcat(XbWVSy_DosCmd,SsTr);
                }
              else {
                strcat(XbWVSy_DosCmd,(char*)(*p)[ll]);
                };
              };
            strcat(XbWVSy_DosCmd," ");
          break;
        case XbWDMf_VLPar:
          {
            XbWDDb_DbIVar  *QQ;
            char *fsp; double zz; int zi;
            QQ = (XbWDDb_DbIVar  *)(*p)[ll];
            if (QQ == NULL) { return(1); };
            if ((fsp = (char*)XbWFDb_VarInh(QQ,XbWDDb_Str,NULL,1)) != NULL) {
              char SsTr[200];
              sprintf(SsTr,fsp);
              if (strstr(SsTr,"/")!= NULL){
                int ii;
                for (ii=0;ii<strlen(SsTr);ii++){
                  if (SsTr[ii] == '\\'){
                    SsTr[ii] = '/';
                    }
                  else {
                    if ((SsTr[ii] >= 'A') & (SsTr[ii] <= 'Z')){
                      SsTr[ii] = tolower(SsTr[ii]);
                      };
                    };
                  };
                strcat(XbWVSy_DosCmd,(char*)XbWFTb_PckTxt(SsTr));
                }
              else {
                strcat(XbWVSy_DosCmd,(char*)XbWFTb_PckTxt(fsp));
                };
              strcat(XbWVSy_DosCmd," ");
              goto SpawnWeiter;
              };
            if ((fsp = (char*)XbWFDb_VarInh(QQ,XbWDDb_Int,NULL,1)) != NULL) {
              zi = XbWFDb_GetNum(QQ,NULL,1);
              {
                char zzs[200];
                sprintf(zzs,"%d ",zi);
                strcat(XbWVSy_DosCmd,zzs);
                goto SpawnWeiter;
                };
              };
            if ((fsp = (char*)XbWFDb_VarInh(QQ,XbWDDb_Dbl,NULL,1)) != NULL) {
              zz = XbWFDb_GetNum(QQ,NULL,1);
              {
                char zzs[200];
                sprintf(zzs,"%7.3f ",zz);
                strcat(XbWVSy_DosCmd,zzs);
                goto SpawnWeiter;
                };
              };
            };
          break;
        };
      SpawnWeiter:;
      ll++;
      };
    };
  printf("spawning task \"%s\"\n",XbWVSy_DosCmd);
  system(XbWVSy_DosCmd);
  return(0);
#endif
/*}}}  */
  return(0);
  };

/*}}}  */
/*{{{  XbWSOS_XXXXX(       TC3,GNU,x!!    Sound / Delay*/
/*{{{  XbWSOS_Sound(       TC3,GNU,x!!    Ton in Hertz ausgeben*/
void  XbWSOS_Sound(int freq){
#ifdef XbW_SYSDEF_TC3_VERSION
  sound(freq);
#endif
#ifdef XbW_SYSDEF_GNU_VERSION
  sound(freq);
#endif
  };
/*}}}  */
/*{{{  XbWSOS_NoSound(     TC3,GNU,x!!    Ton Aus*/
void  XbWSOS_NoSound(void){
#ifdef XbW_SYSDEF_TC3_VERSION
  nosound();
#endif
#ifdef XbW_SYSDEF_GNU_VERSION
  nosound();
#endif
  };
/*}}}  */
/*{{{  XbWSOS_Delay(       TC3,GNU,x!!    XbWFTb_Wait in Millisekunden*/
void  XbWSOS_Delay(int len){
#ifdef XbW_SYSDEF_TC3_VERSION
  delay(len);
#endif

#ifdef XbW_SYSDEF_GNU_VERSION
  long l=0;
  while(l < XbWVSy_DlyLim*len){
    l++;
    };
#endif
  };
/*}}}  */
/*}}}  */
/*{{{  XbWSSy_XXXTime(     TC3,g??,x??    Zeit / Datum*/
/*{{{  XbWSSy_GetTime(     TC3,g??,x??    Systemzeit*/
void   XbWSSy_GetTime(unsigned char *hh,unsigned char *mm,
                   unsigned char *ss,unsigned char *hhh){
#ifdef XbW_SYSDEF_TC3_VERSION
  struct time mytime;
  gettime(&mytime);
  *hh = mytime.ti_hour;
  *mm=mytime.ti_min;
  *ss=mytime.ti_sec;
  *hhh= mytime.ti_hund;
#endif
  };
/*}}}  */
/*{{{  XbWSSy_GetDate(     TC3,g??,x??    Systemdatum*/
void   XbWSSy_GetDate(unsigned char *yy,unsigned char *mm,
                   unsigned char *dd){
#ifdef XbW_SYSDEF_TC3_VERSION
  struct date mydate;
  getdate(&mydate);
  *yy = mydate.da_year;
  *mm = mydate.da_mon;
  *dd = mydate.da_day;
#endif
  };
/*}}}  */
/*{{{  XbWSSy_TimeSec(     TC3,GNU,X11    Sekunden seit 1.1.1980*/
time_t   XbWSSy_TimeSec(void){
#ifdef XbW_SYSDEF_TC3_VERSION
  return(time(NULL));
#endif
#ifdef XbW_SYSDEF_GNU_VERSION
  return(time(NULL));
#endif
#ifdef XbW_SYSDEF_X11_VERSION
  return(time(NULL));
#endif
  };
/*}}}  */
/*}}}  */
/*{{{  XbWSPu_XXXXX(       TC3,g??,x??    Pop-Up-Funktionen*/
/*{{{  XbWSPu_Error(       TC3,g??,x??    Fehler ausgeben, System beenden*/
void   XbWSPu_Error(char text[255]){
#ifdef XbW_SYSDEF_TC3_VERSION
  textmode(C80);
  textcolor(XbWVGr_Red);textbackground(XbWVGr_White);
  clrscr(); gotoxy(10,10);
  printf("A fatal error has occured.");
  gotoxy(10,12); printf(text); exit(1);
#endif
#ifdef XbW_SYSDEF_X11_VERSION
  printf("\n* * * A fatal error has occurred:\n%s\n",text);
  printf("* * * Last command prepared: %s\nXbW command line buffer: %s\n\n",
     XbWVSy_DebugCommand,XbWVSy_DebugLine);
  if (XbWVMf_C >= 0){
     printf("Last command parameter prepared: no %d\n",XbWVMf_C);
     switch(XbWVMf_T[XbWVMf_C-1]) {
       case XbWDMf_StrPar:
            printf("* * * STRING PARAMETER \"%s\"\n",&(XbWVMf_B[(XbWVMf_C)*XbWDMf_BfStrL]));
            break;
       case XbWDMf_DblPar:
            printf("* * * DOUBLE PARAMETER \"%s\"\n",&(XbWVMf_B[(XbWVMf_C)*XbWDMf_BfStrL]));
            break;
       case XbWDMf_IntPar:
       case XbWDMf_VPPar:
            printf("* * * INT PARAMETER \"%d\"\n",(int)XbWVMf_P[XbWVMf_C]);
            break;
       case XbWDMf_VLPar:
            printf("* * * POINTER PARAMETER\n");
            break;
       case XbWDMf_VIPar:
            printf("* * * VI-INT PARAMETER \"%d\"\n",(int)XbWVMf_P[XbWVMf_C]);
            break;
       };
     };
 
  printf("\n* * * Actual interpreter scan position: >>>\"%s\"\n\n",XbWVSy_DebugLinePos);

 
  XbWSGr_TLBox(1,XbWSGr_GtPhysY()-XbWDWd_BordH,500,XbWSGr_GtPhysY(),
     text,XbWVGr_LRed,XbWVGr_White,XbWVGr_Red);
  {
    XEvent event;
    event.type = 0;
    XFlush(XbWVSy_ConTxt.dpy);
    while (event.type != KeyPress){
      XNextEvent(XbWVSy_ConTxt.dpy,&event);
      };
    exit(1);
    };
#endif
  };
/*}}}  */
/*{{{  XbWSPu_Alarm(       TC3,GNU,X11    Unten am Schirm rote Box*/
void  XbWSPu_Alarm(char *msg){
  int cset;
  cset = XbWVMs_CSet;
  XbWSMs_OFF();
  XbWFTb_HBeep();
  XbWFTb_LBeep();
  XbWFGr_PushPort();
  XbWFGr_SetPort();
  XbWSGr_TLBox(1,XbWSGr_GtPhysY()-XbWDWd_BordH,500,XbWSGr_GtPhysY(),
     msg,XbWVGr_LRed,XbWVGr_White,XbWVGr_Red);
#ifdef XbW_SYSDEF_TC3_VERSION
  getch();
#endif
#ifdef XbW_SYSDEF_X11_VERSION
  XFlush(XbWVSy_ConTxt.dpy);
  {
    XEvent event;
    event.type = 0;
    while (event.type != KeyPress){
      XNextEvent(XbWVSy_ConTxt.dpy,&event);
      };
    };
#endif
#ifdef XbW_SYSDEF_GNU_VERSION
  { char a,b;
    XbWSMs_GetKey(&a,&b);
    };
#endif
  XbWSGr_TLBox(1,XbWSGr_GtPhysY()-XbWDWd_BordH,500,XbWSGr_GtPhysY(),
     NULL,XbWVGr_White,XbWVGr_White,XbWVGr_White);
  XbWFGr_PopPort();
  XbWFGr_ResPort();
  if (cset) {
    XbWSMs_ON();
    };
  };
/*}}}  */
/*{{{  XbWSPu_Msg(             ***        Nachricht in einem Window ausgeben*/
int  XbWSPu_Msg(void  *(*p)[],int (*t)[]){

#define DRAW_PBOX_IN_WDW 1
#define DRAW_PBOX_BORDER 2
#define DRAW_PBOX_THICK  4

  char fzeile[250];
  FILE *rfile;  int ll,ypos;
  char *fname; boolean ende;char *dummy="";
  int xa=0,ya=0,xb=10,yb=10,filc=0,frc=0,txc=0,dw=0;
 
  if ((int)(*p)[0] < 9) { return(1); };

  switch ( (int)(*t)[1]) {
    case XbWDMf_VPPar:
    case XbWDMf_IntPar: xa = (int)(*p)[1]; break;
    case XbWDMf_VLPar:  {
                          XbWDDb_DbIVar  *QQ;
                          QQ = (XbWDDb_DbIVar  *)(*p)[1];
                          xa = XbWFDb_GetNum(QQ,NULL,1);
                          break;
                          };
    };
  switch ( (int)(*t)[2]) {
    case XbWDMf_VPPar:
    case XbWDMf_IntPar: ya = (int)(*p)[2]; break;
    case XbWDMf_VLPar:  {
                          XbWDDb_DbIVar  *QQ;
                          QQ = (XbWDDb_DbIVar  *)(*p)[2];
                          ya = XbWFDb_GetNum(QQ,NULL,1);
                          break;
                          };
    };
  switch ( (int)(*t)[3]) {
    case XbWDMf_VPPar:
    case XbWDMf_IntPar: xb = (int)(*p)[3]; break;
    case XbWDMf_VLPar:  {
                          XbWDDb_DbIVar  *QQ;
                          QQ = (XbWDDb_DbIVar  *)(*p)[3];
                          xb = XbWFDb_GetNum(QQ,NULL,1);
                          break;
                          };
    };
  switch ( (int)(*t)[4]) {
    case XbWDMf_VPPar:
    case XbWDMf_IntPar: yb = (int)(*p)[4]; break;
    case XbWDMf_VLPar:  {
                          XbWDDb_DbIVar  *QQ;
                          QQ = (XbWDDb_DbIVar  *)(*p)[4];
                          yb = XbWFDb_GetNum(QQ,NULL,1);
                          break;
                          };
    };
  switch ( (int)(*t)[5]) {
    case XbWDMf_VPPar:
    case XbWDMf_IntPar: filc = (int)(*p)[5]; break;
    case XbWDMf_VLPar:  {
                          XbWDDb_DbIVar  *QQ;
                          QQ = (XbWDDb_DbIVar  *)(*p)[5];
                          filc = XbWFDb_GetNum(QQ,NULL,1);
                          break;
                          };
    };
  switch ( (int)(*t)[6]) {
    case XbWDMf_VPPar:
    case XbWDMf_IntPar: frc = (int)(*p)[6]; break;
    case XbWDMf_VLPar:  {
                          XbWDDb_DbIVar  *QQ;
                          QQ = (XbWDDb_DbIVar  *)(*p)[6];
                          frc = XbWFDb_GetNum(QQ,NULL,1);
                          break;
                          };
    };
  switch ( (int)(*t)[7]) {
    case XbWDMf_VPPar:
    case XbWDMf_IntPar: txc = (int)(*p)[7]; break;
    case XbWDMf_VLPar:  {
                          XbWDDb_DbIVar  *QQ;
                          QQ = (XbWDDb_DbIVar  *)(*p)[7];
                          txc = XbWFDb_GetNum(QQ,NULL,1);
                          break;
                          };
    };
  switch ( (int)(*t)[8]) {
    case XbWDMf_VPPar:
    case XbWDMf_IntPar: dw = (int)(*p)[8]; break;
    case XbWDMf_VLPar:  {
                          XbWDDb_DbIVar  *QQ;
                          QQ = (XbWDDb_DbIVar  *)(*p)[8];
                          dw = XbWFDb_GetNum(QQ,NULL,1);
                          break;
                          };
    };


  XbWFGr_CurOFF();
  XbWFGr_PushPort();

  if (dw & DRAW_PBOX_IN_WDW) {
    XbWFGr_MinPort(
      *XbWVWd_W.nx+1, 1+*XbWVWd_W.ny,   *XbWVWd_W.nx+ *XbWVWd_W.sx+1,
      *XbWVWd_W.ny+1+ *XbWVWd_W.sy);
    }
  else {
    XbWFGr_MinPort(
      0,0,XbWFGr_MaxX(),XbWFGr_MaxY());
    };

  if (dw & (DRAW_PBOX_THICK|DRAW_PBOX_BORDER)) {
    XbWSGr_TLBox(xa,ya,xb,yb,NULL,filc,0,frc);
    };

  {
    XbWDDb_DbIVar  *inf_var;
    if ((inf_var = XbWFDb_FindGrp("WDW",(char*)XbWVWd_W.nm)) == NULL){
      goto ende_popup;
      };
    if ((fname = (char*)XbWFDb_VarInh(inf_var,XbWDDb_Str,"inf",1)) == NULL){
      goto ende_popup;
      };
    };

  if ((rfile = XbWSSy_fopen(fname,"rt")) !=  NULL) {
    ypos = 0;
    for (ll=9;ll<=(int)(*p)[0];ll++){
      switch ((int)(*t)[ll]) {
        case XbWDMf_StrPar: rewind(rfile);
                            ende = 0;
                            do{ende = (fgets(fzeile,245,rfile) == NULL);}
                            while ((strstr(fzeile,(char *)(*p)[ll]) == NULL) &
                            (ende == 0)) ;
                            dummy=strstr(fzeile,":");
                            dummy++;
                            break;
        case XbWDMf_VPPar:
        case XbWDMf_IntPar: sprintf(fzeile,"%d",(int)(*p)[ll]);
                            dummy = fzeile;
                            break;
        case XbWDMf_VLPar:
                            {
                              XbWDDb_DbIVar  *QQ;
                              char *aov = NULL; int atp; char *ain; int ale;
                              QQ = (XbWDDb_DbIVar *)(*p)[ll];

                              if (XbWFDb_GetInf(QQ,0,aov,&atp,&ain,&ale,1)) {
                                switch (atp) {
                                  case XbWDDb_Str:
                                    dummy = ain;
                                    break;
                                  case XbWDDb_Int:
                                    sprintf(fzeile,"%d",(int) *((int*)ain));
                                    dummy = fzeile;
                                    break;
                                  case XbWDDb_Dbl:
                                    sprintf(fzeile,"%7.3f",(double) *((double*)ain));
                                    dummy = fzeile;
                                    break;
                                  };
                                };
                              };
        };

      if (strchr(dummy,13) != NULL) {
        strcpy(strchr(dummy,13),"\0");
        };
      if (strchr(dummy,10) != NULL) {
        strcpy(strchr(dummy,10),"\0");
        };
      XbWSGr_TLBox(xa,ya+ypos,0,0,dummy,filc,txc,0);
      ypos += 11;
      };
    fclose(rfile);
    };


  ende_popup:;
  XbWFGr_PopPort(); XbWFGr_ResPort();
  XbWFGr_CurON();
  return(0);
  };

/*}}}  */
/*{{{  XbWSPu_Dir(             ***        Directory-Box anzeigen*/
int  XbWSPu_Dir(void  *(*p)[],int (*t)[]){
  return XbWSPu_DirSb(p,t,0);
  };
/*}}}  */
/*{{{  XbWSPu_DirEd(           ***        Directory-Box auswerten*/
int  XbWSPu_DirEd(void  *(*p)[],int (*t)[]){
  return XbWSPu_DirSb(p,t,1);
  };
/*}}}  */
/*{{{  XbWSPu_DirCk(       TC3,GNU,x!!    Unterroutine zur DirBox*/
void  XbWSPu_DirCk(char *dummy, char *ziel_str,int ypos,int myp){
  if (ziel_str == NULL) { return; };
  if (dummy == NULL) { return; };
  #ifdef XbW_SYSDEF_X11_VERSION
  if ((ypos-5 < myp) & ( ypos+11-5 > myp)) {
    strcpy(ziel_str,dummy);
    };
  #endif
  #ifdef XbW_SYSDEF_GNU_VERSION
  if ((ypos < myp) & ( ypos+11 > myp)) {
    strcpy(ziel_str,dummy);
    };
  #endif
  #ifdef XbW_SYSDEF_X11_VERSION
  if ((ypos < myp) & ( ypos+11 > myp)) {
    strcpy(ziel_str,dummy);
    };
  #endif
  };
/*}}}  */
/*{{{  Directory-Suche  NUR X11*/
 
#ifdef XbW_SYSDEF_X11_VERSION
#include "directory.c"
/*{{{F directory.c*/
/*:::F directory.c*/
/*}}}  */


#endif

/*}}}  */
/*{{{  XbWSPu_DirSb(       TC3,g??,x!!    Unterroutine zur DirBox*/
int  XbWSPu_DirSb(void  *(*p)[],int (*t)[], int dmode){
#define DRAW_PBOX_IN_WDW 1
#define DRAW_PBOX_BORDER 2
#define DRAW_PBOX_THICK  4
  int ll,ypos;
  char *dummy,*spec,*fsp,*ziel_str;
  int xa,ya,xb,yb,filc,frc,txc,dw,anz=0,snr;
  int ziel_max;
  XbWDDb_DbIVar  *ziel_MV;

  if ((int)(*p)[0] < 14) { return(1); };

  /*{{{  switch ( (int)(*t)[1]) {*/
  switch ( (int)(*t)[1]) {
    case XbWDMf_VPPar:
    case XbWDMf_IntPar: xa = (int)(*p)[1]; break;
    case XbWDMf_VLPar:  {
                          XbWDDb_DbIVar  *QQ;
                          QQ = (XbWDDb_DbIVar  *)(*p)[1];
                          if (QQ == NULL) { goto pop_error; };
                          xa = XbWFDb_GetNum(QQ,NULL,1);
                          break;
                          };
    default: goto pop_error;
    };
  /*}}}  */
  /*{{{  switch ( (int)(*t)[2]) {*/
  switch ( (int)(*t)[2]) {
    case XbWDMf_VPPar:
    case XbWDMf_IntPar: ya = (int)(*p)[2]; break;
    case XbWDMf_VLPar:  {
                          XbWDDb_DbIVar  *QQ;
                          QQ = (XbWDDb_DbIVar  *)(*p)[2];
                          if (QQ == NULL) { goto pop_error; };
                          ya = XbWFDb_GetNum(QQ,NULL,1);
                          break;
                          };
    default: goto pop_error;
    };
  /*}}}  */
  /*{{{  switch ( (int)(*t)[3]) {*/
  switch ( (int)(*t)[3]) {
    case XbWDMf_VPPar:
    case XbWDMf_IntPar: xb = (int)(*p)[3]; break;
    case XbWDMf_VLPar:  {
                          XbWDDb_DbIVar  *QQ;
                          QQ = (XbWDDb_DbIVar  *)(*p)[3];
                          if (QQ == NULL) { goto pop_error; };
                          xb = XbWFDb_GetNum(QQ,NULL,1);
                          break;
                          };
    default: goto pop_error;
    };
  /*}}}  */
  /*{{{  switch ( (int)(*t)[4]) {*/
  switch ( (int)(*t)[4]) {
    case XbWDMf_VPPar:
    case XbWDMf_IntPar: yb = (int)(*p)[4]; break;
    case XbWDMf_VLPar:  {
                          XbWDDb_DbIVar  *QQ;
                          QQ = (XbWDDb_DbIVar  *)(*p)[4];
                          if (QQ == NULL) { goto pop_error; };
                          yb = XbWFDb_GetNum(QQ,NULL,1);
                          break;
                          };
    default: goto pop_error;
    };
  /*}}}  */
  /*{{{  switch ( (int)(*t)[5]) {*/
  switch ( (int)(*t)[5]) {
    case XbWDMf_VPPar:
    case XbWDMf_IntPar: filc = (int)(*p)[5]; break;
    case XbWDMf_VLPar:  {
                          XbWDDb_DbIVar  *QQ;
                          QQ = (XbWDDb_DbIVar  *)(*p)[5];
                          if (QQ == NULL) { goto pop_error; };
                          filc = XbWFDb_GetNum(QQ,NULL,1);
                          break;
                          };
    default: goto pop_error;
    };
  /*}}}  */
  /*{{{  switch ( (int)(*t)[6]) {*/
  switch ( (int)(*t)[6]) {
    case XbWDMf_VPPar:
    case XbWDMf_IntPar: frc = (int)(*p)[6]; break;
    case XbWDMf_VLPar:  {
                          XbWDDb_DbIVar  *QQ;
                          QQ = (XbWDDb_DbIVar  *)(*p)[6];
                          if (QQ == NULL) { goto pop_error; };
                          frc = XbWFDb_GetNum(QQ,NULL,1);
                          break;
                          };
    default: goto pop_error;
    };
  /*}}}  */
  /*{{{  switch ( (int)(*t)[7]) {*/
  switch ( (int)(*t)[7]) {
    case XbWDMf_VPPar:
    case XbWDMf_IntPar: txc = (int)(*p)[7]; break;
    case XbWDMf_VLPar:  {
                          XbWDDb_DbIVar  *QQ;
                          QQ = (XbWDDb_DbIVar  *)(*p)[7];
                          if (QQ == NULL) { goto pop_error; };
                          txc = XbWFDb_GetNum(QQ,NULL,1);
                          break;
                          };
    default: goto pop_error;
    };
  /*}}}  */
  /*{{{  switch ( (int)(*t)[8]) {*/
  switch ( (int)(*t)[8]) {
    case XbWDMf_VPPar:
    case XbWDMf_IntPar: dw = (int)(*p)[8]; break;
    case XbWDMf_VLPar:  {
                          XbWDDb_DbIVar  *QQ;
                          QQ = (XbWDDb_DbIVar  *)(*p)[8];
                          if (QQ == NULL) { goto pop_error; };
                          dw = XbWFDb_GetNum(QQ,NULL,1);
                          break;
                          };
    default: goto pop_error;
    };
  /*}}}  */
  /*{{{  switch ( (int)(*t)[9]) {*/
  switch ( (int)(*t)[9]) {
    case XbWDMf_VPPar:
    case XbWDMf_IntPar: anz = (int)(*p)[9]; break;
    case XbWDMf_VLPar:  {
                          XbWDDb_DbIVar  *QQ;
                          QQ = (XbWDDb_DbIVar  *)(*p)[9];
                          if (QQ == NULL) { goto pop_error; };
                          anz = XbWFDb_GetNum(QQ,NULL,1);
                          break;
                          };
    };
  /*}}}  */
  /*{{{  switch ( (int)(*t)[10]) {*/
  switch ( (int)(*t)[10]) {
    case XbWDMf_StrPar: spec = (char*)(*p)[10]; break;
    case XbWDMf_VLPar:  {
                          XbWDDb_DbIVar  *QQ;
                          QQ = (XbWDDb_DbIVar  *)(*p)[10];
                          if (QQ == NULL) { goto pop_error; };
                          spec = (char*)XbWFDb_VarInh(QQ,XbWDDb_Str,NULL,1);
                          strcpy(spec,(char*)XbWFTb_PckTxt(spec));
                          break;
                          };
    default: goto pop_error;
    };
  /*}}}  */
  /*{{{  switch ( (int)(*t)[11]) {*/
  switch ( (int)(*t)[11]) {
    case XbWDMf_StrPar: fsp = (char*)(*p)[11]; break;
    case XbWDMf_VLPar:  {
                          XbWDDb_DbIVar  *QQ;
                          QQ = (XbWDDb_DbIVar  *)(*p)[11];
                          if (QQ == NULL) { goto pop_error; };
                          fsp = (char*)XbWFDb_VarInh(QQ,XbWDDb_Str,NULL,1);
                          strcpy(fsp,(char*)XbWFTb_PckTxt(fsp));
                          break;
                          };
    default: goto pop_error;
    };
  /*}}}  */
  /*{{{  switch ( (int)(*t)[12]) {*/
  switch ( (int)(*t)[12]) {
    case XbWDMf_VPPar:
    case XbWDMf_IntPar: snr = (int)(*p)[12]; break;
    case XbWDMf_VLPar:  {
                          XbWDDb_DbIVar  *QQ;
                          QQ = (XbWDDb_DbIVar  *)(*p)[12];
                          if (QQ == NULL) { goto pop_error; };
                          snr = XbWFDb_GetNum(QQ,NULL,1);
                          break;
                          };
    default: goto pop_error;
    };
  /*}}}  */
  /*{{{  if (!dmode) {*/
  if (!dmode) {
    ziel_str = NULL;
    }
  else {
    switch ( (int)(*t)[13]) {
      case XbWDMf_VLPar:  {
                            XbWDDb_DbIVar  *QQ;
                            QQ = (XbWDDb_DbIVar  *)(*p)[13];
                            if (QQ == NULL) { goto pop_error; };
                            ziel_str = (char*)XbWFDb_VarInh(QQ,XbWDDb_Str,NULL,1);
                            break;
                            };
      default: goto pop_error;
      };
    };
  /*}}}  */
  /*{{{  switch ( (int)(*t)[14]) {*/
  switch ( (int)(*t)[14]) {
    case XbWDMf_VLPar:
        ziel_MV = (XbWDDb_DbIVar  *)(*p)[14];
        if (ziel_MV == NULL) { goto pop_error;};
        break;
    default: goto pop_error;
    };
  /*}}}  */
  /*{{{  XbWFGr_CurOFF();*/
  XbWFGr_CurOFF();
  XbWFGr_PushPort();
  if (dw & DRAW_PBOX_IN_WDW) {
    XbWFGr_MinPort(
      *XbWVWd_W.nx+1,1+ *XbWVWd_W.ny,   *XbWVWd_W.nx+ *XbWVWd_W.sx +1,
      *XbWVWd_W.ny+1+ *XbWVWd_W.sy);
    }
  else {
    XbWFGr_MinPort(
      0,0,XbWFGr_MaxX(),XbWFGr_MaxY());
    };
  if (dw & (DRAW_PBOX_BORDER|DRAW_PBOX_THICK)) {
    XbWSGr_TLBox(xa,ya,xb,yb,NULL,filc,0,frc);
    };
  /*}}}  */
  #ifdef XbW_SYSDEF_TC3_VERSION
    /*{{{  Eigentliche Routine*/
    {
      char fspec[60];
      struct ffblk erg;
    
      ypos = 0;
      sprintf(fspec,"%s%s",spec,fsp);
      ziel_max=0;
      if (!findfirst(fspec,&erg,0)) {
        dummy = erg.ff_name;
        if (snr == 0) {
          XbWSGr_TLBox(xa+3,ya+3+ypos,0,0,dummy,filc,txc,0);
          if (dmode) {
            XbWSPu_DirCk(dummy,ziel_str,ya+3+ypos+*XbWVWd_W.ny,XbWVMs_YPos);
            };
          ypos += 11;
          };
        ll = 1;
        ziel_max=1;
        while (!findnext(&erg))  {
          ziel_max++;
          if (ll < anz+snr-1) {
            dummy = erg.ff_name;
            if (ll >= snr) {
              XbWSGr_TLBox(xa+3,ya+2+ypos,0,0,dummy,filc,txc,0);
              if (dmode) {
                XbWSPu_DirCk(dummy,ziel_str,ya+3+ypos+*XbWVWd_W.ny,XbWVMs_YPos);
                };
              ypos += 11;
              };
            }
          else {
            if (ll >= snr-1) {
              XbWSGr_TLBox(xa+3,ya+2+ypos,0,0,"...",filc,txc,0);
              ypos += 11;
              };
            if (!dmode) {
              while (!findnext(&erg)) {
                ziel_max++;
                };
              };
            goto ende_popup;
            };
          ll++;
          };
        };
      };
    /*}}}  */
  #endif
  #ifdef XbW_SYSDEF_X11_VERSION
    /*{{{  Eigentliche Routine*/
    {
      char *erg;
      ypos = 0;
      ziel_max=0;
      if ((erg=XbWSSy_FindFirst(spec,fsp))!=NULL) {
        dummy = erg;
        if (snr == 0) {
          XbWSGr_TLBox(xa+3,ya+3+ypos,0,0,dummy,filc,txc,0);
          if (dmode) {
            XbWSPu_DirCk(dummy,ziel_str,ya+3+ypos+*XbWVWd_W.ny,XbWVMs_YPos);
            };
          ypos += 11;
          };
        ll = 1;
        ziel_max=1;
        while ((erg=XbWSSy_FindNext())!=NULL)  {
          ziel_max++;
          if (ll < anz+snr-1) {
            dummy = erg;
            if (ll >= snr) {
              XbWSGr_TLBox(xa+3,ya+2+ypos,0,0,dummy,filc,txc,0);
              if (dmode) {
                XbWSPu_DirCk(dummy,ziel_str,ya+3+ypos+*XbWVWd_W.ny,XbWVMs_YPos);
                };
              ypos += 11;
              };
            }
          else {
            if (ll >= snr-1) {
              XbWSGr_TLBox(xa+3,ya+2+ypos,0,0,"...",filc,txc,0);
              ypos += 11;
              };
            if (!dmode) {
              while (XbWSSy_FindNext()!=NULL) {
                ziel_max++;
                };
              };
            goto ende_popup;
            };
          ll++;
          };
        };
      };
    /*}}}  */
  #endif
 
 
  ende_popup:;
  if (!dmode) {
    XbWFDb_PutNum(ziel_MV,NULL,1,ziel_max);
    };
  /*{{{  XbWFGr_PopPort(); XbWFGr_ResPort();*/
  XbWFGr_PopPort(); XbWFGr_ResPort();
  XbWFGr_CurON();
  return(0);
  /*}}}  */
  /*{{{  pop_error:;*/
  pop_error:;
  XbWFGr_PopPort(); XbWFGr_ResPort();
  XbWFGr_CurON();
  /*}}}  */
  return(1);
  };

/*}}}  */
/*}}}  */
/*{{{  XbWSSy_XXXXMem(     TC3,GNU,X11    farcalloc bzw. calloc /-free*/
/*{{{  XbWSSy_AlocMem(     TC3,GNU,X11    farcalloc bzw. calloc*/
void  *XbWSSy_AlocMem(unsigned long a, unsigned long b){
#ifdef XbW_SYSDEF_TC3_VERSION
  return(farcalloc(a,b));
#endif
#ifdef XbW_SYSDEF_GNU_VERSION
  return(calloc(a,b));
#endif
#ifdef XbW_SYSDEF_X11_VERSION
  return(calloc(a,b));
#endif
  };
/*}}}  */
/*{{{  XbWSSy_FreeMem(     TC3,GNU,X11    farfree bzw. free*/
void  XbWSSy_FreeMem(void  *a){
#ifdef XbW_SYSDEF_TC3_VERSION
  farfree(a);
#endif
#ifdef XbW_SYSDEF_GNU_VERSION
  free(a);
#endif
#ifdef XbW_SYSDEF_X11_VERSION
  free(a);
#endif
  };
/*}}}  */
/*}}}  */
/*{{{  XbWSSy_SysXXXX(     TC3,g??,x??    System Stop*/
/*{{{  XbWSSy_SysHalt(     TC3,g??,x??    System Not-Halt*/
void   XbWSSy_SysHalt(void){
#ifdef XbW_SYSDEF_TC3_VERSION
  closegraph();
  textmode(C80);
  textcolor(WHITE);
  textbackground(BLACK);
  clrscr();
#endif
  };
/*}}}  */
/*{{{  XbWSSy_FatalEr(     TC3,g??,x??    Fataler Fehler*/
void   XbWSSy_FatalEr(char text[255]){
#ifdef XbW_SYSDEF_TC3_VERSION
  closegraph();
  textmode(C80);
  textcolor(XbWVGr_Red);
  textbackground(XbWVGr_White);
  clrscr();gotoxy(10,10);printf(text);gotoxy(10,12);exit(1);
#endif
  };
/*}}}  */
/*}}}  */
/*{{{  XbWFSy_doXXXXXXXXXX(t--,g--,X11    X11 only*/
void  XbWFSY_DoXFlush(void){
  XFlush(XbWVSy_ConTxt.dpy);
  };
/*{{{  XbWFSy_doDefineColor(       X11    Farbe allozieren (X11 only)*/
unsigned long  XbWFSy_doDefineColor(int n){
#ifdef XbW_SYSDEF_X11_VERSION
  XColor exakt_color,screen_color;

  if ((XDefaultVisualOfScreen(XbWVSy_ConTxt.screen))->class == TrueColor
      || (XDefaultVisualOfScreen(XbWVSy_ConTxt.screen))->class == PseudoColor
      || (XDefaultVisualOfScreen(XbWVSy_ConTxt.screen))->class == DirectColor
      ||  (XDefaultVisualOfScreen(XbWVSy_ConTxt.screen))->class == StaticColor){
    if (XAllocNamedColor( XbWVSy_ConTxt.dpy, XDefaultColormapOfScreen(XbWVSy_ConTxt.screen),
        XbWVGr_ColorTexte[n-1], &screen_color, &exakt_color)) {
      return screen_color.pixel;
      };
    }
  else {
    switch (n){
      case 1: return(XBlackPixelOfScreen(XbWVSy_ConTxt.screen));
      case 2: return(XWhitePixelOfScreen(XbWVSy_ConTxt.screen));
      case 3: return(XBlackPixelOfScreen(XbWVSy_ConTxt.screen));
      };
    };
#endif
  return(0);
  };

/*}}}  */
/*{{{  XbWFSy_doCreateWindow(      X11    Hauptwindow generieren*/
void  XbWFSy_doCreateWindow(void){
#ifdef XbW_SYSDEF_X11_VERSION
/*  int windowW = XWidthOfScreen(XbWVSy_ConTxt.screen)-10;  */
/*  int windowH = XHeightOfScreen(XbWVSy_ConTxt.screen)-10; */
  int windowW = XbW_X11_ScreenWidth;
  int windowH = XbW_X11_ScreenHeight;
  int windowX = 1;
  int windowY = 1;

  XSetWindowAttributes xswa;
 
  xswa.event_mask =   ExposureMask |
                      ButtonPressMask;

  xswa.background_pixel = XbWFSy_doDefineColor(8);
  xswa.backing_store    = WhenMapped;
  xswa.save_under       = 0;
  xswa.cursor           = 5;

  XbWVGr_ColorValues[0]  = XbWFSy_doDefineColor(1);
  XbWVGr_ColorValues[1]  = XbWFSy_doDefineColor(2);
  XbWVGr_ColorValues[2]  = XbWFSy_doDefineColor(3);
  XbWVGr_ColorValues[3]  = XbWFSy_doDefineColor(4);
  XbWVGr_ColorValues[4]  = XbWFSy_doDefineColor(5);
  XbWVGr_ColorValues[5]  = XbWFSy_doDefineColor(6);
  XbWVGr_ColorValues[6]  = XbWFSy_doDefineColor(7);
  XbWVGr_ColorValues[7]  = XbWFSy_doDefineColor(8);
  XbWVGr_ColorValues[8]  = XbWFSy_doDefineColor(9);
  XbWVGr_ColorValues[9]  = XbWFSy_doDefineColor(10);
  XbWVGr_ColorValues[10] = XbWFSy_doDefineColor(11);
  XbWVGr_ColorValues[11] = XbWFSy_doDefineColor(12);
  XbWVGr_ColorValues[12] = XbWFSy_doDefineColor(13);
  XbWVGr_ColorValues[13] = XbWFSy_doDefineColor(14);
  XbWVGr_ColorValues[14] = XbWFSy_doDefineColor(15);
  XbWVGr_ColorValues[15] = XbWFSy_doDefineColor(16);
 
  XbWVGr_ColorValues[16] = XbWFSy_doDefineColor(17);
  XbWVGr_ColorValues[17] = XbWFSy_doDefineColor(18);
  XbWVGr_ColorValues[18] = XbWFSy_doDefineColor(19);
  XbWVGr_ColorValues[19] = XbWFSy_doDefineColor(20);
  XbWVGr_ColorValues[20] = XbWFSy_doDefineColor(21);
  XbWVGr_ColorValues[21] = XbWFSy_doDefineColor(22);
  XbWVGr_ColorValues[22] = XbWFSy_doDefineColor(23);
  XbWVGr_ColorValues[23] = XbWFSy_doDefineColor(24);
  XbWVGr_ColorValues[24] = XbWFSy_doDefineColor(25);
  XbWVGr_ColorValues[25] = XbWFSy_doDefineColor(26);
  XbWVGr_ColorValues[26] = XbWFSy_doDefineColor(27);
  XbWVGr_ColorValues[27] = XbWFSy_doDefineColor(28);
  XbWVGr_ColorValues[28] = XbWFSy_doDefineColor(29);
  XbWVGr_ColorValues[29] = XbWFSy_doDefineColor(30);
  XbWVGr_ColorValues[30] = XbWFSy_doDefineColor(31);
  XbWVGr_ColorValues[31] = XbWFSy_doDefineColor(32);

 
  XbWVSy_ConTxt.window =
    XCreateWindow(
      XbWVSy_ConTxt.dpy,
      XRootWindowOfScreen(XbWVSy_ConTxt.screen),
      windowX,
      windowY,
      windowW,
      windowH, 0,
      XDefaultDepthOfScreen(XbWVSy_ConTxt.screen),
      InputOutput,
      XDefaultVisualOfScreen(XbWVSy_ConTxt.screen),
      CWEventMask | CWBackPixel,
      &xswa
      );
#endif
  };


/*}}}  */
/*{{{  XbWFSy_doUnmapWindows(      X11    Windowdarstellung ENDE*/
void  XbWFSy_doUnmapWindows(void){
#ifdef XbW_SYSDEF_X11_VERSION
  XUnmapWindow(XbWVSy_ConTxt.dpy, XbWVSy_ConTxt.window);
  XDestroyWindow(XbWVSy_ConTxt.dpy, XbWVSy_ConTxt.window);
  XCloseDisplay(XbWVSy_ConTxt.dpy);
#endif
  };


/*}}}  */
/*}}}  */
/*{{{  XbWSSy_SubWindow(*/
int  XbWSSy_SubWindow(int x, int y, int sx, int sy){
  static GC gc;
  static Window wdw;
  static GC org_gc;
  static Window org_wdw;
  static int active = 0;
 
  if (!active){
    /*{{{  */
    {
      XGCValues xgcv;
      XSetWindowAttributes xswa;
      xgcv.background = XbWFSy_doDefineColor(3);
      xgcv.background = XbWFSy_doDefineColor(3);
    
      xswa.event_mask =   ExposureMask |
                          ButtonPressMask;
    
      xswa.background_pixel = XbWFSy_doDefineColor(8);
      xswa.backing_store    = WhenMapped;
      xswa.save_under       = 0;
      xswa.cursor           = 5;
    
    
      wdw = XCreateWindow(
          XbWVSy_ConTxt.dpy,
          XRootWindowOfScreen(XbWVSy_ConTxt.screen),
          x,
          y,
          sx,
          sy, 0,
          XDefaultDepthOfScreen(XbWVSy_ConTxt.screen),
          InputOutput,
          XDefaultVisualOfScreen(XbWVSy_ConTxt.screen),
          CWEventMask | CWBackPixel,
          &xswa
          );
      gc = XCreateGC(XbWVSy_ConTxt.dpy,wdw, GCForeground | GCBackground, &xgcv);
      };
    
    XSetFont(XbWVSy_ConTxt.dpy, gc, XbWVSy_ConTxt.font);
    
    {
      XSizeHints xsh;
    
      xsh.x = x;
      xsh.y = y;
      xsh.width =  sx;
      xsh.height = sy;
      xsh.max_width =  sx;
      xsh.max_height = sy;
      xsh.flags = PMinSize | PMaxSize | PPosition | PSize;
    
      XSetWMNormalHints(XbWVSy_ConTxt.dpy, wdw, &xsh);
      XStoreName(XbWVSy_ConTxt.dpy, wdw, " Answer Request");
      XSetIconName(XbWVSy_ConTxt.dpy, wdw, "");
      };
    
    XSelectInput(
      XbWVSy_ConTxt.dpy,
      wdw,
        KeyPressMask|
        KeyReleaseMask|
        ButtonPressMask|
        ExposureMask|
        ButtonReleaseMask|
        OwnerGrabButtonMask|
        PointerMotionHintMask|
        PointerMotionMask|
        ButtonMotionMask|
        EnterWindowMask|
        LeaveWindowMask
      );
    
    org_gc = XbWVSy_ConTxt.gc;
    org_wdw = XbWVSy_ConTxt.window;
    XMapWindow(XbWVSy_ConTxt.dpy, wdw);
    XbWVSy_ConTxt.gc=gc;
    XbWVSy_ConTxt.window=wdw;
    active=1;
    /*}}}  */
    }
  else {
    XUnmapWindow(XbWVSy_ConTxt.dpy, wdw);
    XbWVSy_ConTxt.gc=org_gc;
    XbWVSy_ConTxt.window=org_wdw;
    active=0;
    };

  return(0);
  };

/*}}}  */
/*{{{  XbWSSy_ResetWM(     TC3,GNU,X11    HAUPTPROGRAMM DES XBW-SYSTEMS*/
/*int  XbWSSy_ResetWM(int argc, char *argv[]){*/
void XbWPSy_InitHooks(void);


int  XbWSSy_ResetWM(int argc, char *argv[]){
  int ii;
  char cwinp[200];
  XbWVSy_ConTxt.is_a_key_waiting = 0;

  puts("");
  puts("");
  XbWFSy_bf_printf("%s\n","XbW - the X11 user interface without 'bells and whistles'");
  puts("");
  puts("            (C) 1994 Hendrik Maroske");
  puts("");
  XbWFSy_bf_printf("%s\n","Use and distribution restricted to the following:");
  puts("This program is free as long as you do not make");
  puts("money by selling it. In any other case, you are");
  puts("enforced to contact the author.");
  puts("");
  puts("I don't care if you create user interfaces with");
  printf("this program and sell "); XbWFSy_bf_printf("%s","them"); puts(", als long as you");
  puts("do not sell this program. You are enforced to");
  puts("distribute this program in the same form");
  puts("you have received it; especially in combination");
  puts("with user interfaces that you sell.");
  puts("");
  puts("I will distribute C sources as soon as I can.");
  puts("Until then, you will have to rely on the library");
  puts("file only, sorry.");
  puts("");
 
  if (argc < 2) {
    puts("Usage:");
    puts("xbw Metafile.mta");
    puts("xbw Database.prj");
    puts("xbw CSource.c");
    puts("");
    exit(1);
    };
 
  XbWVIDEO_XA = 1;
  XbWVIDEO_YA = 18;
  XbWVIDEO_XB = XbWSGr_GtPhysX();
  XbWVIDEO_YB = XbWSGr_GtPhysY();
 
  XbWVDb_DbkStat = 0;

#ifdef XbW_SYSDEF_TC3_VERSION
  randomize();
#endif
#ifdef XbW_SYSDEF_GNU_VERSION
  if ((XbWVSy_ConTxt.top.txo_font = GrLoadFont("pc8x8.fnt")) == NULL) {return(1);};
  XbWVSy_ConTxt.top.txo_xmag = 1;
  XbWVSy_ConTxt.top.txo_ymag = 1;
  XbWVSy_ConTxt.top.txo_direct = GR_TEXT_RIGHT;
  XbWVSy_ConTxt.top.txo_xalign = GR_ALIGN_LEFT;
  XbWVSy_ConTxt.top.txo_yalign = GR_ALIGN_TOP;
  XbWVSy_ConTxt.top.txo_chrtype = GR_BYTE_TEXT;
#endif
#ifdef XbW_SYSDEF_X11_VERSION
  XbWVIDEO_XA = 0;
  XbWVIDEO_YA = 0;
  XbWVIDEO_XB = XbW_X11_ScreenWidth;
  XbWVIDEO_YB = XbW_X11_ScreenHeight;
 
  XbWVSy_ConTxt.dpy = XOpenDisplay(0);
  if (!XbWVSy_ConTxt.dpy){
    printf("ERROR: Could not open X11 Display!");
    exit(-1);
    };
  XbWVSy_ConTxt.screen = XDefaultScreenOfDisplay(XbWVSy_ConTxt.dpy);
 
  /* XSynchronize(XbWVSy_ConTxt.dpy,1); */

  XbWFSy_doCreateWindow();
  {
    XGCValues xgcv;
    xgcv.foreground = XbWFSy_doDefineColor(3);
    xgcv.background = XbWFSy_doDefineColor(3);

    XbWVSy_ConTxt.gc = XCreateGC(XbWVSy_ConTxt.dpy,
          XbWVSy_ConTxt.window, GCForeground | GCBackground, &xgcv);
    };

  {
    XbWVSy_ConTxt.font = XLoadFont(XbWVSy_ConTxt.dpy,
      "-schumacher-*-bold-r-normal-*-10-*-*-*-c-*-iso8859-1"
      );
    XSetFont(XbWVSy_ConTxt.dpy, XbWVSy_ConTxt.gc, XbWVSy_ConTxt.font);
    };

  {
    XSizeHints xsh;
 
    xsh.x = 30;
    xsh.y = 30;
    xsh.width =  XbW_X11_ScreenWidth;
    xsh.height = XbW_X11_ScreenHeight;
    xsh.max_width =  XWidthOfScreen(XbWVSy_ConTxt.screen)-31;
    xsh.max_height = XHeightOfScreen(XbWVSy_ConTxt.screen)-31;
    xsh.flags = PMinSize | PMaxSize |/* PPosition |*/ PSize;

    XSetWMNormalHints(XbWVSy_ConTxt.dpy, XbWVSy_ConTxt.window, &xsh);
    XStoreName(XbWVSy_ConTxt.dpy, XbWVSy_ConTxt.window, XbWDSy_WindowName);
    XSetIconName(XbWVSy_ConTxt.dpy, XbWVSy_ConTxt.window, "XbW");
    };
 
  XSelectInput(
    XbWVSy_ConTxt.dpy,
    XbWVSy_ConTxt.window,
      KeyPressMask|
      KeyReleaseMask|
      ButtonPressMask|
      ExposureMask|
      ButtonReleaseMask|
      OwnerGrabButtonMask|
      PointerMotionHintMask|
      PointerMotionMask|
      ButtonMotionMask|
      EnterWindowMask|
      LeaveWindowMask
    );

  XMapWindow(XbWVSy_ConTxt.dpy, XbWVSy_ConTxt.window);

#endif
  XbWFGr_MaxPort(); XbWFGr_PushPort();
  XbWSMs_DrInit();
  XbWFGr_MinPort(XbWVIDEO_XA,XbWVIDEO_YA,XbWFGr_MaxX(),XbWFGr_MaxY());
  XbWFWd_BackGr();
  XbWFMf_initMta();
  XbWPSy_InitHooks();
  strcpy(XbWVSy_SysPath,"\\XW\\");
  strcpy(XbWVSy_AppPath,"\\XW\\");
  strcpy(XbWVSy_PrjPath,"\\XW\\");
  ii = 1;
  while (ii < argc) {
    strcpy(cwinp,(char*)argv[ii]);
    strupr(cwinp);
    if (strstr(cwinp,".PRJ") != NULL) {
      XbWFMf_ReadMF("specials/xbwfaststart");
      XbWFTb_Message((char*)argv[ii]);
      {
        void  *ap[2] = {(void *)1,(void*)argv[ii]};
        int at[2] = { XbWDMf_IntPar,
                      XbWDMf_StrPar };
        XbWFDb_OpenSys(&ap,&at);
        goto done;
        };
      };
    if (strstr(cwinp,".MTA") != NULL) {
      XbWFTb_Message((char*)argv[ii]);
      XbWFMf_ReadMF((char*)argv[ii]);
      goto done;
      };
    if (strstr(cwinp,".XWX") != NULL) {
      XbWFTb_Message((char*)argv[ii]);
      XbWFMf_ReadMF((char*)argv[ii]);
      goto done;
      };
    if (strstr(cwinp,".C") != NULL) {
      XbWFTb_Message((char*)argv[ii]);
      XbWFMf_ReadMF((char*)argv[ii]);
      printf("Compiling your program %s\n",(char*)argv[ii]);
      XbWFTb_Message("Starting compiler; please wait...");
      {
        char sstr[500];
        char progname[200];
        sprintf(progname,(char*)argv[ii]);
        strcpy(strstr(progname,".c"),"\0");
        sprintf(sstr,"cc -o %s %s",progname,(char*)argv[ii]);
        printf("Executing %s\n",sstr);
        system(sstr);
        printf("\nOK, done with compiling. Resuming your Application.\n");
        strcat(progname,".xwx");
        printf("\nRem.: if you create a symbolic link to %s and start xbw\n",
          progname);
        printf("with 'xbw %s', I will not fire up the compiler every time.\n",
          progname);
        };
      goto done;
      };
 
    XbWFMf_ReadMF((char*)argv[ii]);
    done:;
    ii++;
    };
  if (XbWVWd_Activ){
    XbWFWd_WManager();
    };
  XbWSMs_Stop();
#ifdef XbW_SYSDEF_X11Version
  XbWFSy_doUnmapWindows();
#endif
  XbWFSy_SysStop();
  XbWSGr_Close();
  return(0);
  };

/*}}}  */
/*{{{  XbWSSy_RootWindow           X11    Groesse des Rootwindows aendern*/
int XbWSSy_RootWindow(void  *(*p)[],int (*t)[]){
  int xsize,ysize;
  int windowW;
  int windowH;
  XSizeHints xsh;
  if ((int)(*p)[0] < 2 ) {return(1);};
  switch( (int)(*t)[1] ) {
    case XbWDMf_IntPar:
      xsize = (int)(*p)[1];
      break;
    case XbWDMf_VLPar:
      {
        XbWDDb_DbIVar  *QQ;
        QQ = (XbWDDb_DbIVar  *)(*p)[1];
        if (QQ == NULL) { return(1); };
        xsize = XbWFDb_GetNum(QQ,NULL,1);
        };
      break;
    };
  switch( (int)(*t)[2] ) {
    case XbWDMf_IntPar:
      ysize = (int)(*p)[2];
      break;
    case XbWDMf_VLPar:
      {
        XbWDDb_DbIVar  *QQ;
        QQ = (XbWDDb_DbIVar  *)(*p)[2];
        if (QQ == NULL) { return(1); };
        ysize = XbWFDb_GetNum(QQ,NULL,1);
        };
      break;
    };
 
 
  windowW = xsize*XbWFGr_TWidth("M");
  windowH = ysize*XbWFGr_THeight();
  XbW_X11_ScreenWidth=windowW;
  XbW_X11_ScreenHeight=windowH;
  XbWVIDEO_XB = XbW_X11_ScreenWidth;
  XbWVIDEO_YB = XbW_X11_ScreenHeight;
 
  xsh.width =  windowW;
  xsh.height = windowH;
  xsh.flags = PSize;
  XSetWMNormalHints(XbWVSy_ConTxt.dpy, XbWVSy_ConTxt.window, &xsh);
  XbWSMs_SetClockCursor();
  XResizeWindow(
          XbWVSy_ConTxt.dpy,
          XbWVSy_ConTxt.window,
          windowW,
          windowH);
  XbWSMs_SetArrowCursor();
  XMapWindow(XbWVSy_ConTxt.dpy, XbWVSy_ConTxt.window);
  sleep(1);
  XbWFWd_DrawAll();
  return(0);
  };
/*}}}  */
/*{{{  XbWSSy_LoadFont(char *fontname){*/
int XbWSSy_LoadFont(char *fontname){
    XUnloadFont(XbWVSy_ConTxt.dpy, XbWVSy_ConTxt.font);
    XbWVSy_ConTxt.font = XLoadFont(XbWVSy_ConTxt.dpy,fontname);
    XSetFont(XbWVSy_ConTxt.dpy, XbWVSy_ConTxt.gc, XbWVSy_ConTxt.font);
    return(1);
    };
/*}}}  */


