-----------------------------------------------------------
--                   Eiffel/S examples                   --
-----------------------------------------------------------
--               Copyright (C) 1991 - 1993               --
--                           by                          --
--                   SiG Computer GmbH                   --
--                  All rights reserved                  --
-----------------------------------------------------------
-- Release : 1.3 - October 1993                          --
-----------------------------------------------------------
-- Authors : Lambert Strether & Michael Schweitzer       --
-----------------------------------------------------------
  
class   PSDO_SH

inherit
    INTERACT
    end

    SYSTEM_TIME
    end

creation
    make

feature

    make is

        local
            cmd : CHARACTER
            err : BOOLEAN

        do
            if not err then
                io.put_string ("Use 'h' for help%N")

                from
                    get_a_character (">") 
                    cmd := the_character
                until
                    cmd = 'q'
                loop
                    if cmd = 'h' then
                        show_commands
                    elseif cmd = 'c' then
                        change_cluster
                    elseif cmd = 'l' then
                        list_cluster
                    elseif cmd = 'p' then
                        print_cluster
                    else
                        io.put_string ("Unknown command; use 'h' for help%N")
                    end

                    get_a_character (">") 
                    cmd := the_character
                end
            end

            io.put_newline

        rescue
            err := true
            retry
        end
-----------------------------------------------------------

    show_commands is

        do
            io.put_string ("cc : change to another cluster%N")
            io.put_string ("lc : list the contents of this cluster%N")
            io.put_string ("pc : print current cluster%N")
            io.put_newline
        end
-----------------------------------------------------------

    change_cluster is

        local
            error : BOOLEAN

        do
            if not error then
                get_a_string ("Name of new cluster : ") 

                if fs.cluster_exists (the_string) then
                    fs.change_cluster (the_string)
                else
                    io.put_string ("That was not a valid cluster name%N")
                end
            end

        rescue
            if last_ecode /= USER_ABORT then
                io.put_string ("That was not a valid cluster name%N")
                io.put_string ("or else you do not have permission%N")
                error := true
                retry
            end
        end
-----------------------------------------------------------

    list_cluster is

        local
            cl    : SORTED_LIST [FSYS_DAT]
            it    : ITERATOR
            error : BOOLEAN

        do
            if not error then
                from
                    cl := fs.cluster_list (fs.current_cluster) 
                    it := cl.iterator
                until
                    it.finished
                loop
                    show_info (cl.item (it), true)
                    it.forth
                end

                from
                    cl := fs.file_list (fs.current_cluster) 
                    it := cl.iterator
                until
                    it.finished
                loop
                    show_info (cl.item (it), false)
                    it.forth
                end

                io.put_newline
            end

        rescue
            io.put_string ("You do not have permission to list%N")
            io.put_string (last_ecall)

            if last_etext /= void then
                io.put_string ("; ")
                io.put_string (last_etext)
            end

            io.put_string ("; ")
            io.put_int (last_ecode)
            io.put_newline
            error := true
            retry
        end
----------------------------------------------------------- 

    print_cluster is

        do
            io.put_string (fs.current_cluster)
            io.put_newline
        end
-----------------------------------------------------------

    show_info (fd : FSYS_DAT, is_clstr : BOOLEAN) is

        do
            io.put_string (fd.perm)

            if is_clstr then
                io.put_string ("     ")
            else
                io.put_string ("  ")
            end

            io.put_string (fmt.i2s ("6", fd.count))
            io.put_string ("  ")
            show_date (fd.time)
            io.put_string ("  ")
            io.put_string (fd.name)
            io.put_newline
        end
-----------------------------------------------------------

    show_date (tm : REAL) is

        do
            to_date (tm)
            io.put_string (fmt.i2s ("2", hour))
            io.put_char (':')
            io.put_string (fmt.i2s ("02", minute))
            io.put_string ("  ")
            io.put_string (month_name.item (month))
            io.put_char (' ')
            io.put_string (fmt.i2s ("2", day))
            io.put_string (", ")
            io.put_string (fmt.i2s ("4", year))
        end
-----------------------------------------------------------

    month_name : ARRAY [STRING] is

        do
            !!result.make (1, 12)
            result.put ("Jan", 1)
            result.put ("Feb", 2)
            result.put ("Mar", 3)
            result.put ("Apr", 4)
            result.put ("May", 5)
            result.put ("Jun", 6)
            result.put ("Jul", 7)
            result.put ("Aug", 8)
            result.put ("Sep", 9)
            result.put ("Oct", 10)
            result.put ("Nov", 11)
            result.put ("Dec", 12)
        end

end -- class PSDO_SH

